/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.ui;

import io.github.dsheirer.gui.control.JFrequencyControl;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.properties.SystemProperties;
import io.github.dsheirer.record.wave.IRecordingStatusListener;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.ISourceEventProcessor;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.TunerEvent;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.IDiscoveredTunerStatusListener;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.manager.TunerStatus;
import io.github.dsheirer.util.SwingUtils;
import io.github.dsheirer.util.ThreadPool;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.text.StringCharacterIterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TunerEditor<T extends Tuner, C extends TunerConfiguration>
extends JPanel
implements IDiscoveredTunerStatusListener,
Listener<TunerEvent> {
    private Logger mLog = LoggerFactory.getLogger(TunerEditor.class);
    private static final String BUTTON_STATUS_ENABLE = "Enable";
    private static final String BUTTON_STATUS_DISABLE = "Disable";
    private static final long serialVersionUID = 1L;
    private UserPreferences mUserPreferences;
    private TunerManager mTunerManager;
    private DiscoveredTuner mDiscoveredTuner;
    private C mTunerConfiguration;
    private FrequencyAndCorrectionChangeListener mFrequencyAndCorrectionChangeListener = new FrequencyAndCorrectionChangeListener();
    private JFrequencyControl mFrequencyControl;
    private JSpinner mFrequencyCorrectionSpinner;
    private JButton mEnabledButton;
    private JButton mViewSpectrumButton;
    private JButton mNewSpectrumButton;
    private JButton mRestartTunerButton;
    private JToggleButton mRecordButton;
    private ButtonPanel mButtonsPanel;
    private FrequencyPanel mFrequencyPanel;
    private JLabel mTunerIdLabel;
    private JCheckBox mAutoPPMCheckBox;
    private JLabel mMeasuredPPMLabel;
    private JLabel mRecordingStatusLabel;
    private JLabel mTunerStatusLabel;
    private JLabel mTunerLockedStatusLabel;
    private boolean mLoading = false;

    public TunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredTuner discoveredTuner) {
        this.mUserPreferences = userPreferences;
        this.mTunerManager = tunerManager;
        this.mDiscoveredTuner = discoveredTuner;
        if (this.mDiscoveredTuner != null && this.mDiscoveredTuner.hasTunerConfiguration()) {
            this.mTunerConfiguration = this.mDiscoveredTuner.getTunerConfiguration();
        }
        if (this.mDiscoveredTuner != null) {
            this.mDiscoveredTuner.addTunerStatusListener(this);
            if (this.mDiscoveredTuner.hasTuner()) {
                this.mDiscoveredTuner.getTuner().addTunerEventListener(this);
                if (!this.mDiscoveredTuner.hasTunerConfiguration()) {
                    this.mLog.warn("Tuner does not have a tuner configuration ....");
                }
            }
        }
    }

    protected boolean isLoading() {
        return this.mLoading;
    }

    protected void setLoading(boolean loading) {
        this.mLoading = loading;
    }

    protected JLabel getMeasuredPPMLabel() {
        if (this.mMeasuredPPMLabel == null) {
            this.mMeasuredPPMLabel = new JLabel("");
            this.mMeasuredPPMLabel.setToolTipText("Displays the measured frequency error and PPM when provided by compatible channel decoders");
        }
        return this.mMeasuredPPMLabel;
    }

    protected JLabel getTunerLockedStatusLabel() {
        if (this.mTunerLockedStatusLabel == null) {
            this.mTunerLockedStatusLabel = new JLabel("Channel(s) active - frequency and sample rate controls are locked");
            this.mTunerLockedStatusLabel.setToolTipText("Indicates that the tuner is providing channel(s) and you can't change the tuner frequency or sample rate");
            this.mTunerLockedStatusLabel.setVisible(false);
        }
        return this.mTunerLockedStatusLabel;
    }

    protected JLabel getTunerStatusLabel() {
        if (this.mTunerStatusLabel == null) {
            this.mTunerStatusLabel = new JLabel(" ");
        }
        return this.mTunerStatusLabel;
    }

    protected JLabel getRecordingStatusLabel() {
        if (this.mRecordingStatusLabel == null) {
            this.mRecordingStatusLabel = new JLabel(" ");
            this.mRecordingStatusLabel.setToolTipText("Shows the status of the latest baseband recording when active");
            this.mRecordingStatusLabel.setVisible(false);
        }
        return this.mRecordingStatusLabel;
    }

    protected JCheckBox getAutoPPMCheckBox() {
        if (this.mAutoPPMCheckBox == null) {
            this.mAutoPPMCheckBox = new JCheckBox("Enable decoder(s) to auto-adjust PPM");
            this.mAutoPPMCheckBox.setToolTipText("Allow decoders to measure channel frequency error and correct tuner PPM");
            this.mAutoPPMCheckBox.addActionListener(e -> {
                T tuner;
                if (!this.isLoading() && (tuner = this.getTuner()) != null) {
                    boolean enabled = this.getAutoPPMCheckBox().isSelected();
                    ((Tuner)this.getTuner()).getTunerController().getFrequencyErrorCorrectionManager().setEnabled(enabled);
                    this.save();
                }
            });
        }
        return this.mAutoPPMCheckBox;
    }

    protected JLabel getTunerIdLabel() {
        if (this.mTunerIdLabel == null) {
            this.mTunerIdLabel = new JLabel(" ");
        }
        return this.mTunerIdLabel;
    }

    protected FrequencyPanel getFrequencyPanel() {
        if (this.mFrequencyPanel == null) {
            this.mFrequencyPanel = new FrequencyPanel();
            this.mFrequencyPanel.setToolTipText("Tuner frequency and PPM controls");
        }
        return this.mFrequencyPanel;
    }

    protected JSpinner getFrequencyCorrectionSpinner() {
        if (this.mFrequencyCorrectionSpinner == null) {
            SpinnerNumberModel model = new SpinnerNumberModel(0.0, -1000.0, 1000.0, 0.1);
            this.mFrequencyCorrectionSpinner = new JSpinner(model);
            this.mFrequencyCorrectionSpinner.setToolTipText("Adjust the PPM value to compensate for tuner frequency error");
            this.mFrequencyCorrectionSpinner.setEnabled(false);
            JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.mFrequencyCorrectionSpinner.getEditor();
            DecimalFormat format = editor.getFormat();
            format.setMinimumFractionDigits(1);
            editor.getTextField().setHorizontalAlignment(0);
            this.mFrequencyCorrectionSpinner.addChangeListener(this.mFrequencyAndCorrectionChangeListener);
        }
        return this.mFrequencyCorrectionSpinner;
    }

    protected ButtonPanel getButtonPanel() {
        if (this.mButtonsPanel == null) {
            this.mButtonsPanel = new ButtonPanel();
            this.mButtonsPanel.setToolTipText("Button controls for the selected tuner");
        }
        return this.mButtonsPanel;
    }

    protected JFrequencyControl getFrequencyControl() {
        if (this.mFrequencyControl == null) {
            this.mFrequencyControl = new JFrequencyControl();
        }
        return this.mFrequencyControl;
    }

    protected JButton getNewSpectrumButton() {
        if (this.mNewSpectrumButton == null) {
            this.mNewSpectrumButton = new JButton("New Spectrum Display");
            this.mNewSpectrumButton.setToolTipText("Show this tuner in a new (separate) spectral display window");
            this.mNewSpectrumButton.addActionListener(e -> {
                T tuner = this.getTuner();
                if (tuner != null) {
                    ThreadPool.CACHED.submit(() -> this.mTunerManager.getDiscoveredTunerModel().broadcast(new TunerEvent((Tuner)tuner, TunerEvent.Event.REQUEST_NEW_SPECTRAL_DISPLAY)));
                }
            });
        }
        return this.mNewSpectrumButton;
    }

    protected JButton getViewSpectrumButton() {
        if (this.mViewSpectrumButton == null) {
            this.mViewSpectrumButton = new JButton("View Spectrum");
            this.mViewSpectrumButton.setToolTipText("Show this tuner in the spectral display");
            this.mViewSpectrumButton.addActionListener(e -> {
                T tuner = this.getTuner();
                if (tuner != null) {
                    SystemProperties.getInstance().set("spectral.display.enabled", true);
                    ThreadPool.CACHED.submit(() -> this.mTunerManager.getDiscoveredTunerModel().broadcast(new TunerEvent((Tuner)tuner, TunerEvent.Event.REQUEST_MAIN_SPECTRAL_DISPLAY)));
                }
            });
        }
        return this.mViewSpectrumButton;
    }

    protected JButton getEnabledButton() {
        if (this.mEnabledButton == null) {
            this.mEnabledButton = new JButton(BUTTON_STATUS_ENABLE);
            this.mEnabledButton.setToolTipText("Enable or disable the tuner for use by sdrtrunk");
            this.mEnabledButton.addActionListener(e -> {
                switch (this.getEnabledButton().getText()) {
                    case "Disable": {
                        this.mLog.info("Disabling " + String.valueOf((Object)this.getDiscoveredTuner().getTunerClass()) + " tuner");
                        this.getDiscoveredTuner().setEnabled(false);
                        break;
                    }
                    case "Enable": {
                        this.mLog.info("Enabling " + String.valueOf((Object)this.getDiscoveredTuner().getTunerClass()) + " tuner");
                        this.getDiscoveredTuner().setEnabled(true);
                        break;
                    }
                    default: {
                        this.mLog.info("None matched");
                    }
                }
            });
        }
        return this.mEnabledButton;
    }

    protected JButton getRestartTunerButton() {
        if (this.mRestartTunerButton == null) {
            this.mRestartTunerButton = new JButton("Restart Tuner");
            this.mRestartTunerButton.setVisible(false);
            this.mRestartTunerButton.setToolTipText("Attempt to restart this tuner to recover from error condition");
            this.mRestartTunerButton.addActionListener(e -> {
                if (!this.hasTuner() && this.getDiscoveredTuner().getTunerStatus() == TunerStatus.ERROR) {
                    this.mLog.info("Restarting " + String.valueOf((Object)this.getDiscoveredTuner().getTunerClass()) + " tuner");
                    this.getDiscoveredTuner().restart();
                }
            });
        }
        return this.mRestartTunerButton;
    }

    protected void turnOffRecorder() {
        if (this.getRecordButton().isSelected()) {
            this.getRecordButton().setSelected(false);
        }
    }

    protected JToggleButton getRecordButton() {
        if (this.mRecordButton == null) {
            this.mRecordButton = new JToggleButton("Record");
            this.mRecordButton.setToolTipText("Create a baseband recording for this tuner");
            this.mRecordButton.setEnabled(false);
            this.mRecordButton.addActionListener(e -> {
                if (this.hasTuner()) {
                    if (this.getRecordButton().isSelected()) {
                        this.getRecordingStatusLabel().setVisible(true);
                        this.getRecordingStatusLabel().setText(" ");
                        ((Tuner)this.getTuner()).getTunerController().startRecorder(this.mUserPreferences, new RecordingStatusListener(), this.getDiscoveredTuner().getTunerClass().name());
                    } else {
                        ((Tuner)this.getTuner()).getTunerController().stopRecorder();
                    }
                }
            });
        }
        return this.mRecordButton;
    }

    protected abstract void save();

    protected C getConfiguration() {
        return this.mTunerConfiguration;
    }

    protected boolean hasConfiguration() {
        return this.mTunerConfiguration != null;
    }

    protected DiscoveredTuner getDiscoveredTuner() {
        return this.mDiscoveredTuner;
    }

    protected abstract void tunerStatusUpdated();

    @Override
    public void tunerStatusUpdated(DiscoveredTuner discoveredTuner, TunerStatus previous, TunerStatus current) {
        SwingUtils.run(() -> {
            this.tunerStatusUpdated();
            if (current == TunerStatus.ENABLED && this.hasTuner()) {
                ((Tuner)this.getTuner()).addTunerEventListener(this);
            }
        });
    }

    @Override
    public void receive(TunerEvent tunerEvent) {
        if (tunerEvent.getEvent().equals((Object)TunerEvent.Event.UPDATE_MEASURED_FREQUENCY_ERROR)) {
            SwingUtils.run(() -> this.getFrequencyPanel().updateFrequencyError());
        }
    }

    public void dispose() {
        this.turnOffRecorder();
        this.getFrequencyControl().clearListeners();
        this.getFrequencyCorrectionSpinner().removeChangeListener(this.mFrequencyAndCorrectionChangeListener);
        if (this.mDiscoveredTuner != null) {
            this.mDiscoveredTuner.removeTunerStatusListener(this);
            if (this.mDiscoveredTuner.hasTuner()) {
                this.mDiscoveredTuner.getTuner().removeTunerEventListener(this);
            }
        }
    }

    public boolean hasTuner() {
        return this.mDiscoveredTuner != null && this.mDiscoveredTuner.hasTuner();
    }

    public T getTuner() {
        if (this.hasTuner()) {
            return (T)this.mDiscoveredTuner.getTuner();
        }
        return null;
    }

    protected void saveConfiguration() {
        this.mTunerManager.saveConfigurations();
    }

    public abstract void setTunerLockState(boolean var1);

    private class FrequencyAndCorrectionChangeListener
    implements ChangeListener,
    ISourceEventProcessor {
        private FrequencyAndCorrectionChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            double value = ((SpinnerNumberModel)TunerEditor.this.getFrequencyCorrectionSpinner().getModel()).getNumber().doubleValue();
            if (TunerEditor.this.hasTuner() && !TunerEditor.this.isLoading()) {
                try {
                    ((Tuner)TunerEditor.this.getTuner()).getTunerController().setFrequencyCorrection(value);
                }
                catch (SourceException e1) {
                    TunerEditor.this.mLog.error("Error setting frequency correction value", (Throwable)e1);
                }
                TunerEditor.this.save();
            }
        }

        @Override
        public void process(SourceEvent event) throws SourceException {
            if (TunerEditor.this.hasTuner() && !TunerEditor.this.isLoading()) {
                TunerEditor.this.save();
            }
        }
    }

    public class FrequencyPanel
    extends JPanel {
        public FrequencyPanel() {
            this.setLayout((LayoutManager)new MigLayout("insets 0,fill", "[][][][][grow,fill]", ""));
            this.add((Component)TunerEditor.this.getFrequencyControl(), "spany 2");
            this.add(new JLabel("PPM:"));
            this.add(TunerEditor.this.getFrequencyCorrectionSpinner());
            this.add((Component)TunerEditor.this.getMeasuredPPMLabel(), "wrap");
            this.add((Component)TunerEditor.this.getAutoPPMCheckBox(), "span");
            this.add((Component)TunerEditor.this.getTunerLockedStatusLabel(), "span");
        }

        public void updateControls() {
            TunerEditor.this.getFrequencyControl().clearListeners();
            TunerEditor.this.getFrequencyControl().addListener(TunerEditor.this.mFrequencyAndCorrectionChangeListener);
            TunerEditor.this.getFrequencyControl().setEnabled(TunerEditor.this.hasTuner() && !((Tuner)TunerEditor.this.getTuner()).getTunerController().isLockedSampleRate());
            TunerEditor.this.getTunerLockedStatusLabel().setVisible(TunerEditor.this.hasTuner() && ((Tuner)TunerEditor.this.getTuner()).getTunerController().isLockedSampleRate());
            TunerEditor.this.getFrequencyCorrectionSpinner().setEnabled(TunerEditor.this.hasTuner());
            TunerEditor.this.getAutoPPMCheckBox().setEnabled(TunerEditor.this.hasTuner());
            Object tuner = TunerEditor.this.getTuner();
            if (tuner != null) {
                TunerEditor.this.getFrequencyControl().setFrequency(((Tuner)tuner).getTunerController().getFrequency(), false);
                TunerEditor.this.getFrequencyCorrectionSpinner().setValue(((Tuner)tuner).getTunerController().getFrequencyCorrection());
                TunerEditor.this.getAutoPPMCheckBox().setSelected(((Tuner)tuner).getTunerController().getFrequencyErrorCorrectionManager().isEnabled());
                TunerEditor.this.getFrequencyControl().addListener(((Tuner)TunerEditor.this.getTuner()).getTunerController());
                ((Tuner)TunerEditor.this.getTuner()).getTunerController().addListener(TunerEditor.this.getFrequencyControl());
                TunerEditor.this.getMeasuredPPMLabel().setText(((Tuner)tuner).getTunerController().getMeasuredErrorStatus());
            } else {
                TunerEditor.this.getFrequencyControl().setFrequency(0L, false);
                TunerEditor.this.getFrequencyCorrectionSpinner().setValue(0);
                TunerEditor.this.getAutoPPMCheckBox().setSelected(false);
                TunerEditor.this.getMeasuredPPMLabel().setText("");
            }
        }

        public void updateFrequencyError() {
            SwingUtils.run(() -> {
                if (TunerEditor.this.hasTuner()) {
                    TunerEditor.this.getMeasuredPPMLabel().setText(((Tuner)TunerEditor.this.getTuner()).getTunerController().getMeasuredErrorStatus());
                } else {
                    TunerEditor.this.getMeasuredPPMLabel().setText("");
                }
            });
        }
    }

    public class ButtonPanel
    extends JPanel {
        public ButtonPanel() {
            this.setLayout((LayoutManager)new MigLayout("insets 0,fill", "[][][][][][grow,fill]", ""));
            this.add(TunerEditor.this.getEnabledButton());
            this.add(TunerEditor.this.getRecordButton());
            this.add(TunerEditor.this.getViewSpectrumButton());
            this.add(TunerEditor.this.getNewSpectrumButton());
            this.add((Component)TunerEditor.this.getRestartTunerButton(), "wrap");
            this.add((Component)TunerEditor.this.getRecordingStatusLabel(), "span");
        }

        public void updateControls() {
            TunerStatus tunerStatus = TunerEditor.this.getDiscoveredTuner().getTunerStatus();
            TunerEditor.this.getRecordButton().setEnabled(tunerStatus.isAvailable() && TunerEditor.this.getDiscoveredTuner().hasTuner());
            TunerEditor.this.getRecordingStatusLabel().setText(" ");
            TunerEditor.this.getViewSpectrumButton().setEnabled(tunerStatus.isAvailable() && TunerEditor.this.getDiscoveredTuner().hasTuner());
            TunerEditor.this.getNewSpectrumButton().setEnabled(tunerStatus.isAvailable() && TunerEditor.this.getDiscoveredTuner().hasTuner());
            TunerEditor.this.getRestartTunerButton().setVisible(tunerStatus == TunerStatus.ERROR);
            if (TunerEditor.this.getDiscoveredTuner().isEnabled()) {
                TunerEditor.this.getEnabledButton().setText(TunerEditor.BUTTON_STATUS_DISABLE);
            } else {
                TunerEditor.this.getEnabledButton().setText(TunerEditor.BUTTON_STATUS_ENABLE);
            }
        }
    }

    public class RecordingStatusListener
    implements IRecordingStatusListener {
        private DecimalFormat mSizeFormat = new DecimalFormat("0.0");

        @Override
        public void update(int fileCount, String file, long size) {
            StringBuilder sb = new StringBuilder();
            sb.append("Recording Size: ").append(RecordingStatusListener.humanReadableByteCount(size));
            sb.append(" File #").append(fileCount).append(": ").append(file);
            String status = sb.toString();
            EventQueue.invokeLater(() -> TunerEditor.this.getRecordingStatusLabel().setText(status));
        }

        public static String humanReadableByteCount(long bytes) {
            long absB;
            long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
            if (absB < 1024L) {
                return bytes + " B";
            }
            long value = absB;
            StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
            for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
                value >>= 10;
                ci.next();
            }
            return String.format("%.1f %cB", (double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current()));
        }
    }
}

