/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.ui;

import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.TunerEvent;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.DiscoveredUSBTuner;
import io.github.dsheirer.source.tuner.manager.IDiscoveredTunerStatusListener;
import io.github.dsheirer.source.tuner.manager.TunerStatus;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.DiscoveredRspDuoTuner1;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.DiscoveredRspDuoTuner2;
import java.awt.EventQueue;
import java.lang.invoke.LambdaMetafactory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveredTunerModel
extends AbstractTableModel
implements Listener<TunerEvent>,
IDiscoveredTunerStatusListener {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(DiscoveredTunerModel.class);
    public static final int COLUMN_TUNER_STATUS = 0;
    public static final int COLUMN_TUNER_CLASS = 1;
    public static final int COLUMN_TUNER_TYPE = 2;
    public static final int COLUMN_FREQUENCY = 3;
    public static final int COLUMN_CHANNEL_COUNT = 4;
    private static final String MHZ = " MHz";
    private static final String[] COLUMN_HEADERS = new String[]{"Status", "Class", "Type", "Frequency", "Channels"};
    private List<DiscoveredTuner> mDiscoveredTuners = new CopyOnWriteArrayList<DiscoveredTuner>();
    private List<Listener<TunerEvent>> mTunerEventListeners = new ArrayList<Listener<TunerEvent>>();
    private DecimalFormat mFrequencyFormat = new DecimalFormat("0.00000");
    private Lock mLock = new ReentrantLock();

    public List<DiscoveredTuner> getAvailableTuners() {
        return this.mDiscoveredTuners.stream().filter(discoveredTuner -> discoveredTuner.hasTuner()).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiscoveredTuner getDiscoveredTuner(Tuner tuner) {
        DiscoveredTuner match = null;
        this.mLock.lock();
        try {
            for (DiscoveredTuner discoveredTuner : this.mDiscoveredTuners) {
                if (!discoveredTuner.hasTuner() || !discoveredTuner.getTuner().equals(tuner)) continue;
                match = discoveredTuner;
                break;
            }
        }
        finally {
            this.mLock.unlock();
        }
        return match;
    }

    public DiscoveredTuner getDiscoveredTuner(int index) {
        this.mLock.lock();
        try {
            if (index < this.mDiscoveredTuners.size()) {
                DiscoveredTuner discoveredTuner = this.mDiscoveredTuners.get(index);
                return discoveredTuner;
            }
        }
        finally {
            this.mLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveredTuner getDiscoveredTuner(String id) {
        DiscoveredTuner discoveredTuner = null;
        this.mLock.lock();
        try {
            Optional<DiscoveredTuner> result = this.mDiscoveredTuners.stream().filter(tuner -> tuner.getId().equals(id)).findFirst();
            if (result.isPresent()) {
                discoveredTuner = result.get();
            }
        }
        finally {
            this.mLock.unlock();
        }
        return discoveredTuner;
    }

    public void addDiscoveredTuner(DiscoveredTuner discoveredTuner) {
        this.mLock.lock();
        try {
            if (!this.mDiscoveredTuners.contains(discoveredTuner)) {
                this.mDiscoveredTuners.add(discoveredTuner);
                int index = this.mDiscoveredTuners.indexOf(discoveredTuner);
                EventQueue.invokeLater(() -> this.fireTableRowsInserted(index, index));
                if (discoveredTuner.hasTuner()) {
                    discoveredTuner.getTuner().addTunerEventListener(this);
                }
                discoveredTuner.addTunerStatusListener(this);
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void releaseDiscoveredTuners() {
        this.mLock.lock();
        ArrayList<DiscoveredTuner> discoveredTuners = new ArrayList<DiscoveredTuner>(this.mDiscoveredTuners);
        try {
            this.mDiscoveredTuners.clear();
            this.fireTableDataChanged();
        }
        finally {
            this.mLock.unlock();
        }
        for (DiscoveredTuner discoveredTuner : discoveredTuners) {
            discoveredTuner.stop();
            discoveredTuner.removeTunerStatusListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDiscoveredTuner(DiscoveredTuner discoveredTuner) {
        mLog.info("Removing discovered tuner: " + discoveredTuner.getId());
        this.mLock.lock();
        try {
            if (this.mDiscoveredTuners.contains(discoveredTuner)) {
                int index = this.mDiscoveredTuners.indexOf(discoveredTuner);
                this.mDiscoveredTuners.remove(discoveredTuner);
                if (EventQueue.isDispatchThread()) {
                    try {
                        this.fireTableRowsDeleted(index, index);
                    }
                    catch (Exception e) {
                        mLog.info("Exception firing table rows deleted for index [" + index + "] on calling event dispatch thread", (Throwable)e);
                    }
                } else {
                    EventQueue.invokeAndWait(() -> {
                        try {
                            this.fireTableRowsDeleted(index, index);
                        }
                        catch (Exception e) {
                            mLog.info("Exception firing table rows deleted for index [" + index + "]", (Throwable)e);
                        }
                    });
                }
                discoveredTuner.stop();
            }
        }
        catch (Exception e) {
            mLog.error("Unexpected error while shutting down discovered tuner", (Throwable)e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean hasTuner(DiscoveredTuner discoveredTuner) {
        return this.mDiscoveredTuners.contains(discoveredTuner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUsbTuner(int bus, String portAddress) {
        boolean hasDevice;
        this.mLock.lock();
        try {
            hasDevice = this.mDiscoveredTuners.stream().filter(tuner -> {
                DiscoveredUSBTuner usbTuner;
                return tuner instanceof DiscoveredUSBTuner && (usbTuner = (DiscoveredUSBTuner)tuner).isAt(bus, portAddress);
            }).findFirst().isPresent();
        }
        finally {
            this.mLock.unlock();
        }
        return hasDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveredTuner removeUsbTuner(int bus, String portAddress) {
        DiscoveredTuner removed = null;
        this.mLock.lock();
        try {
            DiscoveredTuner discoveredTuner = this.mDiscoveredTuners.stream().filter(tuner -> {
                DiscoveredUSBTuner usbTuner;
                return tuner instanceof DiscoveredUSBTuner && (usbTuner = (DiscoveredUSBTuner)tuner).isAt(bus, portAddress);
            }).findFirst().get();
            if (discoveredTuner != null) {
                this.removeDiscoveredTuner(discoveredTuner);
                removed = discoveredTuner;
            }
        }
        finally {
            this.mLock.unlock();
        }
        return removed;
    }

    public void addListener(Listener<TunerEvent> listener) {
        this.mTunerEventListeners.add(listener);
    }

    public void removeListener(Listener<TunerEvent> listener) {
        this.mTunerEventListeners.remove(listener);
    }

    public void broadcast(TunerEvent event) {
        for (Listener<TunerEvent> listener : this.mTunerEventListeners) {
            listener.receive(event);
        }
    }

    @Override
    public void tunerStatusUpdated(DiscoveredTuner discoveredTuner, TunerStatus previous, TunerStatus current) {
        if (current == TunerStatus.ENABLED && discoveredTuner.hasTuner()) {
            discoveredTuner.getTuner().addTunerEventListener(this);
            int row = this.mDiscoveredTuners.indexOf(discoveredTuner);
            EventQueue.invokeLater(() -> this.fireTableRowsUpdated(row, row));
            return;
        }
        if (current == TunerStatus.DISABLED) {
            int row = this.mDiscoveredTuners.indexOf(discoveredTuner);
            EventQueue.invokeLater(() -> this.fireTableRowsUpdated(row, row));
            return;
        }
        if (current == TunerStatus.REMOVED) {
            DiscoveredRspDuoTuner2 slave2;
            DiscoveredRspDuoTuner1 master1;
            mLog.info("Tuner removal detected - stopping and removing: " + String.valueOf(discoveredTuner));
            if (discoveredTuner instanceof DiscoveredRspDuoTuner1 && (master1 = (DiscoveredRspDuoTuner1)discoveredTuner).getDeviceInfo().getDeviceSelectionMode().isMasterMode()) {
                DiscoveredTuner slave22 = this.getDiscoveredTuner(master1.getSlaveId());
                if (slave22 != null) {
                    this.removeDiscoveredTuner(slave22);
                }
                this.removeDiscoveredTuner(discoveredTuner);
            } else if (discoveredTuner instanceof DiscoveredRspDuoTuner2 && (slave2 = (DiscoveredRspDuoTuner2)discoveredTuner).getDeviceInfo().getDeviceSelectionMode().isSlaveMode()) {
                String masterId = slave2.getMasterId();
                this.removeDiscoveredTuner(slave2);
                DiscoveredTuner master12 = this.getDiscoveredTuner(masterId);
                if (master12 != null) {
                    this.removeDiscoveredTuner(master12);
                }
            } else {
                this.removeDiscoveredTuner(discoveredTuner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void receive(TunerEvent event) {
        if (event.hasTuner()) {
            this.mLock.lock();
            try {
                matching = this.getDiscoveredTuner(event.getTuner());
                index = this.mDiscoveredTuners.indexOf(matching);
                if (index < 0) ** GOTO lbl26
                switch (1.$SwitchMap$io$github$dsheirer$source$tuner$TunerEvent$Event[event.getEvent().ordinal()]) {
                    case 1: {
                        EventQueue.invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$receive$8(int ), ()V)((DiscoveredTunerModel)this, (int)index));
                        ** break;
lbl11:
                        // 1 sources

                    }
                    case 2: {
                        EventQueue.invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$receive$9(int ), ()V)((DiscoveredTunerModel)this, (int)index));
                        ** break;
lbl15:
                        // 1 sources

                    }
                    case 3: {
                        EventQueue.invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$receive$10(int ), ()V)((DiscoveredTunerModel)this, (int)index));
                        ** break;
lbl19:
                        // 1 sources

                    }
                    ** default:
lbl21:
                    // 1 sources

                }
            }
            finally {
                this.mLock.unlock();
            }
        } else {
            DiscoveredTunerModel.mLog.error("Got a tuner event without a tuner - " + String.valueOf(event));
        }
lbl26:
        // 6 sources

        this.broadcast(event);
    }

    @Override
    public int getRowCount() {
        return this.mDiscoveredTuners.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_HEADERS.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.mDiscoveredTuners.size()) {
            DiscoveredTuner discoveredTuner = this.mDiscoveredTuners.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return discoveredTuner.getTunerStatus();
                }
                case 1: {
                    return discoveredTuner.getTunerClass().toString();
                }
                case 2: {
                    if (discoveredTuner.hasTuner()) {
                        return discoveredTuner.getTuner().getTunerType().getLabel();
                    }
                    return "";
                }
                case 3: {
                    if (discoveredTuner.hasTuner()) {
                        long frequency = discoveredTuner.getTuner().getTunerController().getFrequency();
                        return this.mFrequencyFormat.format((double)frequency / 1000000.0) + MHZ;
                    }
                    return "";
                }
                case 4: {
                    if (discoveredTuner.hasTuner()) {
                        int channelCount = discoveredTuner.getTuner().getChannelSourceManager().getTunerChannelCount();
                        return channelCount + " (" + (discoveredTuner.getTuner().getTunerController().isLockedSampleRate() ? "LOCKED)" : "UNLOCKED)");
                    }
                    return "";
                }
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_HEADERS[columnIndex];
    }

    private /* synthetic */ void lambda$receive$10(int index) {
        this.fireTableRowsUpdated(index, index);
    }

    private /* synthetic */ void lambda$receive$9(int index) {
        this.fireTableCellUpdated(index, 3);
    }

    private /* synthetic */ void lambda$receive$8(int index) {
        this.fireTableCellUpdated(index, 4);
    }
}

