/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.test;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.LoggingTunerErrorListener;
import io.github.dsheirer.source.tuner.TunerController;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.test.SampleGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTunerController
extends TunerController {
    private static final Logger mLog = LoggerFactory.getLogger(TestTunerController.class);
    public static final long MINIMUM_FREQUENCY = 1L;
    public static final long MAXIMUM_FREQUENCY = 1000000000L;
    public static final int SAMPLE_RATE = 2400000;
    public static final int DC_NOISE_BANDWIDTH = 0;
    public static final double USABLE_BANDWIDTH_PERCENTAGE = 1.0;
    public static final int SPECTRAL_FRAME_RATE = 20;
    public static final long SAMPLE_GENERATION_INTERVAL = 50L;
    private SampleGenerator mSampleGenerator;
    private long mFrequency = 460662500L;

    public TestTunerController() {
        super(new LoggingTunerErrorListener());
        this.setMinimumFrequency(1L);
        this.setMaximumFrequency(1000000000L);
        this.setMiddleUnusableHalfBandwidth(0);
        this.setUsableBandwidthPercentage(1.0);
        int sweepRate = 0;
        long initialToneFrequency = 50000L;
        this.mSampleGenerator = new SampleGenerator(2400000, initialToneFrequency, sweepRate);
        try {
            this.mFrequencyController.setFrequency(this.mFrequency);
            this.mFrequencyController.setSampleRate(2400000);
        }
        catch (Exception e) {
            mLog.error("Error!", (Throwable)e);
        }
    }

    @Override
    public int getBufferSampleCount() {
        return 120000;
    }

    @Override
    public void start() throws SourceException {
    }

    @Override
    public void stop() {
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.TEST;
    }

    @Override
    public void addBufferListener(Listener<INativeBuffer> listener) {
        this.mSampleGenerator.addListener(listener);
    }

    @Override
    public void removeBufferListener(Listener<INativeBuffer> listener) {
        this.mSampleGenerator.removeListener(listener);
    }

    @Override
    public void apply(TunerConfiguration config) throws SourceException {
        mLog.error("Request to apply tuner configuration was ignored");
    }

    @Override
    public long getTunedFrequency() throws SourceException {
        return this.mFrequency;
    }

    @Override
    public void setTunedFrequency(long frequency) throws SourceException {
        this.mFrequency = frequency;
    }

    public void setToneFrequency(long frequency) {
        this.mSampleGenerator.setFrequency(frequency);
    }

    public long getToneFrequency() {
        return this.mSampleGenerator.getFrequency();
    }

    @Override
    public double getCurrentSampleRate() {
        return this.mSampleGenerator.getSampleRate();
    }

    public void setSampleRate(int sampleRate) throws SourceException {
        this.mSampleGenerator.setSampleRate(sampleRate);
        this.mFrequencyController.setSampleRate(sampleRate);
    }
}

