/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.test;

import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.manager.TestPolyphaseChannelSourceManager;
import io.github.dsheirer.source.tuner.test.TestTunerController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTuner
extends Tuner {
    private static final Logger mLog = LoggerFactory.getLogger(TestTuner.class);
    private static int mInstanceCounter = 1;
    private final int mInstanceID = mInstanceCounter++;

    public TestTuner(ITunerErrorListener tunerErrorListener) {
        super(new TestTunerController(), tunerErrorListener);
        this.setChannelSourceManager(new TestPolyphaseChannelSourceManager(this.getTunerController()));
    }

    @Override
    public TestTunerController getTunerController() {
        return (TestTunerController)super.getTunerController();
    }

    @Override
    public String getPreferredName() {
        return "Test Tuner-" + this.mInstanceID;
    }

    @Override
    public String getUniqueID() {
        return this.getPreferredName();
    }

    @Override
    public TunerClass getTunerClass() {
        return TunerClass.TEST_TUNER;
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.TEST;
    }

    @Override
    public double getSampleSize() {
        return 16.0;
    }

    @Override
    public int getMaximumUSBBitsPerSecond() {
        return 0;
    }
}

