/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rspDx;

import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerController;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.rspDx.IControlRspDx;
import io.github.dsheirer.source.tuner.sdrplay.rspDx.RspDxTunerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RspDxTunerController
extends RspTunerController<IControlRspDx> {
    private Logger mLog = LoggerFactory.getLogger(RspDxTunerController.class);

    public RspDxTunerController(IControlRspDx control, ITunerErrorListener tunerErrorListener) {
        super(control, tunerErrorListener);
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.RSP_DX;
    }

    @Override
    public void apply(TunerConfiguration config) throws SourceException {
        if (config instanceof RspDxTunerConfiguration) {
            RspDxTunerConfiguration rtc = (RspDxTunerConfiguration)config;
            super.apply(config);
            try {
                ((IControlRspDx)this.getControlRsp()).setAgcMode(rtc.getAgcMode());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSP IF AGC Mode to " + String.valueOf((Object)rtc.getAgcMode()));
            }
            try {
                ((IControlRspDx)this.getControlRsp()).setAntenna(rtc.getAntenna());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSPdx antenna to " + String.valueOf((Object)rtc.getAntenna()));
            }
            try {
                ((IControlRspDx)this.getControlRsp()).setBiasT(rtc.isBiasT());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSPdx bias-T enabled to " + rtc.isBiasT());
            }
            try {
                ((IControlRspDx)this.getControlRsp()).setHighDynamicRange(rtc.isHdrMode());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSPdx high dynamic range mode enabled to " + rtc.isHdrMode());
            }
            try {
                ((IControlRspDx)this.getControlRsp()).setRfNotch(rtc.isRfNotch());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSPdx RF Notch enabled to " + rtc.isRfNotch());
            }
            try {
                ((IControlRspDx)this.getControlRsp()).setRfDabNotch(rtc.isRfDabNotch());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSPdx RF DAB Notch enabled to " + rtc.isRfDabNotch());
            }
            try {
                ((IControlRspDx)this.getControlRsp()).setHdrModeBandwidth(rtc.getHdrModeBandwidth());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSPdx HDR mode bandwdidth to " + String.valueOf((Object)rtc.getHdrModeBandwidth()));
            }
        } else {
            this.mLog.error("Invalid RSPdx tuner configuration type: " + String.valueOf(config.getClass()));
        }
    }
}

