/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rspDuo;

import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerController;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.IControlRspDuoTuner2;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.RspDuoTuner2Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RspDuoTuner2Controller
extends RspTunerController<IControlRspDuoTuner2> {
    private Logger mLog = LoggerFactory.getLogger(RspDuoTuner2Controller.class);

    public RspDuoTuner2Controller(IControlRspDuoTuner2 device, ITunerErrorListener tunerErrorListener) {
        super(device, tunerErrorListener);
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.RSP_DUO_2;
    }

    @Override
    public void apply(TunerConfiguration config) throws SourceException {
        if (config instanceof RspDuoTuner2Configuration) {
            RspDuoTuner2Configuration rtc = (RspDuoTuner2Configuration)config;
            super.apply(config);
            if (!((IControlRspDuoTuner2)this.getControlRsp()).isSlaveMode()) {
                try {
                    ((IControlRspDuoTuner2)this.getControlRsp()).setAgcMode(rtc.getAgcMode());
                }
                catch (SDRPlayException se) {
                    this.mLog.error("Error setting RSP IF AGC Mode to " + String.valueOf((Object)rtc.getAgcMode()));
                }
            }
            try {
                ((IControlRspDuoTuner2)this.getControlRsp()).setRfNotch(rtc.isRfNotch());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSPduo tuner 2 RF notch enabled to " + rtc.isRfNotch());
            }
            try {
                ((IControlRspDuoTuner2)this.getControlRsp()).setRfDabNotch(rtc.isRfDabNotch());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSPduo tuner 2 RF DAB notch enabled to " + rtc.isRfDabNotch());
            }
            try {
                ((IControlRspDuoTuner2)this.getControlRsp()).setBiasT(rtc.isBiasT());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSPduo tuner 2 Bias-T enabled to " + rtc.isBiasT());
            }
            try {
                ((IControlRspDuoTuner2)this.getControlRsp()).setExternalReferenceOutput(rtc.isExternalReferenceOutput());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSPduo tuner 2 external reference output enabled to " + rtc.isExternalReferenceOutput());
            }
        } else {
            this.mLog.error("Invalid RSPduo tuner configuration type: " + String.valueOf(config.getClass()));
        }
    }

    @Override
    public void setSampleRate(RspSampleRate rspSampleRate) throws SDRPlayException {
        if (((IControlRspDuoTuner2)this.getControlRsp()).getDeviceSelectionMode().isSingleTunerMode()) {
            if (rspSampleRate.isDualTunerSampleRate()) {
                super.setSampleRate(RspTunerConfiguration.DEFAULT_SINGLE_TUNER_SAMPLE_RATE);
            } else {
                super.setSampleRate(rspSampleRate);
            }
        } else if (rspSampleRate.isDualTunerSampleRate()) {
            super.setSampleRate(rspSampleRate);
        } else {
            super.setSampleRate(RspTunerConfiguration.DEFAULT_DUAL_TUNER_SAMPLE_RATE);
        }
    }
}

