/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rspDuo;

import io.github.dsheirer.preference.source.ChannelizerType;
import io.github.dsheirer.source.tuner.TunerController;
import io.github.dsheirer.source.tuner.TunerFactory;
import io.github.dsheirer.source.tuner.sdrplay.DiscoveredRspTuner;
import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceInfo;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.IControlRspDuoTuner2;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.MasterSlaveBridge;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.RspDuoTuner2Controller;

public class DiscoveredRspDuoTuner2
extends DiscoveredRspTuner<IControlRspDuoTuner2> {
    private MasterSlaveBridge mMasterSlaveBridge;

    public DiscoveredRspDuoTuner2(DeviceInfo deviceInfo, ChannelizerType channelizerType) {
        super(deviceInfo, channelizerType);
    }

    public DiscoveredRspDuoTuner2(DeviceInfo deviceInfo, ChannelizerType channelizerType, MasterSlaveBridge bridge) {
        super(deviceInfo, channelizerType);
        this.mMasterSlaveBridge = bridge;
    }

    @Override
    public void start() {
        if (this.isAvailable() && !this.hasTuner()) {
            try {
                this.mTuner = this.mMasterSlaveBridge != null ? TunerFactory.getRspDuoTuner(this.getDeviceInfo(), this.getChannelizerType(), this, this.mMasterSlaveBridge) : TunerFactory.getRspTuner(this.getDeviceInfo(), this.getChannelizerType(), this);
            }
            catch (Exception se) {
                this.setErrorMessage("Tuner unavailable [" + this.getId() + "]");
                this.mTuner = null;
            }
            if (this.hasTuner()) {
                try {
                    TunerController tunerController;
                    this.mTuner.start();
                    if (this.mMasterSlaveBridge != null && (tunerController = this.mTuner.getTunerController()) instanceof RspDuoTuner2Controller) {
                        RspDuoTuner2Controller rspDuoTuner2Controller = (RspDuoTuner2Controller)tunerController;
                        this.mMasterSlaveBridge.setSlave(rspDuoTuner2Controller);
                    }
                }
                catch (Exception se) {
                    this.setErrorMessage("Error starting tuner [" + this.getId() + "]");
                    this.mTuner = null;
                }
            }
        }
    }

    @Override
    public String getId() {
        return "RSPduo Tuner 2 SER#" + this.getDeviceInfo().getSerialNumber();
    }

    public String getMasterId() {
        return "RSPduo Tuner 1 SER#" + this.getDeviceInfo().getSerialNumber();
    }
}

