/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rspDuo;

import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import io.github.dsheirer.source.tuner.sdrplay.api.DeviceSelectionMode;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspDuoDevice;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.ControlRspDuoTuner2;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlRspDuoTuner2Single
extends ControlRspDuoTuner2 {
    private Logger mLog = LoggerFactory.getLogger(ControlRspDuoTuner2Single.class);

    public ControlRspDuoTuner2Single(RspDuoDevice device) {
        super(device);
    }

    @Override
    public DeviceSelectionMode getDeviceSelectionMode() {
        return DeviceSelectionMode.SINGLE_TUNER_2;
    }

    @Override
    public boolean isSlaveMode() {
        return false;
    }

    @Override
    public EnumSet<RspSampleRate> getSupportedSampleRates() {
        return RspSampleRate.SINGLE_TUNER_SAMPLE_RATES;
    }

    @Override
    public void setSampleRate(RspSampleRate sampleRate) throws SDRPlayException {
        if (sampleRate.isDualTunerSampleRate()) {
            throw new SDRPlayException("Use single-tuner sample rates only");
        }
        super.setSampleRate(sampleRate);
    }
}

