/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rspDuo;

import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.UpdateReason;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspDuoDevice;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspDuoTuner2;
import io.github.dsheirer.source.tuner.sdrplay.api.device.TunerSelect;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite.RspDuoCompositeParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.AgcMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.ControlParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.TunerParameters;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.ControlRspDuo;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.IControlRspDuoTuner2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ControlRspDuoTuner2
extends ControlRspDuo<RspDuoTuner2>
implements IControlRspDuoTuner2 {
    private Logger mLog = LoggerFactory.getLogger(ControlRspDuoTuner2.class);

    public ControlRspDuoTuner2(RspDuoDevice device) {
        super(device);
    }

    @Override
    protected RspDuoTuner2 getTuner() throws SDRPlayException {
        if (this.hasDevice()) {
            return (RspDuoTuner2)((RspDuoDevice)this.getDevice()).getTuner();
        }
        throw new SDRPlayException("RSPduo device is not started");
    }

    @Override
    public TunerSelect getTunerSelect() {
        return TunerSelect.TUNER_2;
    }

    @Override
    protected ControlParameters getControlParameters() {
        return ((RspDuoCompositeParameters)((RspDuoDevice)this.getDevice()).getCompositeParameters()).getControlBParameters();
    }

    @Override
    protected TunerParameters getTunerParameters() {
        return ((RspDuoCompositeParameters)((RspDuoDevice)this.getDevice()).getCompositeParameters()).getTunerBParameters();
    }

    @Override
    public boolean isBiasT() throws SDRPlayException {
        if (this.hasDevice()) {
            return this.getTuner().isBiasT();
        }
        throw new SDRPlayException("Device is not initialized");
    }

    @Override
    public void setBiasT(boolean enabled) throws SDRPlayException {
        if (!this.hasDevice()) {
            throw new SDRPlayException("Device is not initialized");
        }
        this.getTuner().setBiasT(enabled);
    }

    @Override
    public AgcMode getAgcMode() {
        return ((RspDuoCompositeParameters)((RspDuoDevice)this.getDevice()).getCompositeParameters()).getControlBParameters().getAgc().getAgcMode();
    }

    @Override
    public void setAgcMode(AgcMode mode) throws SDRPlayException {
        ((RspDuoCompositeParameters)((RspDuoDevice)this.getDevice()).getCompositeParameters()).getControlBParameters().getAgc().setAgcMode(mode);
        ((RspDuoDevice)this.getDevice()).update(this.getTunerSelect(), UpdateReason.CONTROL_AGC);
    }
}

