/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rspDuo;

import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import io.github.dsheirer.source.tuner.sdrplay.api.DeviceSelectionMode;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspDuoDevice;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.ControlRspDuoTuner1;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.MasterSlaveBridge;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlRspDuoTuner1Master
extends ControlRspDuoTuner1 {
    private static final Logger mLog = LoggerFactory.getLogger(ControlRspDuoTuner1Master.class);
    private MasterSlaveBridge mMasterSlaveBridge;
    private boolean mContinuousStream = false;

    public ControlRspDuoTuner1Master(RspDuoDevice device, MasterSlaveBridge bridge) {
        super(device);
        this.mMasterSlaveBridge = bridge;
    }

    @Override
    public DeviceSelectionMode getDeviceSelectionMode() {
        return DeviceSelectionMode.MASTER_TUNER_1;
    }

    @Override
    public EnumSet<RspSampleRate> getSupportedSampleRates() {
        return RspSampleRate.DUAL_TUNER_SAMPLE_RATES;
    }

    @Override
    public void setSampleRate(RspSampleRate sampleRate) throws SDRPlayException {
        if (!sampleRate.isDualTunerSampleRate()) {
            throw new SDRPlayException("Use dual-tuner sample rates only");
        }
        super.setSampleRate(sampleRate);
        if (this.mMasterSlaveBridge != null) {
            this.mMasterSlaveBridge.notifySampleRate(sampleRate);
        }
    }

    @Override
    public void stop() throws SDRPlayException {
        this.mStreamingLock.lock();
        try {
            if (this.mMasterSlaveBridge != null) {
                this.mMasterSlaveBridge.stopSlave();
            }
        }
        catch (Exception e) {
            mLog.error("Error stopping slave device while preparing to stop the master device.");
        }
        try {
            this.mContinuousStream = false;
            super.stop();
        }
        finally {
            this.mStreamingLock.unlock();
        }
    }

    @Override
    public void stopStream() {
        this.mStreamingLock.lock();
        try {
            if (!this.mContinuousStream) {
                super.stopStream();
            }
        }
        finally {
            this.mStreamingLock.unlock();
        }
    }

    public void startStreamContinuously() {
        this.mStreamingLock.lock();
        try {
            this.mContinuousStream = true;
            this.startStream();
        }
        finally {
            this.mStreamingLock.unlock();
        }
    }
}

