/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rspDuo;

import io.github.dsheirer.source.tuner.sdrplay.ControlRsp;
import io.github.dsheirer.source.tuner.sdrplay.IGainOverloadListener;
import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import io.github.dsheirer.source.tuner.sdrplay.api.DeviceSelectionMode;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.Status;
import io.github.dsheirer.source.tuner.sdrplay.api.UpdateReason;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspDuoDevice;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspDuoTuner;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspTuner;
import io.github.dsheirer.source.tuner.sdrplay.api.device.TunerSelect;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite.RspDuoCompositeParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.ControlParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.RspDuoDeviceParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.IfMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.LoMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.TunerParameters;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.IControlRspDuo;
import io.github.dsheirer.util.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ControlRspDuo<T extends RspDuoTuner>
extends ControlRsp<RspDuoDevice>
implements IControlRspDuo {
    private final Logger mLog = LoggerFactory.getLogger(ControlRspDuo.class);

    public ControlRspDuo(RspDuoDevice device) {
        super(device);
    }

    protected abstract T getTuner() throws SDRPlayException;

    @Override
    public abstract DeviceSelectionMode getDeviceSelectionMode();

    protected abstract ControlParameters getControlParameters();

    protected abstract TunerParameters getTunerParameters();

    @Override
    public void start() throws SDRPlayException {
        if (this.hasDevice()) {
            ((RspDuoDevice)this.getDevice()).setRspDuoMode(this.getDeviceSelectionMode().getRspDuoMode());
            ((RspDuoDevice)this.getDevice()).setTunerSelect(this.getDeviceSelectionMode().getTunerSelect());
            if (this.getDeviceSelectionMode().isMasterMode()) {
                ((RspDuoDevice)this.getDevice()).setRspDuoSampleFrequency(8000000.0);
            }
            ((RspDuoDevice)this.getDevice()).select();
            this.getControlParameters().getDcOffset().setDC(true);
            this.getControlParameters().getDcOffset().setIQ(true);
            this.getTunerParameters().setLoMode(LoMode.AUTO);
            if (this.getDeviceSelectionMode().isSingleTunerMode()) {
                this.getTunerParameters().setIfMode(IfMode.IF_ZERO);
            } else {
                this.getTunerParameters().setIfMode(IfMode.IF_2048);
            }
        } else {
            throw new SDRPlayException("Unable to start - no device");
        }
    }

    @Override
    public void startStream() {
        this.mStreamingLock.lock();
        try {
            if (this.hasDevice() && !this.mStreaming) {
                if (this.getDeviceSelectionMode().isSlaveMode()) {
                    ((RspDuoDevice)this.getDevice()).initStreamB(this.getDeviceEventListener(), this.getStreamListener());
                } else {
                    ((RspDuoDevice)this.getDevice()).initStreamA(this.getDeviceEventListener(), this.getStreamListener());
                }
                this.mStreaming = true;
            }
        }
        catch (SDRPlayException se) {
            if (se.getStatus() == Status.FAIL) {
                if (this.getDeviceEventListener() != null) {
                    this.getDeviceEventListener().processDeviceRemoval(this.getTunerSelect());
                }
            } else {
                this.mLog.error("Unable to initialize/start streaming for RSPduo", (Throwable)se);
            }
        }
        finally {
            this.mStreamingLock.unlock();
        }
    }

    @Override
    public void stopStream() {
        this.mStreamingLock.lock();
        try {
            if (this.hasDevice() && this.mStreaming) {
                ((RspDuoDevice)this.getDevice()).uninitialize();
                this.mStreaming = false;
            }
        }
        catch (Exception e) {
            this.mLog.error("Error while stopping RSPduo stream", (Throwable)e);
        }
        finally {
            this.mStreamingLock.unlock();
        }
    }

    @Override
    public void setSampleRate(RspSampleRate sampleRate) throws SDRPlayException {
        if (this.hasDevice()) {
            this.mSampleRate = sampleRate;
            ((RspDuoDevice)this.getDevice()).getTuner().setBandwidth(sampleRate.getBandwidth());
            ((RspDuoDeviceParameters)((RspDuoCompositeParameters)((RspDuoDevice)this.getDevice()).getCompositeParameters()).getDeviceParameters()).getSamplingFrequency().setSampleRate(sampleRate.getSampleRate());
            if (this.getDeviceSelectionMode() != DeviceSelectionMode.MASTER_TUNER_1) {
                ((RspDuoDevice)this.getDevice()).update(this.getTunerSelect(), UpdateReason.DEVICE_SAMPLE_RATE);
            }
        } else {
            throw new SDRPlayException("Device is not initialized");
        }
        this.getControlParameters().getDecimation().setWideBandSignal(true);
        ((RspDuoDevice)this.getDevice()).setDecimation(sampleRate.getDecimation());
    }

    @Override
    public void setGain(int gain) throws SDRPlayException {
        this.validateGain(gain);
        if (gain != this.mGain) {
            this.mGain = gain;
            ((RspTuner)this.getTuner()).setGain(this.mGain);
        }
    }

    @Override
    public void acknowledgePowerOverload(TunerSelect tunerSelect) throws SDRPlayException {
        IGainOverloadListener listener;
        if (!this.hasDevice()) {
            throw new SDRPlayException("Device is not initialized");
        }
        ((RspDuoDevice)this.getDevice()).acknowledgePowerOverload(tunerSelect);
        if (this.mGainOverloadReference != null && (listener = (IGainOverloadListener)this.mGainOverloadReference.get()) != null) {
            ThreadPool.CACHED.submit(() -> listener.notifyGainOverload(tunerSelect));
        }
    }

    @Override
    public long getTunedFrequency() throws SDRPlayException {
        if (this.hasDevice()) {
            return ((RspTuner)this.getTuner()).getFrequency();
        }
        throw new SDRPlayException("Device is not initialized");
    }

    @Override
    public void setTunedFrequency(long frequency) throws SDRPlayException {
        if (!this.hasDevice()) {
            throw new SDRPlayException("Device is not initialized");
        }
        ((RspTuner)this.getTuner()).setFrequency(frequency);
    }

    @Override
    public boolean isRfDabNotch() throws SDRPlayException {
        if (this.hasDevice()) {
            return ((RspDuoTuner)this.getTuner()).isRfDabNotch();
        }
        throw new SDRPlayException("Device is not initialized");
    }

    @Override
    public void setRfDabNotch(boolean enabled) throws SDRPlayException {
        if (!this.hasDevice()) {
            throw new SDRPlayException("Device is not initialized");
        }
        ((RspDuoTuner)this.getTuner()).setRfDabNotch(enabled);
    }

    @Override
    public boolean isRfNotch() throws SDRPlayException {
        if (this.hasDevice()) {
            return ((RspDuoTuner)this.getTuner()).isRFNotch();
        }
        throw new SDRPlayException("Device is not initialized");
    }

    @Override
    public void setRfNotch(boolean enabled) throws SDRPlayException {
        if (!this.hasDevice()) {
            throw new SDRPlayException("Device is not initialized");
        }
        ((RspDuoTuner)this.getTuner()).setRfNotch(enabled);
    }

    @Override
    public boolean isExternalReferenceOutput() throws SDRPlayException {
        if (this.hasDevice()) {
            return ((RspDuoTuner)this.getTuner()).isExternalReferenceOutput();
        }
        throw new SDRPlayException("Device is not initialized");
    }

    @Override
    public void setExternalReferenceOutput(boolean enabled) throws SDRPlayException {
        if (!this.hasDevice()) {
            throw new SDRPlayException("Device is not initialized");
        }
        ((RspDuoTuner)this.getTuner()).setExternalReferenceOutput(enabled);
    }
}

