/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rsp2;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.sdrplay.DiscoveredRspTuner;
import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import io.github.dsheirer.source.tuner.sdrplay.RspTuner;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerEditor;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.AgcMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.Rsp2AntennaSelection;
import io.github.dsheirer.source.tuner.sdrplay.rsp2.IControlRsp2;
import io.github.dsheirer.source.tuner.sdrplay.rsp2.Rsp2TunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.rsp2.Rsp2TunerController;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rsp2TunerEditor
extends RspTunerEditor<Rsp2TunerConfiguration> {
    private static final Logger mLog = LoggerFactory.getLogger(Rsp2TunerEditor.class);
    private JComboBox<RspSampleRate> mSampleRateCombo;
    private JCheckBox mBiasTCheckBox;
    private JCheckBox mExternalReferenceOutputCheckBox;
    private JCheckBox mRfNotchCheckBox;
    private JComboBox<Rsp2AntennaSelection> mAntennaSelectionCombo;

    public Rsp2TunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredRspTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
        this.init();
        this.tunerStatusUpdated();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[right][grow,fill][fill]", "[][][][][][][][][][][][][grow]"));
        this.add(new JLabel("Tuner:"));
        this.add((Component)this.getTunerIdLabel(), "wrap");
        this.add(new JLabel("Status:"));
        this.add((Component)this.getTunerStatusLabel(), "wrap");
        this.add((Component)this.getButtonPanel(), "span,align left");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("Frequency (MHz):"));
        this.add((Component)this.getFrequencyPanel(), "wrap");
        this.add(new JLabel("Sample Rate:"));
        this.add(this.getSampleRateCombo(), "wrap");
        this.add(new JLabel("IF AGC Mode:"));
        JPanel gainPanel = new JPanel();
        gainPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[grow,fill][]", ""));
        gainPanel.add(this.getAgcButton());
        gainPanel.add(this.getGainOverloadButton());
        this.add((Component)gainPanel, "wrap");
        this.add(new JLabel("Gain:"));
        this.add(this.getGainSlider());
        this.add(this.getGainValueLabel());
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel());
        this.add((Component)this.getBiasTCheckBox(), "wrap");
        this.add(new JLabel());
        this.add((Component)this.getExternalReferenceOutputCheckBox(), "wrap");
        this.add(new JLabel());
        this.add((Component)this.getRfNotchCheckBox(), "wrap");
        this.add(new JLabel());
        this.add(this.getAntennaSelectionCombo(), "wrap");
    }

    private Rsp2TunerController getTunerController() {
        if (this.hasTuner()) {
            return (Rsp2TunerController)((RspTuner)this.getTuner()).getTunerController();
        }
        return null;
    }

    @Override
    public void setTunerLockState(boolean locked) {
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(!locked);
        this.updateSampleRateToolTip();
    }

    @Override
    protected void tunerStatusUpdated() {
        this.setLoading(true);
        this.getTunerIdLabel().setText(this.getDiscoveredTuner().getId());
        Object status = this.getDiscoveredTuner().getTunerStatus().toString();
        if (this.getDiscoveredTuner().hasErrorMessage()) {
            status = (String)status + " - " + this.getDiscoveredTuner().getErrorMessage();
        }
        this.getTunerStatusLabel().setText((String)status);
        this.getButtonPanel().updateControls();
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(this.hasTuner() && !((RspTuner)this.getTuner()).getTunerController().isLockedSampleRate());
        this.getSampleRateCombo().setSelectedItem((Object)(this.hasTuner() ? ((IControlRsp2)this.getTunerController().getControlRsp()).getSampleRateEnumeration() : null));
        this.updateSampleRateToolTip();
        this.getAgcButton().setEnabled(this.hasTuner());
        if (this.hasTuner()) {
            AgcMode current = ((IControlRsp2)this.getTunerController().getControlRsp()).getAgcMode();
            this.getAgcButton().setSelected(current == null || current.equals((Object)AgcMode.ENABLE));
            ((IControlRsp2)this.getTunerController().getControlRsp()).setGainOverloadListener(this);
        }
        this.getGainSlider().setEnabled(this.hasTuner());
        this.getGainValueLabel().setEnabled(this.hasTuner());
        this.getGainSlider().setValue(this.hasTuner() ? ((IControlRsp2)this.getTunerController().getControlRsp()).getGain() : 0);
        this.getBiasTCheckBox().setEnabled(this.hasTuner());
        try {
            this.getBiasTCheckBox().setSelected(this.hasTuner() && ((IControlRsp2)this.getTunerController().getControlRsp()).isBiasT());
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting Bias-T enabled state in editor");
        }
        this.getExternalReferenceOutputCheckBox().setEnabled(this.hasTuner());
        try {
            this.getExternalReferenceOutputCheckBox().setSelected(this.hasTuner() && ((IControlRsp2)this.getTunerController().getControlRsp()).isExternalReferenceOutput());
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting RF DAB Notch enabled state in editor");
        }
        this.getRfNotchCheckBox().setEnabled(this.hasTuner());
        try {
            this.getRfNotchCheckBox().setSelected(this.hasTuner() && ((IControlRsp2)this.getTunerController().getControlRsp()).isRfNotch());
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting RF Notch enabled state in editor");
        }
        this.getAntennaSelectionCombo().setEnabled(this.hasTuner());
        try {
            this.getAntennaSelectionCombo().setSelectedItem((Object)(this.hasTuner() ? ((IControlRsp2)this.getTunerController().getControlRsp()).getAntennaSelection() : null));
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting antenna selection in editor");
        }
        this.setLoading(false);
    }

    @Override
    public void save() {
        if (this.hasConfiguration() && !this.isLoading()) {
            ((Rsp2TunerConfiguration)this.getConfiguration()).setFrequency(this.getFrequencyControl().getFrequency());
            double value = ((SpinnerNumberModel)this.getFrequencyCorrectionSpinner().getModel()).getNumber().doubleValue();
            ((Rsp2TunerConfiguration)this.getConfiguration()).setFrequencyCorrection(value);
            ((Rsp2TunerConfiguration)this.getConfiguration()).setAutoPPMCorrectionEnabled(this.getAutoPPMCheckBox().isSelected());
            ((Rsp2TunerConfiguration)this.getConfiguration()).setSampleRate((RspSampleRate)((Object)this.getSampleRateCombo().getSelectedItem()));
            ((Rsp2TunerConfiguration)this.getConfiguration()).setBiasT(this.getBiasTCheckBox().isSelected());
            ((Rsp2TunerConfiguration)this.getConfiguration()).setRfNotch(this.getRfNotchCheckBox().isSelected());
            ((Rsp2TunerConfiguration)this.getConfiguration()).setAntennaSelection((Rsp2AntennaSelection)((Object)this.getAntennaSelectionCombo().getSelectedItem()));
            ((Rsp2TunerConfiguration)this.getConfiguration()).setGain(this.getGainSlider().getValue());
            ((Rsp2TunerConfiguration)this.getConfiguration()).setAgcMode(this.getAgcButton().isSelected() ? AgcMode.ENABLE : AgcMode.DISABLE);
            this.saveConfiguration();
        }
    }

    private JComboBox<RspSampleRate> getSampleRateCombo() {
        if (this.mSampleRateCombo == null) {
            RspSampleRate[] rspSampleRates = RspSampleRate.SINGLE_TUNER_SAMPLE_RATES.toArray(new RspSampleRate[RspSampleRate.SINGLE_TUNER_SAMPLE_RATES.size()]);
            this.mSampleRateCombo = new JComboBox<RspSampleRate>(rspSampleRates);
            this.mSampleRateCombo.setEnabled(false);
            this.mSampleRateCombo.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    RspSampleRate selected = (RspSampleRate)((Object)((Object)this.mSampleRateCombo.getSelectedItem()));
                    try {
                        this.getTunerController().setSampleRate(selected);
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Error setting sample rate for RSP2 tuner", (Throwable)se);
                    }
                }
            });
        }
        return this.mSampleRateCombo;
    }

    private JCheckBox getBiasTCheckBox() {
        if (this.mBiasTCheckBox == null) {
            this.mBiasTCheckBox = new JCheckBox("ANT B Bias-T Power");
            this.mBiasTCheckBox.setEnabled(false);
            this.mBiasTCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((IControlRsp2)this.getTunerController().getControlRsp()).setBiasT(this.mBiasTCheckBox.isSelected());
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Unable to set RSP2 Bias-T enabled to " + this.mBiasTCheckBox.isSelected(), (Throwable)se);
                    }
                }
            });
        }
        return this.mBiasTCheckBox;
    }

    private JCheckBox getRfNotchCheckBox() {
        if (this.mRfNotchCheckBox == null) {
            this.mRfNotchCheckBox = new JCheckBox("FM Broadcast Band Filter (77-115 MHz)");
            this.mRfNotchCheckBox.setEnabled(false);
            this.mRfNotchCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((IControlRsp2)this.getTunerController().getControlRsp()).setRfNotch(this.mRfNotchCheckBox.isSelected());
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Unable to set RSP2 RF notch enabled to " + this.mRfNotchCheckBox.isSelected(), (Throwable)se);
                    }
                }
            });
        }
        return this.mRfNotchCheckBox;
    }

    private JCheckBox getExternalReferenceOutputCheckBox() {
        if (this.mExternalReferenceOutputCheckBox == null) {
            this.mExternalReferenceOutputCheckBox = new JCheckBox("External Reference Output");
            this.mExternalReferenceOutputCheckBox.setEnabled(false);
            this.mExternalReferenceOutputCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((IControlRsp2)this.getTunerController().getControlRsp()).setExternalReferenceOutput(this.mExternalReferenceOutputCheckBox.isSelected());
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Unable to set RSP2 external reference output notch enabled to " + this.mExternalReferenceOutputCheckBox.isSelected(), (Throwable)se);
                    }
                }
            });
        }
        return this.mExternalReferenceOutputCheckBox;
    }

    private JComboBox<Rsp2AntennaSelection> getAntennaSelectionCombo() {
        if (this.mAntennaSelectionCombo == null) {
            this.mAntennaSelectionCombo = new JComboBox<Rsp2AntennaSelection>(Rsp2AntennaSelection.values());
            this.mAntennaSelectionCombo.setEnabled(false);
            this.mAntennaSelectionCombo.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    Rsp2AntennaSelection selected = (Rsp2AntennaSelection)((Object)((Object)this.mAntennaSelectionCombo.getSelectedItem()));
                    try {
                        ((IControlRsp2)this.getTunerController().getControlRsp()).setAntennaSelection(selected);
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Error setting Antenna selection for RSP2", (Throwable)se);
                    }
                }
            });
        }
        return this.mAntennaSelectionCombo;
    }

    private void updateSampleRateToolTip() {
        if (this.hasTuner() && ((RspTuner)this.getTuner()).getTunerController().isLockedSampleRate()) {
            this.getSampleRateCombo().setToolTipText("Sample Rate is locked.  Disable decoding channels to unlock.");
        } else if (this.hasTuner()) {
            this.getSampleRateCombo().setToolTipText("Select a sample rate for the tuner");
        } else {
            this.getSampleRateCombo().setToolTipText("No tuner available");
        }
    }
}

