/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rsp2;

import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerController;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.rsp2.IControlRsp2;
import io.github.dsheirer.source.tuner.sdrplay.rsp2.Rsp2TunerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rsp2TunerController
extends RspTunerController<IControlRsp2> {
    private Logger mLog = LoggerFactory.getLogger(Rsp2TunerController.class);

    public Rsp2TunerController(IControlRsp2 control, ITunerErrorListener tunerErrorListener) {
        super(control, tunerErrorListener);
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.RSP_2;
    }

    @Override
    public void apply(TunerConfiguration config) throws SourceException {
        if (config instanceof Rsp2TunerConfiguration) {
            Rsp2TunerConfiguration rtc = (Rsp2TunerConfiguration)config;
            super.apply(config);
            try {
                ((IControlRsp2)this.getControlRsp()).setAgcMode(rtc.getAgcMode());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSP IF AGC Mode to " + String.valueOf((Object)rtc.getAgcMode()));
            }
            try {
                ((IControlRsp2)this.getControlRsp()).setBiasT(rtc.isBiasT());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSP2 bias-T enabled to " + rtc.isBiasT());
            }
            try {
                ((IControlRsp2)this.getControlRsp()).setExternalReferenceOutput(rtc.isExternalReferenceOutput());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSP2 external reference output enabled to " + rtc.isExternalReferenceOutput());
            }
            try {
                ((IControlRsp2)this.getControlRsp()).setRfNotch(rtc.isRfNotch());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSP2 RF Notch enabled to " + rtc.isRfNotch());
            }
            try {
                ((IControlRsp2)this.getControlRsp()).setAntennaSelection(rtc.getAntennaSelection());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSP2 antenna selection to " + String.valueOf((Object)rtc.getAntennaSelection()));
            }
        } else {
            this.mLog.error("Invalid RSP2 tuner configuration type: " + String.valueOf(config.getClass()));
        }
    }
}

