/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rsp2;

import io.github.dsheirer.source.tuner.sdrplay.ControlRsp;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.device.Rsp2Device;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.Rsp2AntennaSelection;
import io.github.dsheirer.source.tuner.sdrplay.rsp2.IControlRsp2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlRsp2
extends ControlRsp<Rsp2Device>
implements IControlRsp2 {
    private Logger mLog = LoggerFactory.getLogger(ControlRsp2.class);
    private Rsp2AntennaSelection mAntennaSelection = Rsp2AntennaSelection.ANT_A;

    public ControlRsp2(Rsp2Device device) {
        super(device);
    }

    @Override
    public boolean isBiasT() throws SDRPlayException {
        if (this.hasDevice()) {
            return ((Rsp2Device)this.getDevice()).getTuner().isBiasT();
        }
        throw new SDRPlayException("Device is not initialized");
    }

    @Override
    public void setBiasT(boolean enabled) throws SDRPlayException {
        if (!this.hasDevice()) {
            throw new SDRPlayException("Device is not initialized");
        }
        ((Rsp2Device)this.getDevice()).getTuner().setBiasT(enabled);
    }

    @Override
    public boolean isExternalReferenceOutput() throws SDRPlayException {
        if (this.hasDevice()) {
            return ((Rsp2Device)this.getDevice()).getTuner().isExternalReferenceOutput();
        }
        throw new SDRPlayException("Device is not initialized");
    }

    @Override
    public void setExternalReferenceOutput(boolean enabled) throws SDRPlayException {
        if (!this.hasDevice()) {
            throw new SDRPlayException("Device is not initialized");
        }
        ((Rsp2Device)this.getDevice()).getTuner().setExternalReferenceOutput(enabled);
    }

    @Override
    public boolean isRfNotch() throws SDRPlayException {
        if (this.hasDevice()) {
            return ((Rsp2Device)this.getDevice()).getTuner().isRfNotch();
        }
        throw new SDRPlayException("Device is not initialized");
    }

    @Override
    public void setRfNotch(boolean enabled) throws SDRPlayException {
        if (!this.hasDevice()) {
            throw new SDRPlayException("Device is not initialized");
        }
        ((Rsp2Device)this.getDevice()).getTuner().setRfNotch(enabled);
    }

    @Override
    public Rsp2AntennaSelection getAntennaSelection() throws SDRPlayException {
        return this.mAntennaSelection;
    }

    @Override
    public void setAntennaSelection(Rsp2AntennaSelection selection) throws SDRPlayException {
        if (!this.hasDevice()) {
            throw new SDRPlayException("Device is not initialized");
        }
        ((Rsp2Device)this.getDevice()).getTuner().setAmPort(selection.getAmPort());
        ((Rsp2Device)this.getDevice()).getTuner().setAntenna(selection.getAntenna());
    }
}

