/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rsp1a;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.sdrplay.DiscoveredRspTuner;
import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import io.github.dsheirer.source.tuner.sdrplay.RspTuner;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerEditor;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.AgcMode;
import io.github.dsheirer.source.tuner.sdrplay.rsp1a.IControlRsp1a;
import io.github.dsheirer.source.tuner.sdrplay.rsp1a.Rsp1aTunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.rsp1a.Rsp1aTunerController;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rsp1aTunerEditor
extends RspTunerEditor<Rsp1aTunerConfiguration> {
    private static final Logger mLog = LoggerFactory.getLogger(Rsp1aTunerEditor.class);
    private JComboBox<RspSampleRate> mSampleRateCombo;
    private JCheckBox mBiasTCheckBox;
    private JCheckBox mRfDabNotchCheckBox;
    private JCheckBox mRfNotchCheckBox;

    public Rsp1aTunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredRspTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
        this.init();
        this.tunerStatusUpdated();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[right][grow,fill][fill]", "[][][][][][][][][][][][][grow]"));
        this.add(new JLabel("Tuner:"));
        this.add((Component)this.getTunerIdLabel(), "wrap");
        this.add(new JLabel("Status:"));
        this.add((Component)this.getTunerStatusLabel(), "wrap");
        this.add((Component)this.getButtonPanel(), "span,align left");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("Frequency (MHz):"));
        this.add((Component)this.getFrequencyPanel(), "wrap");
        this.add(new JLabel("Sample Rate:"));
        this.add(this.getSampleRateCombo(), "wrap");
        this.add(new JLabel("IF AGC Mode:"));
        JPanel gainPanel = new JPanel();
        gainPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[grow,fill][]", ""));
        gainPanel.add(this.getAgcButton());
        gainPanel.add(this.getGainOverloadButton());
        this.add((Component)gainPanel, "wrap");
        this.add(new JLabel("Gain:"));
        this.add(this.getGainSlider());
        this.add(this.getGainValueLabel());
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel());
        this.add((Component)this.getBiasTCheckBox(), "wrap");
        this.add(new JLabel());
        this.add((Component)this.getRfNotchCheckBox(), "wrap");
        this.add(new JLabel());
        this.add((Component)this.getRfDabNotchCheckBox(), "wrap");
    }

    private Rsp1aTunerController getTunerController() {
        if (this.hasTuner()) {
            return (Rsp1aTunerController)((RspTuner)this.getTuner()).getTunerController();
        }
        return null;
    }

    @Override
    public void setTunerLockState(boolean locked) {
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(!locked);
        this.updateSampleRateToolTip();
    }

    @Override
    protected void tunerStatusUpdated() {
        this.setLoading(true);
        this.getTunerIdLabel().setText(this.getDiscoveredTuner().getId());
        Object status = this.getDiscoveredTuner().getTunerStatus().toString();
        if (this.getDiscoveredTuner().hasErrorMessage()) {
            status = (String)status + " - " + this.getDiscoveredTuner().getErrorMessage();
        }
        this.getTunerStatusLabel().setText((String)status);
        this.getButtonPanel().updateControls();
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(this.hasTuner() && !((RspTuner)this.getTuner()).getTunerController().isLockedSampleRate());
        this.getSampleRateCombo().setSelectedItem((Object)(this.hasTuner() ? ((IControlRsp1a)this.getTunerController().getControlRsp()).getSampleRateEnumeration() : null));
        this.updateSampleRateToolTip();
        this.getAgcButton().setEnabled(this.hasTuner());
        if (this.hasTuner()) {
            AgcMode current = ((IControlRsp1a)this.getTunerController().getControlRsp()).getAgcMode();
            this.getAgcButton().setSelected(current == null || current.equals((Object)AgcMode.ENABLE));
            ((IControlRsp1a)this.getTunerController().getControlRsp()).setGainOverloadListener(this);
        }
        this.getGainSlider().setEnabled(this.hasTuner());
        this.getGainValueLabel().setEnabled(this.hasTuner());
        this.getGainSlider().setValue(this.hasTuner() ? ((IControlRsp1a)this.getTunerController().getControlRsp()).getGain() : 0);
        this.getBiasTCheckBox().setEnabled(this.hasTuner());
        try {
            this.getBiasTCheckBox().setSelected(this.hasTuner() && ((IControlRsp1a)this.getTunerController().getControlRsp()).isBiasT());
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting Bias-T enabled state in editor");
        }
        this.getRfDabNotchCheckBox().setEnabled(this.hasTuner());
        try {
            this.getRfDabNotchCheckBox().setSelected(this.hasTuner() && ((IControlRsp1a)this.getTunerController().getControlRsp()).isRfDabNotch());
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting RF DAB Notch enabled state in editor");
        }
        this.getRfNotchCheckBox().setEnabled(this.hasTuner());
        try {
            this.getRfNotchCheckBox().setSelected(this.hasTuner() ? ((IControlRsp1a)this.getTunerController().getControlRsp()).isRfNotch() : false);
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting RF Notch enabled state in editor");
        }
        this.setLoading(false);
    }

    @Override
    public void save() {
        if (this.hasConfiguration() && !this.isLoading()) {
            ((Rsp1aTunerConfiguration)this.getConfiguration()).setFrequency(this.getFrequencyControl().getFrequency());
            double value = ((SpinnerNumberModel)this.getFrequencyCorrectionSpinner().getModel()).getNumber().doubleValue();
            ((Rsp1aTunerConfiguration)this.getConfiguration()).setFrequencyCorrection(value);
            ((Rsp1aTunerConfiguration)this.getConfiguration()).setAutoPPMCorrectionEnabled(this.getAutoPPMCheckBox().isSelected());
            ((Rsp1aTunerConfiguration)this.getConfiguration()).setSampleRate((RspSampleRate)((Object)this.getSampleRateCombo().getSelectedItem()));
            ((Rsp1aTunerConfiguration)this.getConfiguration()).setBiasT(this.getBiasTCheckBox().isSelected());
            ((Rsp1aTunerConfiguration)this.getConfiguration()).setRfNotch(this.getRfNotchCheckBox().isSelected());
            ((Rsp1aTunerConfiguration)this.getConfiguration()).setRfDabNotch(this.getRfDabNotchCheckBox().isSelected());
            ((Rsp1aTunerConfiguration)this.getConfiguration()).setGain(this.getGainSlider().getValue());
            ((Rsp1aTunerConfiguration)this.getConfiguration()).setAgcMode(this.getAgcButton().isSelected() ? AgcMode.ENABLE : AgcMode.DISABLE);
            this.saveConfiguration();
        }
    }

    private JComboBox<RspSampleRate> getSampleRateCombo() {
        if (this.mSampleRateCombo == null) {
            RspSampleRate[] rspSampleRates = RspSampleRate.SINGLE_TUNER_SAMPLE_RATES.toArray(new RspSampleRate[RspSampleRate.SINGLE_TUNER_SAMPLE_RATES.size()]);
            this.mSampleRateCombo = new JComboBox<RspSampleRate>(rspSampleRates);
            this.mSampleRateCombo.setEnabled(false);
            this.mSampleRateCombo.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    RspSampleRate selected = (RspSampleRate)((Object)((Object)this.mSampleRateCombo.getSelectedItem()));
                    try {
                        this.getTunerController().setSampleRate(selected);
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Error setting sample rate for RSP1A tuner", (Throwable)se);
                    }
                }
            });
        }
        return this.mSampleRateCombo;
    }

    private JCheckBox getBiasTCheckBox() {
        if (this.mBiasTCheckBox == null) {
            this.mBiasTCheckBox = new JCheckBox("Bias-T Power");
            this.mBiasTCheckBox.setEnabled(false);
            this.mBiasTCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((IControlRsp1a)this.getTunerController().getControlRsp()).setBiasT(this.mBiasTCheckBox.isSelected());
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Unable to set RSP1A Bias-T enabled to " + this.mBiasTCheckBox.isSelected(), (Throwable)se);
                    }
                }
            });
        }
        return this.mBiasTCheckBox;
    }

    private JCheckBox getRfDabNotchCheckBox() {
        if (this.mRfDabNotchCheckBox == null) {
            this.mRfDabNotchCheckBox = new JCheckBox("DAB Broadcast Band Filter (160-235 MHz)");
            this.mRfDabNotchCheckBox.setEnabled(false);
            this.mRfDabNotchCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((IControlRsp1a)this.getTunerController().getControlRsp()).setRfDabNotch(this.mRfDabNotchCheckBox.isSelected());
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Unable to set RSP1A RF DAB notch enabled to " + this.mRfDabNotchCheckBox.isSelected(), (Throwable)se);
                    }
                }
            });
        }
        return this.mRfDabNotchCheckBox;
    }

    private JCheckBox getRfNotchCheckBox() {
        if (this.mRfNotchCheckBox == null) {
            this.mRfNotchCheckBox = new JCheckBox("FM Broadcast Band Filter (77-115 MHz)");
            this.mRfNotchCheckBox.setEnabled(false);
            this.mRfNotchCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((IControlRsp1a)this.getTunerController().getControlRsp()).setRfNotch(this.mRfNotchCheckBox.isSelected());
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Unable to set RSP1A RF notch enabled to " + this.mRfNotchCheckBox.isSelected(), (Throwable)se);
                    }
                }
            });
        }
        return this.mRfNotchCheckBox;
    }

    private void updateSampleRateToolTip() {
        if (this.hasTuner() && ((RspTuner)this.getTuner()).getTunerController().isLockedSampleRate()) {
            this.getSampleRateCombo().setToolTipText("Sample Rate is locked.  Disable decoding channels to unlock.");
        } else if (this.hasTuner()) {
            this.getSampleRateCombo().setToolTipText("Select a sample rate for the tuner");
        } else {
            this.getSampleRateCombo().setToolTipText("No tuner available");
        }
    }
}

