/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rsp1a;

import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerController;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.rsp1a.IControlRsp1a;
import io.github.dsheirer.source.tuner.sdrplay.rsp1a.Rsp1aTunerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rsp1aTunerController
extends RspTunerController<IControlRsp1a> {
    private Logger mLog = LoggerFactory.getLogger(Rsp1aTunerController.class);

    public Rsp1aTunerController(IControlRsp1a control, ITunerErrorListener tunerErrorListener) {
        super(control, tunerErrorListener);
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.RSP_1A;
    }

    @Override
    public void apply(TunerConfiguration config) throws SourceException {
        if (config instanceof Rsp1aTunerConfiguration) {
            Rsp1aTunerConfiguration rtc = (Rsp1aTunerConfiguration)config;
            super.apply(config);
            try {
                ((IControlRsp1a)this.getControlRsp()).setAgcMode(rtc.getAgcMode());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSP IF AGC Mode to " + String.valueOf((Object)rtc.getAgcMode()));
            }
            try {
                ((IControlRsp1a)this.getControlRsp()).setBiasT(rtc.isBiasT());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSP1A bias-T enabled to " + rtc.isBiasT());
            }
            try {
                ((IControlRsp1a)this.getControlRsp()).setRfNotch(rtc.isRfNotch());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSP1A RF Notch enabled to " + rtc.isRfNotch());
            }
            try {
                ((IControlRsp1a)this.getControlRsp()).setRfDabNotch(rtc.isRfDabNotch());
            }
            catch (SDRPlayException se) {
                this.mLog.error("Error setting RSP1A RF DAB Notch enabled to " + rtc.isRfDabNotch());
            }
        } else {
            this.mLog.error("Invalid RSP1A tuner configuration type: " + String.valueOf(config.getClass()));
        }
    }
}

