/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rsp1;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.sdrplay.DiscoveredRspTuner;
import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import io.github.dsheirer.source.tuner.sdrplay.RspTuner;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerEditor;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.AgcMode;
import io.github.dsheirer.source.tuner.sdrplay.rsp1.IControlRsp1;
import io.github.dsheirer.source.tuner.sdrplay.rsp1.Rsp1TunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.rsp1.Rsp1TunerController;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rsp1TunerEditor
extends RspTunerEditor<Rsp1TunerConfiguration> {
    private static final Logger mLog = LoggerFactory.getLogger(Rsp1TunerEditor.class);
    private JComboBox<RspSampleRate> mSampleRateCombo;

    public Rsp1TunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredRspTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
        this.init();
        this.tunerStatusUpdated();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[right][grow,fill][fill]", "[][][][][][][][][][][][][grow]"));
        this.add(new JLabel("Tuner:"));
        this.add((Component)this.getTunerIdLabel(), "wrap");
        this.add(new JLabel("Status:"));
        this.add((Component)this.getTunerStatusLabel(), "wrap");
        this.add((Component)this.getButtonPanel(), "span,align left");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("Frequency (MHz):"));
        this.add((Component)this.getFrequencyPanel(), "wrap");
        this.add(new JLabel("Sample Rate:"));
        this.add(this.getSampleRateCombo(), "wrap");
        this.add(new JLabel("IF AGC Mode:"));
        JPanel gainPanel = new JPanel();
        gainPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[grow,fill][]", ""));
        gainPanel.add(this.getAgcButton());
        gainPanel.add(this.getGainOverloadButton());
        this.add((Component)gainPanel, "wrap");
        this.add(new JLabel("Gain:"));
        this.add(this.getGainSlider());
        this.add(this.getGainValueLabel());
        this.add((Component)new JSeparator(), "span,growx,push");
    }

    private Rsp1TunerController getTunerController() {
        if (this.hasTuner()) {
            return (Rsp1TunerController)((RspTuner)this.getTuner()).getTunerController();
        }
        return null;
    }

    @Override
    public void setTunerLockState(boolean locked) {
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(!locked);
        this.updateSampleRateToolTip();
    }

    @Override
    protected void tunerStatusUpdated() {
        this.setLoading(true);
        this.getTunerIdLabel().setText(this.getDiscoveredTuner().getId());
        Object status = this.getDiscoveredTuner().getTunerStatus().toString();
        if (this.getDiscoveredTuner().hasErrorMessage()) {
            status = (String)status + " - " + this.getDiscoveredTuner().getErrorMessage();
        }
        this.getTunerStatusLabel().setText((String)status);
        this.getButtonPanel().updateControls();
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(this.hasTuner() && !((RspTuner)this.getTuner()).getTunerController().isLockedSampleRate());
        this.getSampleRateCombo().setSelectedItem((Object)(this.hasTuner() ? ((IControlRsp1)this.getTunerController().getControlRsp()).getSampleRateEnumeration() : null));
        this.updateSampleRateToolTip();
        this.getAgcButton().setEnabled(this.hasTuner());
        if (this.hasTuner()) {
            AgcMode current = ((IControlRsp1)this.getTunerController().getControlRsp()).getAgcMode();
            this.getAgcButton().setSelected(current == null || current.equals((Object)AgcMode.ENABLE));
            ((IControlRsp1)this.getTunerController().getControlRsp()).setGainOverloadListener(this);
        }
        this.getGainSlider().setEnabled(this.hasTuner());
        this.getGainValueLabel().setEnabled(this.hasTuner());
        this.getGainSlider().setValue(this.hasTuner() ? ((IControlRsp1)this.getTunerController().getControlRsp()).getGain() : 0);
        this.setLoading(false);
    }

    @Override
    public void save() {
        if (this.hasConfiguration() && !this.isLoading()) {
            ((Rsp1TunerConfiguration)this.getConfiguration()).setFrequency(this.getFrequencyControl().getFrequency());
            double value = ((SpinnerNumberModel)this.getFrequencyCorrectionSpinner().getModel()).getNumber().doubleValue();
            ((Rsp1TunerConfiguration)this.getConfiguration()).setFrequencyCorrection(value);
            ((Rsp1TunerConfiguration)this.getConfiguration()).setAutoPPMCorrectionEnabled(this.getAutoPPMCheckBox().isSelected());
            ((Rsp1TunerConfiguration)this.getConfiguration()).setSampleRate((RspSampleRate)((Object)this.getSampleRateCombo().getSelectedItem()));
            ((Rsp1TunerConfiguration)this.getConfiguration()).setGain(this.getGainSlider().getValue());
            ((Rsp1TunerConfiguration)this.getConfiguration()).setAgcMode(this.getAgcButton().isSelected() ? AgcMode.ENABLE : AgcMode.DISABLE);
            this.saveConfiguration();
        }
    }

    private JComboBox<RspSampleRate> getSampleRateCombo() {
        if (this.mSampleRateCombo == null) {
            RspSampleRate[] rspSampleRates = RspSampleRate.SINGLE_TUNER_SAMPLE_RATES.toArray(new RspSampleRate[RspSampleRate.SINGLE_TUNER_SAMPLE_RATES.size()]);
            this.mSampleRateCombo = new JComboBox<RspSampleRate>(rspSampleRates);
            this.mSampleRateCombo.setEnabled(false);
            this.mSampleRateCombo.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    RspSampleRate selected = (RspSampleRate)((Object)((Object)this.mSampleRateCombo.getSelectedItem()));
                    try {
                        this.getTunerController().setSampleRate(selected);
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Error setting sample rate for RSP1A tuner", (Throwable)se);
                    }
                }
            });
        }
        return this.mSampleRateCombo;
    }

    private void updateSampleRateToolTip() {
        if (this.hasTuner() && ((RspTuner)this.getTuner()).getTunerController().isLockedSampleRate()) {
            this.getSampleRateCombo().setToolTipText("Sample Rate is locked.  Disable decoding channels to unlock.");
        } else if (this.hasTuner()) {
            this.getSampleRateCombo().setToolTipText("Select a sample rate for the tuner");
        } else {
            this.getSampleRateCombo().setToolTipText("No tuner available");
        }
    }
}

