/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner;

import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceType;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.Rsp1TunerParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.Rsp1aTunerParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.Rsp2TunerParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.RspDuoTunerParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.RspDxTunerParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.TunerParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_RxChannelParamsT;
import java.lang.foreign.MemorySegment;

public class TunerParametersFactory {
    public static TunerParameters create(DeviceType deviceType, MemorySegment memorySegment) {
        MemorySegment tunerParametersMemorySegment = sdrplay_api_RxChannelParamsT.tunerParams$slice(memorySegment);
        switch (deviceType) {
            case RSP1: {
                return new Rsp1TunerParameters(tunerParametersMemorySegment);
            }
            case RSP1A: {
                MemorySegment rsp1AMemorySegment = sdrplay_api_RxChannelParamsT.rsp1aTunerParams$slice(memorySegment);
                return new Rsp1aTunerParameters(memorySegment, rsp1AMemorySegment);
            }
            case RSP2: {
                MemorySegment rsp2MemorySegment = sdrplay_api_RxChannelParamsT.rsp2TunerParams$slice(memorySegment);
                return new Rsp2TunerParameters(memorySegment, rsp2MemorySegment);
            }
            case RSPduo: {
                MemorySegment rspDuoMemorySegment = sdrplay_api_RxChannelParamsT.rspDuoTunerParams$slice(memorySegment);
                return new RspDuoTunerParameters(memorySegment, rspDuoMemorySegment);
            }
            case RSPdx: {
                MemorySegment rspDxMemorySegment = sdrplay_api_RxChannelParamsT.rspDxTunerParams$slice(memorySegment);
                return new RspDxTunerParameters(memorySegment, rspDxMemorySegment);
            }
        }
        throw new IllegalArgumentException("Unrecognized device type: " + String.valueOf((Object)deviceType));
    }
}

