/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner;

import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.Bandwidth;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.DcOffsetTuner;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.Gain;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.IfMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.LoMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.RfFrequency;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_TunerParamsT;
import java.lang.foreign.MemorySegment;

public abstract class TunerParameters {
    private MemorySegment mMemorySegment;
    private RfFrequency mRfFrequency;
    private Gain mGain;
    private DcOffsetTuner mDcOffsetTuner;

    public TunerParameters(MemorySegment memorySegment) {
        this.mMemorySegment = memorySegment;
        this.mRfFrequency = new RfFrequency(sdrplay_api_TunerParamsT.rfFreq$slice(memorySegment));
        this.mGain = new Gain(sdrplay_api_TunerParamsT.gain$slice(memorySegment));
        this.mDcOffsetTuner = new DcOffsetTuner(sdrplay_api_TunerParamsT.dcOffsetTuner$slice(memorySegment));
    }

    private MemorySegment getMemorySegment() {
        return this.mMemorySegment;
    }

    public Bandwidth getBandwidth() {
        return Bandwidth.fromValue(sdrplay_api_TunerParamsT.bwType$get(this.getMemorySegment()));
    }

    public void setBandwidth(Bandwidth bandwidth) {
        sdrplay_api_TunerParamsT.bwType$set(this.getMemorySegment(), bandwidth.getValue());
    }

    public IfMode getIfMode() {
        return IfMode.fromValue(sdrplay_api_TunerParamsT.ifType$get(this.getMemorySegment()));
    }

    public void setIfMode(IfMode ifMode) {
        sdrplay_api_TunerParamsT.ifType$set(this.getMemorySegment(), ifMode.getValue());
    }

    public LoMode getLoMode() {
        return LoMode.fromValue(sdrplay_api_TunerParamsT.loMode$get(this.getMemorySegment()));
    }

    public void setLoMode(LoMode loMode) {
        sdrplay_api_TunerParamsT.loMode$set(this.getMemorySegment(), loMode.getValue());
    }

    public Gain getGain() {
        return this.mGain;
    }

    public RfFrequency getRfFrequency() {
        return this.mRfFrequency;
    }

    public DcOffsetTuner getDcOffsetTuner() {
        return this.mDcOffsetTuner;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tuner Parameters\n");
        sb.append("\tBandwidth: ").append((Object)this.getBandwidth()).append("\n");
        sb.append("\tIF Mode: ").append((Object)this.getIfMode()).append("\n");
        sb.append("\tLO Mode: ").append((Object)this.getLoMode()).append("\n");
        sb.append("\tGain: ").append(this.getGain()).append("\n");
        sb.append("\tRF Frequency: ").append(this.getRfFrequency()).append("\n");
        sb.append("\tDC Offset Tuner: ").append(this.getDcOffsetTuner()).append("\n");
        return sb.toString();
    }
}

