/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner;

import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_h;

public enum IfMode {
    IF_ZERO(sdrplay_api_h.sdrplay_api_IF_Zero(), "ZIF 0.000 MHz"),
    IF_450(sdrplay_api_h.sdrplay_api_IF_0_450(), "0.450 MHz"),
    IF_1620(sdrplay_api_h.sdrplay_api_IF_1_620(), "1.620 MHz"),
    IF_2048(sdrplay_api_h.sdrplay_api_IF_2_048(), "2.048 MHz"),
    UNDEFINED(sdrplay_api_h.sdrplay_api_IF_Undefined(), "UNDEFINED");

    private int mValue;
    private String mDescription;

    private IfMode(int value, String description) {
        this.mValue = value;
        this.mDescription = description;
    }

    public boolean isWidebandSignal() {
        return this.equals((Object)IF_ZERO);
    }

    public int getValue() {
        return this.mValue;
    }

    public static IfMode fromValue(int value) {
        for (IfMode status : IfMode.values()) {
            if (status.getValue() != value) continue;
            return status;
        }
        return UNDEFINED;
    }

    public String toString() {
        return this.mDescription;
    }
}

