/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner;

import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceType;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.FrequencyBand;
import java.util.EnumSet;

public enum GainReduction {
    RSP1_BAND_0_12(FrequencyBand.BAND_0_12, new int[]{3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 56, 53, 50, 47, 44, 41, 58, 55, 52, 49, 46, 43, 45, 42, 58, 55, 52, 49, 46, 43, 41, 38, 35, 32, 29, 26, 23, 20}),
    RSP1_BAND_12_60(FrequencyBand.BAND_12_60, new int[]{3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 56, 53, 50, 47, 44, 41, 58, 55, 52, 49, 46, 43, 45, 42, 58, 55, 52, 49, 46, 43, 41, 38, 35, 32, 29, 26, 23, 20}),
    RSP1_BAND_60_250(FrequencyBand.BAND_60_250, new int[]{3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 56, 53, 50, 47, 44, 41, 58, 55, 52, 49, 46, 43, 45, 42, 58, 55, 52, 49, 46, 43, 41, 38, 35, 32, 29, 26, 23, 20}),
    RSP1_BAND_250_420(FrequencyBand.BAND_250_420, new int[]{3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 56, 53, 50, 47, 44, 41, 58, 55, 52, 49, 46, 43, 45, 42, 58, 55, 52, 49, 46, 43, 41, 38, 35, 32, 29, 26, 23, 20}),
    RSP1_BAND_420_1000(FrequencyBand.BAND_420_1000, new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 1, 1, 1, 1, 1, 0, 0, 0, 0}, new int[]{59, 57, 54, 52, 50, 47, 45, 43, 40, 38, 36, 33, 31, 29, 27, 24, 22, 27, 24, 22, 32, 29, 27, 25, 22, 27, 25, 22, 20}),
    RSP1_BAND_1000_2000(FrequencyBand.BAND_1000_2000, new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 57, 55, 52, 50, 48, 46, 43, 41, 44, 42, 53, 51, 49, 47, 44, 42, 45, 43, 40, 38, 36, 34, 31, 29, 27, 25, 22, 20}),
    RSP1A_BAND_0_12(FrequencyBand.BAND_0_12, new int[]{6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 4, 4, 3, 3, 3, 3, 3, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 45, 41, 57, 53, 49, 46, 42, 44, 40, 56, 52, 48, 45, 41, 44, 40, 43, 45, 41, 38, 34, 31, 27, 24, 20}),
    RSP1A_BAND_12_60(FrequencyBand.BAND_12_60, new int[]{9, 9, 9, 9, 9, 9, 8, 7, 7, 7, 7, 7, 6, 6, 5, 5, 4, 3, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 45, 41, 42, 58, 54, 51, 47, 43, 46, 42, 44, 41, 43, 42, 44, 40, 43, 45, 42, 38, 34, 31, 27, 24, 20}),
    RSP1A_BAND_60_250(FrequencyBand.BAND_60_250, new int[]{9, 9, 9, 9, 9, 9, 8, 7, 7, 7, 7, 7, 6, 6, 5, 5, 4, 3, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 45, 41, 42, 58, 54, 51, 47, 43, 46, 42, 44, 41, 43, 42, 44, 40, 43, 45, 42, 38, 34, 31, 27, 24, 20}),
    RSP1A_BAND_250_420(FrequencyBand.BAND_250_420, new int[]{9, 9, 9, 9, 9, 9, 8, 7, 7, 7, 7, 7, 6, 6, 5, 5, 4, 3, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 45, 41, 42, 58, 54, 51, 47, 43, 46, 42, 44, 41, 43, 42, 44, 40, 43, 45, 42, 38, 34, 31, 27, 24, 20}),
    RSP1A_BAND_420_1000(FrequencyBand.BAND_420_1000, new int[]{9, 9, 9, 9, 9, 9, 8, 8, 8, 8, 8, 7, 6, 6, 5, 5, 4, 4, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 44, 41, 56, 52, 49, 45, 41, 44, 46, 42, 45, 41, 44, 40, 44, 40, 42, 46, 42, 38, 35, 31, 27, 24, 20}),
    RSP1A_BAND_1000_2000(FrequencyBand.BAND_1000_2000, new int[]{8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 6, 5, 5, 4, 4, 3, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 45, 41, 56, 53, 49, 46, 42, 43, 46, 42, 44, 41, 43, 48, 44, 40, 43, 45, 42, 38, 34, 31, 27, 24, 20}),
    RSP2_BAND_0_12(FrequencyBand.BAND_0_12, new int[]{8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 6, 5, 5, 4, 4, 4, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 44, 41, 56, 52, 49, 45, 41, 44, 45, 41, 48, 44, 40, 45, 42, 43, 49, 46, 42, 38, 35, 31, 27, 24, 20}),
    RSP2_BAND_12_60(FrequencyBand.BAND_12_60, new int[]{8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 6, 5, 5, 4, 4, 4, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 44, 41, 56, 52, 49, 45, 41, 44, 45, 41, 48, 44, 40, 45, 42, 43, 49, 46, 42, 38, 35, 31, 27, 24, 20}),
    RSP2_BAND_60_250(FrequencyBand.BAND_60_250, new int[]{8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 6, 5, 5, 4, 4, 4, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 44, 41, 56, 52, 49, 45, 41, 44, 45, 41, 48, 44, 40, 45, 42, 43, 49, 46, 42, 38, 35, 31, 27, 24, 20}),
    RSP2_BAND_250_420(FrequencyBand.BAND_250_420, new int[]{8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 6, 5, 5, 4, 4, 4, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 44, 41, 56, 52, 49, 45, 41, 44, 45, 41, 48, 44, 40, 45, 42, 43, 49, 46, 42, 38, 35, 31, 27, 24, 20}),
    RSP2_BAND_420_1000(FrequencyBand.BAND_420_1000, new int[]{5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 3, 3, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 56, 53, 50, 48, 45, 42, 58, 55, 52, 49, 47, 44, 41, 43, 40, 44, 41, 42, 46, 43, 40, 37, 34, 31, 29, 26, 23, 20}),
    RSP2_BAND_1000_2000(FrequencyBand.BAND_1000_2000, new int[]{4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 2, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 56, 54, 51, 48, 45, 43, 40, 56, 54, 51, 48, 45, 43, 40, 43, 41, 44, 41, 44, 42, 39, 36, 34, 31, 28, 25, 23, 20}),
    RSP_DUO_BAND_0_12(FrequencyBand.BAND_0_12, new int[]{6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 4, 4, 3, 3, 3, 3, 3, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 45, 41, 57, 53, 49, 46, 42, 44, 40, 56, 52, 48, 45, 41, 44, 40, 43, 45, 41, 38, 34, 31, 27, 24, 20}),
    RSP_DUO_BAND_12_60(FrequencyBand.BAND_12_60, new int[]{9, 9, 9, 9, 9, 9, 8, 7, 7, 7, 7, 7, 6, 6, 5, 5, 4, 3, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 45, 41, 42, 58, 54, 51, 47, 43, 46, 42, 44, 41, 43, 42, 44, 40, 43, 45, 42, 38, 34, 31, 27, 24, 20}),
    RSP_DUO_BAND_60_250(FrequencyBand.BAND_60_250, new int[]{9, 9, 9, 9, 9, 9, 8, 7, 7, 7, 7, 7, 6, 6, 5, 5, 4, 3, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 45, 41, 42, 58, 54, 51, 47, 43, 46, 42, 44, 41, 43, 42, 44, 40, 43, 45, 42, 38, 34, 31, 27, 24, 20}),
    RSP_DUO_BAND_250_420(FrequencyBand.BAND_250_420, new int[]{9, 9, 9, 9, 9, 9, 8, 7, 7, 7, 7, 7, 6, 6, 5, 5, 4, 3, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 45, 41, 42, 58, 54, 51, 47, 43, 46, 42, 44, 41, 43, 42, 44, 40, 43, 45, 42, 38, 34, 31, 27, 24, 20}),
    RSP_DUO_BAND_420_1000(FrequencyBand.BAND_420_1000, new int[]{9, 9, 9, 9, 9, 9, 8, 8, 8, 8, 8, 7, 6, 6, 5, 5, 4, 4, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 44, 41, 56, 52, 49, 45, 41, 44, 46, 42, 45, 41, 44, 40, 44, 40, 42, 46, 42, 38, 35, 31, 27, 24, 20}),
    RSP_DUO_BAND_1000_2000(FrequencyBand.BAND_1000_2000, new int[]{8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 6, 5, 5, 4, 4, 3, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 45, 41, 56, 53, 49, 46, 42, 43, 46, 42, 44, 41, 43, 48, 44, 40, 43, 45, 42, 38, 34, 31, 27, 24, 20}),
    RSP_DX_BAND_0_12(FrequencyBand.BAND_0_12, new int[]{18, 18, 18, 18, 18, 18, 17, 16, 14, 13, 12, 11, 10, 9, 7, 6, 5, 5, 5, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 45, 41, 41, 40, 43, 42, 42, 41, 41, 40, 42, 42, 47, 44, 40, 43, 42, 42, 41, 38, 34, 31, 27, 24, 20}),
    RSP_DX_BAND_12_60(FrequencyBand.BAND_12_60, new int[]{26, 26, 26, 26, 26, 25, 23, 22, 20, 19, 17, 16, 14, 13, 11, 10, 8, 7, 5, 5, 5, 3, 2, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 50, 46, 41, 40, 42, 40, 42, 40, 42, 41, 42, 41, 43, 41, 43, 41, 49, 45, 40, 42, 40, 42, 38, 33, 29, 24, 20}),
    RSP_DX_BAND_60_250(FrequencyBand.BAND_60_250, new int[]{26, 26, 26, 26, 26, 25, 23, 22, 20, 19, 17, 16, 14, 13, 11, 10, 8, 7, 5, 5, 5, 3, 2, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 50, 46, 41, 40, 42, 40, 42, 40, 42, 41, 42, 41, 43, 41, 43, 41, 49, 45, 40, 42, 40, 42, 38, 33, 29, 24, 20}),
    RSP_DX_BAND_250_420(FrequencyBand.BAND_250_420, new int[]{27, 27, 27, 27, 27, 26, 24, 23, 21, 20, 18, 17, 15, 14, 12, 11, 9, 8, 6, 6, 5, 3, 2, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 50, 46, 41, 40, 42, 40, 42, 40, 42, 41, 42, 41, 43, 41, 43, 41, 46, 42, 40, 42, 40, 42, 38, 33, 29, 24, 20}),
    RSP_DX_BAND_420_1000(FrequencyBand.BAND_420_1000, new int[]{20, 20, 20, 20, 20, 20, 18, 17, 16, 14, 13, 12, 11, 9, 8, 7, 7, 5, 4, 3, 2, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 51, 48, 44, 40, 42, 42, 41, 43, 42, 41, 41, 43, 42, 44, 40, 43, 42, 41, 40, 46, 43, 39, 35, 31, 28, 24, 20}),
    RSP_DX_BAND_1000_2000(FrequencyBand.BAND_1000_2000, new int[]{18, 18, 18, 18, 18, 18, 16, 15, 14, 13, 11, 10, 9, 8, 7, 6, 6, 6, 5, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 44, 40, 43, 42, 41, 41, 43, 42, 41, 41, 40, 48, 45, 41, 40, 42, 42, 41, 42, 39, 35, 31, 27, 24, 20}),
    RSP_2_AND_DUO_HIZ_BAND_0_12(FrequencyBand.BAND_0_12, new int[]{4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 2, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 56, 54, 51, 48, 45, 43, 40, 56, 54, 51, 48, 45, 43, 40, 43, 41, 44, 41, 44, 42, 39, 36, 34, 31, 28, 25, 23, 20}),
    RSP_2_AND_DUO_HIZ_BAND_12_60(FrequencyBand.BAND_12_60, new int[]{4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 2, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 56, 54, 51, 48, 45, 43, 40, 56, 54, 51, 48, 45, 43, 40, 43, 41, 44, 41, 44, 42, 39, 36, 34, 31, 28, 25, 23, 20}),
    RSP_DX_HDR_BAND_0_2(FrequencyBand.BAND_0_12, new int[]{18, 18, 18, 18, 18, 18, 17, 16, 14, 13, 12, 11, 10, 9, 7, 6, 5, 5, 5, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0}, new int[]{59, 55, 52, 48, 45, 41, 41, 40, 43, 42, 42, 41, 41, 40, 42, 42, 47, 44, 40, 43, 42, 42, 41, 38, 34, 31, 27, 24, 20}),
    UNKNOWN(FrequencyBand.UNKNOWN, new int[0], new int[0]);

    private FrequencyBand mFrequencyBand;
    private int[] mLnaStates;
    private int[] mGainReductions;
    public static int MIN_GAIN_INDEX;
    public static int MAX_GAIN_INDEX;
    public static int GAIN_STEPS_AVAILABLE;
    public static EnumSet<GainReduction> RSP_1_GAINS;
    public static EnumSet<GainReduction> RSP_1A_GAINS;
    public static EnumSet<GainReduction> RSP_2_GAINS;
    public static EnumSet<GainReduction> RSP_DUO_GAINS;
    public static EnumSet<GainReduction> RSP_DX_GAINS;
    public static EnumSet<GainReduction> RSP_DX_HDR_GAINS;
    public static EnumSet<GainReduction> RSP_HIZ_GAINS;

    private GainReduction(FrequencyBand frequencyBand, int[] lnaStates, int[] gainReductions) {
        this.mFrequencyBand = frequencyBand;
        this.mLnaStates = lnaStates;
        this.mGainReductions = gainReductions;
    }

    public int getGainIndex(int gainReductionValue) {
        for (int x = 0; x < this.mGainReductions.length; ++x) {
            if (this.mGainReductions[x] != gainReductionValue) continue;
            return x;
        }
        return -1;
    }

    public static GainReduction lookup(DeviceType deviceType, FrequencyBand frequencyBand) {
        switch (deviceType) {
            case RSP1: {
                return GainReduction.fromBand(frequencyBand, RSP_1_GAINS);
            }
            case RSP1A: {
                return GainReduction.fromBand(frequencyBand, RSP_1A_GAINS);
            }
            case RSP2: {
                return GainReduction.fromBand(frequencyBand, RSP_2_GAINS);
            }
            case RSPduo: {
                return GainReduction.fromBand(frequencyBand, RSP_DUO_GAINS);
            }
            case RSPdx: {
                return GainReduction.fromBand(frequencyBand, RSP_DX_GAINS);
            }
        }
        return UNKNOWN;
    }

    public static GainReduction lookup(DeviceType deviceType, long frequency) {
        FrequencyBand band = FrequencyBand.fromValue(frequency);
        return GainReduction.lookup(deviceType, band);
    }

    private static GainReduction fromBand(FrequencyBand frequencyBand, EnumSet<GainReduction> values) {
        for (GainReduction gainReduction : values) {
            if (gainReduction.getFrequencyBand() != frequencyBand) continue;
            return gainReduction;
        }
        return UNKNOWN;
    }

    public FrequencyBand getFrequencyBand() {
        return this.mFrequencyBand;
    }

    private int[] getLnaStates() {
        return this.mLnaStates;
    }

    private int[] getGainReductions() {
        return this.mGainReductions;
    }

    public int getLnaState(int index) {
        if (MIN_GAIN_INDEX <= index && index <= MAX_GAIN_INDEX) {
            return this.getLnaStates()[index];
        }
        throw new IllegalArgumentException("Unrecognized gain index [" + index + "] - valid range: " + MIN_GAIN_INDEX + " <> " + MAX_GAIN_INDEX);
    }

    public int getGainReduction(int index) {
        if (MIN_GAIN_INDEX <= index && index <= MAX_GAIN_INDEX) {
            return this.getGainReductions()[index];
        }
        throw new IllegalArgumentException("Unrecognized gain index [" + index + "] - valid range: " + MIN_GAIN_INDEX + " <> " + MAX_GAIN_INDEX);
    }

    public boolean isValidFor(long frequency) {
        return this.getFrequencyBand().contains(frequency);
    }

    static {
        MIN_GAIN_INDEX = 0;
        MAX_GAIN_INDEX = 28;
        GAIN_STEPS_AVAILABLE = 29;
        RSP_1_GAINS = EnumSet.range(RSP1_BAND_0_12, RSP1_BAND_1000_2000);
        RSP_1A_GAINS = EnumSet.range(RSP1A_BAND_0_12, RSP1A_BAND_1000_2000);
        RSP_2_GAINS = EnumSet.range(RSP2_BAND_0_12, RSP2_BAND_1000_2000);
        RSP_DUO_GAINS = EnumSet.range(RSP_DUO_BAND_0_12, RSP_DUO_BAND_1000_2000);
        RSP_DX_GAINS = EnumSet.range(RSP_DX_BAND_0_12, RSP_DX_BAND_1000_2000);
        RSP_DX_HDR_GAINS = EnumSet.of(RSP_DX_HDR_BAND_0_2);
        RSP_HIZ_GAINS = EnumSet.range(RSP_2_AND_DUO_HIZ_BAND_0_12, RSP_2_AND_DUO_HIZ_BAND_12_60);
    }
}

