/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner;

import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.GainReduction;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.GainValues;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.MinimumGainReductionMode;
import io.github.dsheirer.source.tuner.sdrplay.api.util.Flag;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_GainT;
import java.lang.foreign.MemorySegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gain {
    private static final Logger mLog = LoggerFactory.getLogger(Gain.class);
    private MemorySegment mMemorySegment;
    private GainValues mGainValues;

    public Gain(MemorySegment memorySegment) {
        this.mMemorySegment = memorySegment;
        this.mGainValues = new GainValues(sdrplay_api_GainT.gainVals$slice(memorySegment));
    }

    private MemorySegment getMemorySegment() {
        return this.mMemorySegment;
    }

    public void setGain(GainReduction gainReduction, int index) {
        this.setLNA(gainReduction.getLnaState(index));
        this.setGainReductionDb(gainReduction.getGainReduction(index));
    }

    public int getGainReductionDb() {
        return sdrplay_api_GainT.gRdB$get(this.getMemorySegment());
    }

    public void setGainReductionDb(int gainReductionDb) {
        sdrplay_api_GainT.gRdB$set(this.getMemorySegment(), gainReductionDb);
    }

    public int getLNA() {
        return sdrplay_api_GainT.LNAstate$get(this.getMemorySegment());
    }

    public void setLNA(int lna) {
        sdrplay_api_GainT.LNAstate$set(this.getMemorySegment(), (byte)lna);
    }

    public void setSynchronousUpdate(boolean syncUpdate) {
        sdrplay_api_GainT.syncUpdate$set(this.getMemorySegment(), Flag.of(syncUpdate));
    }

    public MinimumGainReductionMode getMinimumGainReductionMode() {
        return MinimumGainReductionMode.fromValue(sdrplay_api_GainT.minGr$get(this.getMemorySegment()));
    }

    public void setMinimumGainReductionMode(MinimumGainReductionMode minimumGainReductionMode) {
        sdrplay_api_GainT.minGr$set(this.getMemorySegment(), minimumGainReductionMode.getValue());
    }

    public GainValues getGainValues() {
        return this.mGainValues;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Reduction:").append(this.getGainReductionDb()).append("dB");
        sb.append(" LNA:").append(this.getLNA());
        sb.append(" Min Gain Reduction Mode:").append((Object)this.getMinimumGainReductionMode());
        sb.append(" Gain Values:").append(this.getGainValues());
        return sb.toString();
    }
}

