/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.parameter.device;

import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_FsFreqT;
import java.lang.foreign.MemorySegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplingFrequency {
    private Logger mLog = LoggerFactory.getLogger(SamplingFrequency.class);
    private MemorySegment mMemorySegment;

    public SamplingFrequency(MemorySegment memorySegment) {
        this.mMemorySegment = memorySegment;
    }

    private MemorySegment getMemorySegment() {
        return this.mMemorySegment;
    }

    public double getSampleRate() {
        return sdrplay_api_FsFreqT.fsHz$get(this.getMemorySegment());
    }

    public void setSampleRate(double sampleRate, boolean synchronousUpdate, boolean recalibrate) {
        sdrplay_api_FsFreqT.fsHz$set(this.getMemorySegment(), sampleRate);
        sdrplay_api_FsFreqT.syncUpdate$set(this.getMemorySegment(), synchronousUpdate ? (byte)1 : 0);
        sdrplay_api_FsFreqT.reCal$set(this.getMemorySegment(), recalibrate ? (byte)1 : 0);
    }

    public void setSampleRate(double sampleRate) {
        this.setSampleRate(sampleRate, false, false);
    }

    public String toString() {
        return "Sample Rate:" + this.getSampleRate();
    }
}

