/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.parameter.device;

import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.ResetFlags;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.SamplingFrequency;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.SynchronousUpdate;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.TransferMode;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_DevParamsT;
import java.lang.foreign.MemorySegment;

public abstract class DeviceParameters {
    private MemorySegment mMemorySegment;
    private SamplingFrequency mSamplingFrequency;
    private SynchronousUpdate mSynchronousUpdate;
    private ResetFlags mResetFlags;

    public DeviceParameters(MemorySegment memorySegment) {
        this.mMemorySegment = memorySegment;
        this.mSamplingFrequency = new SamplingFrequency(sdrplay_api_DevParamsT.fsFreq$slice(memorySegment));
        this.mSynchronousUpdate = new SynchronousUpdate(sdrplay_api_DevParamsT.syncUpdate$slice(memorySegment));
        this.mResetFlags = new ResetFlags(sdrplay_api_DevParamsT.resetFlags$slice(memorySegment));
    }

    protected MemorySegment getMemorySegment() {
        return this.mMemorySegment;
    }

    public double getPPM() {
        return sdrplay_api_DevParamsT.ppm$get(this.getMemorySegment());
    }

    public void setPPM(double ppm) {
        sdrplay_api_DevParamsT.ppm$set(this.getMemorySegment(), ppm);
    }

    public SamplingFrequency getSamplingFrequency() {
        return this.mSamplingFrequency;
    }

    public SynchronousUpdate getSynchronousUpdate() {
        return this.mSynchronousUpdate;
    }

    public ResetFlags getResetFlags() {
        return this.mResetFlags;
    }

    public TransferMode getTransferMode() {
        return TransferMode.fromValue(sdrplay_api_DevParamsT.mode$get(this.getMemorySegment()));
    }

    public void setTransferMode(TransferMode transferMode) {
        if (transferMode != TransferMode.UNKNOWN) {
            sdrplay_api_DevParamsT.mode$set(this.getMemorySegment(), transferMode.getValue());
        }
    }

    public long getSamplesPerPacket() {
        return sdrplay_api_DevParamsT.samplesPerPkt$get(this.getMemorySegment());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tDevice Parameters").append("\n");
        sb.append("\t\tPPM: ").append(this.getPPM()).append("\n");
        sb.append("\t\tSample Rate: ").append(this.getSamplingFrequency()).append("\n");
        sb.append("\t\tSamples Per Packet: ").append(this.getSamplesPerPacket()).append("\n");
        sb.append("\t\tSync Update: ").append(this.getSynchronousUpdate()).append("\n");
        sb.append("\t\tReset Flags: ").append(this.getResetFlags()).append("\n");
        sb.append("\t\tTransfer Mode: ").append((Object)this.getTransferMode()).append("\n");
        return sb.toString();
    }
}

