/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite;

import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceType;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite.CompositeParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.ControlParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.RspDuoDeviceParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.RspDuoTunerParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.TunerParametersFactory;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_DeviceParamsT;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_RxChannelParamsT;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;

public class RspDuoCompositeParameters
extends CompositeParameters<RspDuoDeviceParameters, RspDuoTunerParameters> {
    private RspDuoTunerParameters mTunerBParameters;
    private ControlParameters mControlBParameters;

    public RspDuoCompositeParameters(MemorySegment memorySegment, Arena arena) {
        super(DeviceType.RSPduo, memorySegment, arena);
        MemorySegment memoryAddressRxB = sdrplay_api_DeviceParamsT.rxChannelB$get(memorySegment);
        MemorySegment memorySegmentRxB = sdrplay_api_RxChannelParamsT.ofAddress(memoryAddressRxB, arena.scope());
        this.mTunerBParameters = (RspDuoTunerParameters)TunerParametersFactory.create(DeviceType.RSPduo, memorySegmentRxB);
        MemorySegment tunerBControlParametersMemorySegment = sdrplay_api_RxChannelParamsT.ctrlParams$slice(memorySegmentRxB);
        this.mControlBParameters = new ControlParameters(tunerBControlParametersMemorySegment);
    }

    public RspDuoTunerParameters getTunerBParameters() {
        return this.mTunerBParameters;
    }

    public ControlParameters getControlBParameters() {
        return this.mControlBParameters;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Device Composite Parameters\n");
        sb.append("\tDevice Parameters:\n").append(this.getDeviceParameters()).append("\n");
        sb.append("\tTuner Channel A:\n").append(this.getTunerAParameters()).append("\n");
        sb.append("\tTuner Channel B:\n").append(this.getTunerBParameters()).append("\n");
        return sb.toString();
    }
}

