/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.device;

import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceType;
import io.github.dsheirer.source.tuner.sdrplay.api.device.IDeviceStruct;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspDuoMode;
import io.github.dsheirer.source.tuner.sdrplay.api.device.TunerSelect;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_08.sdrplay_api_DeviceT;
import java.lang.foreign.MemorySegment;

public class DeviceStruct_v3_08
implements IDeviceStruct {
    private MemorySegment mDeviceMemorySegment;
    private DeviceType mDeviceType;
    private String mSerialNumber;

    public DeviceStruct_v3_08(MemorySegment deviceMemorySegment) {
        this.mDeviceMemorySegment = deviceMemorySegment;
        this.mDeviceType = DeviceType.fromValue(0xFF & sdrplay_api_DeviceT.hwVer$get(this.mDeviceMemorySegment));
        MemorySegment serialSegment = sdrplay_api_DeviceT.SerNo$slice(this.mDeviceMemorySegment);
        this.mSerialNumber = serialSegment.getUtf8String(0L);
    }

    @Override
    public MemorySegment getDeviceMemorySegment() {
        return this.mDeviceMemorySegment;
    }

    @Override
    public String getSerialNumber() {
        return this.mSerialNumber;
    }

    @Override
    public DeviceType getDeviceType() {
        return this.mDeviceType;
    }

    @Override
    public TunerSelect getTunerSelect() {
        return TunerSelect.fromValue(sdrplay_api_DeviceT.tuner$get(this.getDeviceMemorySegment()));
    }

    @Override
    public RspDuoMode getRspDuoMode() {
        return RspDuoMode.fromValue(sdrplay_api_DeviceT.rspDuoMode$get(this.getDeviceMemorySegment()));
    }

    @Override
    public void setRspDuoMode(RspDuoMode mode) {
        sdrplay_api_DeviceT.rspDuoMode$set(this.getDeviceMemorySegment(), mode.getValue());
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public double getRspDuoSampleFrequency() {
        return sdrplay_api_DeviceT.rspDuoSampleFreq$get(this.getDeviceMemorySegment());
    }

    @Override
    public void setRspDuoSampleFrequency(double frequency) {
        sdrplay_api_DeviceT.rspDuoSampleFreq$set(this.getDeviceMemorySegment(), frequency);
    }

    @Override
    public MemorySegment getDeviceHandle() {
        return sdrplay_api_DeviceT.dev$get(this.getDeviceMemorySegment());
    }
}

