/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.device;

import io.github.dsheirer.source.tuner.sdrplay.api.DeviceSelectionMode;
import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceType;
import io.github.dsheirer.source.tuner.sdrplay.api.device.IDeviceStruct;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class DeviceInfo {
    private DeviceSelectionMode mDeviceSelectionMode = DeviceSelectionMode.SINGLE_TUNER_1;
    private DeviceType mDeviceType;
    private String mSerialNumber;

    public DeviceInfo(DeviceType deviceType, String serialNumber) {
        Validate.notNull((Object)((Object)deviceType), (String)"Device type cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)serialNumber, (String)"Device serial number cannot be null", (Object[])new Object[0]);
        this.mDeviceType = deviceType;
        this.mSerialNumber = serialNumber;
    }

    public DeviceInfo(IDeviceStruct deviceStruct) {
        this(deviceStruct.getDeviceType(), deviceStruct.getSerialNumber());
    }

    public DeviceType getDeviceType() {
        return this.mDeviceType;
    }

    public String getSerialNumber() {
        return this.mSerialNumber;
    }

    public DeviceSelectionMode getDeviceSelectionMode() {
        return this.mDeviceSelectionMode;
    }

    public void setDeviceSelectionMode(DeviceSelectionMode deviceSelectionMode) {
        Validate.notNull((Object)((Object)deviceSelectionMode), (String)"Device selection mode cannot be null", (Object[])new Object[0]);
        this.mDeviceSelectionMode = deviceSelectionMode;
    }

    public DeviceInfo clone() {
        return new DeviceInfo(this.mDeviceType, this.mSerialNumber);
    }

    public boolean matches(IDeviceStruct deviceStruct) {
        return deviceStruct != null && this.getDeviceType().equals((Object)deviceStruct.getDeviceType()) && this.getSerialNumber().equals(deviceStruct.getSerialNumber());
    }

    public String toString() {
        return "Device: " + String.valueOf((Object)this.getDeviceType()) + " Serial Number: " + this.getSerialNumber() + " Selection Mode: " + String.valueOf((Object)this.getDeviceSelectionMode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceInfo that = (DeviceInfo)o;
        return this.mDeviceSelectionMode == that.mDeviceSelectionMode && this.mDeviceType == that.mDeviceType && this.mSerialNumber.equals(that.mSerialNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mDeviceSelectionMode, this.mDeviceType, this.mSerialNumber});
    }
}

