/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.device;

import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRplay;
import io.github.dsheirer.source.tuner.sdrplay.api.Status;
import io.github.dsheirer.source.tuner.sdrplay.api.UpdateReason;
import io.github.dsheirer.source.tuner.sdrplay.api.async.AsyncUpdateFuture;
import io.github.dsheirer.source.tuner.sdrplay.api.async.CompletedAsyncUpdate;
import io.github.dsheirer.source.tuner.sdrplay.api.callback.IDeviceEventListener;
import io.github.dsheirer.source.tuner.sdrplay.api.callback.IStreamCallbackListener;
import io.github.dsheirer.source.tuner.sdrplay.api.callback.IStreamListener;
import io.github.dsheirer.source.tuner.sdrplay.api.callback.StreamCallbackParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.device.Decimate;
import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceType;
import io.github.dsheirer.source.tuner.sdrplay.api.device.IDeviceStruct;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspTuner;
import io.github.dsheirer.source.tuner.sdrplay.api.device.TunerSelect;
import io.github.dsheirer.source.tuner.sdrplay.api.error.DebugLevel;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite.CompositeParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.DeviceParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.IfMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.LoMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.TunerParameters;
import java.lang.foreign.MemorySegment;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Device<T extends CompositeParameters<?, ?>, R extends RspTuner<?, ?>> {
    private static final Logger mLog = LoggerFactory.getLogger(Device.class);
    private SDRplay mSDRplay;
    private final UpdateRequestManager mUpdateRequestManager = new UpdateRequestManager();
    private final IDeviceStruct mDeviceStruct;
    protected boolean mSelected = false;
    protected boolean mInitialized = false;
    private T mCompositeParameters;

    public Device(SDRplay sdrPlay, IDeviceStruct deviceStruct) {
        this.mSDRplay = sdrPlay;
        this.mDeviceStruct = deviceStruct;
    }

    protected IDeviceStruct getDeviceStruct() {
        return this.mDeviceStruct;
    }

    protected SDRplay getAPI() {
        return this.mSDRplay;
    }

    public IStreamCallbackListener getStreamCallbackListener() {
        return this.mUpdateRequestManager;
    }

    private void loadDeviceParameters() throws SDRPlayException {
        if (this.selected()) {
            this.mCompositeParameters = this.getAPI().getCompositeParameters(this.getDeviceType(), this.getDeviceHandle());
        }
    }

    public void setDebugLevel(DebugLevel debugLevel) {
        try {
            this.mSDRplay.setDebugLevel(this.getDeviceHandle(), debugLevel);
        }
        catch (SDRPlayException se) {
            mLog.info("Unable to set debug level [" + String.valueOf((Object)debugLevel) + "] for device - not selected", (Throwable)se);
        }
    }

    public void select() throws SDRPlayException {
        if (!this.selected()) {
            this.getAPI().select(this.getDeviceMemorySegment());
            this.mSelected = true;
            this.loadDeviceParameters();
        }
    }

    protected boolean selected() {
        return this.mSelected;
    }

    public boolean isValid() {
        return this.getDeviceStruct().isValid();
    }

    public void release() throws SDRPlayException {
        if (this.selected()) {
            this.mSelected = false;
            this.getAPI().release(this.getDeviceMemorySegment());
        }
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public void initStreamA(IDeviceEventListener eventListener, IStreamListener streamListener) throws SDRPlayException {
        if (!this.isSelected()) {
            throw new SDRPlayException("Device must be selected before it can be initialized");
        }
        if (this.isInitialized()) {
            throw new SDRPlayException("Device has already been initialized with listeners");
        }
        this.getAPI().initA(this, this.getDeviceHandle(), eventListener, streamListener);
        this.mInitialized = true;
    }

    public void initStreamB(IDeviceEventListener eventListener, IStreamListener streamListener) throws SDRPlayException {
        if (!this.isSelected()) {
            throw new SDRPlayException("Device must be selected before it can be initialized");
        }
        if (this.isInitialized()) {
            throw new SDRPlayException("Device has already been initialized with listeners");
        }
        this.getAPI().initB(this, this.getDeviceHandle(), eventListener, streamListener);
        this.mInitialized = true;
    }

    public void uninitialize() throws SDRPlayException {
        if (!this.isInitialized()) {
            throw new SDRPlayException("Attempt to uninit a device that has not been initialized previously");
        }
        this.getAPI().uninit(this.getDeviceHandle());
        this.mInitialized = false;
    }

    public void update(TunerSelect tunerSelect, UpdateReason ... updateReasons) throws SDRPlayException {
        if (this.isInitialized()) {
            this.submitUpdate(tunerSelect, updateReasons);
        }
    }

    private String toString(UpdateReason ... updateReasons) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (UpdateReason updateReason : updateReasons) {
            if (first) {
                sb.append("[");
            } else {
                sb.append(", ");
            }
            sb.append(updateReason.name());
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    protected AsyncUpdateFuture updateAsync(TunerSelect tunerSelect, UpdateReason updateReason, UpdateReason expectedResponse) {
        if (!expectedResponse.isAsyncUpdateResponse()) {
            throw new IllegalArgumentException("Invalid expected response: " + String.valueOf((Object)expectedResponse) + ". Valid values are: " + String.valueOf(UpdateReason.ASYNC_UPDATE_RESPONSES));
        }
        if (this.isInitialized()) {
            return this.mUpdateRequestManager.update(tunerSelect, updateReason, expectedResponse);
        }
        AsyncUpdateFuture future = new AsyncUpdateFuture(tunerSelect, updateReason, expectedResponse);
        future.setResult(Status.SUCCESS);
        return future;
    }

    private void submitUpdate(TunerSelect tunerSelect, UpdateReason ... updateReasons) throws SDRPlayException {
        this.getAPI().update(this, this.getDeviceHandle(), tunerSelect, updateReasons);
    }

    public void acknowledgePowerOverload(TunerSelect tunerSelect) throws SDRPlayException {
        block3: {
            if (this.isInitialized()) {
                try {
                    this.update(tunerSelect, UpdateReason.CONTROL_OVERLOAD_MESSAGE_ACK);
                }
                catch (SDRPlayException se) {
                    if (se.getStatus() == Status.NOT_INITIALIZED) break block3;
                    throw se;
                }
            }
        }
    }

    public TunerSelect getTunerSelect() {
        return TunerSelect.TUNER_1;
    }

    protected MemorySegment getDeviceMemorySegment() {
        return this.getDeviceStruct().getDeviceMemorySegment();
    }

    MemorySegment getDeviceHandle() throws SDRPlayException {
        if (!this.selected()) {
            throw new SDRPlayException("This device must be selected for exclusive use before accessing/using the device handle");
        }
        return this.getDeviceStruct().getDeviceHandle();
    }

    public abstract R getTuner() throws SDRPlayException;

    public T getCompositeParameters() {
        return this.mCompositeParameters;
    }

    public boolean hasCompositeParameters() {
        return this.mCompositeParameters != null;
    }

    public boolean isSelected() {
        return this.mSelected;
    }

    public DeviceType getDeviceType() {
        return this.getDeviceStruct().getDeviceType();
    }

    public String getSerialNumber() {
        return this.getDeviceStruct().getSerialNumber();
    }

    public double getSampleRate() {
        return ((DeviceParameters)((CompositeParameters)this.getCompositeParameters()).getDeviceParameters()).getSamplingFrequency().getSampleRate();
    }

    public void setIfMode(IfMode ifMode) {
        ((TunerParameters)((CompositeParameters)this.getCompositeParameters()).getTunerAParameters()).setIfMode(ifMode);
    }

    public void setLoMode(LoMode loMode) {
        ((TunerParameters)((CompositeParameters)this.getCompositeParameters()).getTunerAParameters()).setLoMode(loMode);
    }

    public void setWidebandSignal(boolean enable) throws SDRPlayException {
        ((CompositeParameters)this.getCompositeParameters()).getControlAParameters().getDecimation().setWideBandSignal(enable);
        if (this.isInitialized()) {
            this.update(this.getTunerSelect(), UpdateReason.CONTROL_DECIMATION);
        }
    }

    public void setDecimation(Decimate decimate) throws SDRPlayException {
        ((CompositeParameters)this.getCompositeParameters()).getControlAParameters().getDecimation().setDecimationFactor(decimate.getValue());
        ((CompositeParameters)this.getCompositeParameters()).getControlAParameters().getDecimation().setEnabled(decimate.isEnabled());
        if (this.isInitialized()) {
            this.update(this.getTunerSelect(), UpdateReason.CONTROL_DECIMATION);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SDRPplay Device").append("\n");
        sb.append("\tType: ").append((Object)this.getDeviceType()).append("\n");
        sb.append("\tSerial Number: ").append(this.getSerialNumber()).append("\n");
        sb.append("\tSelected: ").append(this.isSelected());
        if (this.hasCompositeParameters()) {
            sb.append("\t").append(this.getCompositeParameters());
        }
        return sb.toString();
    }

    class UpdateRequestManager
    implements IStreamCallbackListener {
        private static final long UPDATE_QUEUE_PROCESSING_INTERVAL_MS = 75L;
        private final ScheduledExecutorService mExecutorService = Executors.newSingleThreadScheduledExecutor();
        private final Queue<AsyncUpdateFuture> mUpdateQueue = new ConcurrentLinkedQueue<AsyncUpdateFuture>();
        private final Queue<CompletedAsyncUpdate> mCompletedUpdateQueue = new ConcurrentLinkedQueue<CompletedAsyncUpdate>();
        private final ReentrantLock mLock = new ReentrantLock();

        UpdateRequestManager() {
        }

        public AsyncUpdateFuture update(TunerSelect tunerSelect, UpdateReason updateReason, UpdateReason expectedResponse) {
            AsyncUpdateFuture future = new AsyncUpdateFuture(tunerSelect, updateReason, expectedResponse);
            this.mUpdateQueue.add(future);
            this.processQueuesImmediately();
            return future;
        }

        private void processQueuesImmediately() {
            this.processQueuesAfterDelay(0L);
        }

        private void processQueuesAfterDelay(long delay) {
            this.mExecutorService.schedule(() -> this.processQueues(), delay, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void processQueues() {
            block10: {
                this.mLock.lock();
                try {
                    if (this.mUpdateQueue.isEmpty()) {
                        this.mCompletedUpdateQueue.clear();
                        break block10;
                    }
                    boolean processing = true;
                    block5: while (processing) {
                        processing = false;
                        AsyncUpdateFuture futureUpdate = this.mUpdateQueue.peek();
                        if (futureUpdate == null) continue;
                        if (futureUpdate.isSubmitted()) {
                            while (!this.mCompletedUpdateQueue.isEmpty()) {
                                CompletedAsyncUpdate completedUpdate = this.mCompletedUpdateQueue.poll();
                                if (completedUpdate == null || !futureUpdate.matches(completedUpdate)) continue;
                                this.mCompletedUpdateQueue.clear();
                                this.mUpdateQueue.remove();
                                futureUpdate.setResult(Status.SUCCESS);
                                processing = true;
                                continue block5;
                            }
                            continue;
                        }
                        this.mCompletedUpdateQueue.clear();
                        try {
                            Device.this.submitUpdate(futureUpdate.getTunerSelect(), futureUpdate.getUpdateReason());
                            futureUpdate.setSubmitted(true);
                        }
                        catch (SDRPlayException se) {
                            futureUpdate = this.mUpdateQueue.poll();
                            futureUpdate.setError(se);
                            processing = true;
                        }
                    }
                }
                finally {
                    this.mLock.unlock();
                }
            }
            if (!this.mUpdateQueue.isEmpty()) {
                this.processQueuesAfterDelay(75L);
            }
        }

        public void completed(TunerSelect tunerSelect, UpdateReason updateReason) {
            this.mCompletedUpdateQueue.add(new CompletedAsyncUpdate(tunerSelect, updateReason));
            this.mExecutorService.schedule(this::processQueues, 0L, TimeUnit.MILLISECONDS);
        }

        public void reset() {
            this.mLock.lock();
            try {
                while (!this.mUpdateQueue.isEmpty()) {
                    AsyncUpdateFuture future = this.mUpdateQueue.poll();
                    future.setResult(Status.UNKNOWN);
                }
            }
            finally {
                this.mLock.unlock();
            }
        }

        @Override
        public void process(TunerSelect tunerSelect, StreamCallbackParameters parameters, int reset) {
            if (parameters.isSampleRateChanged()) {
                this.completed(tunerSelect, UpdateReason.DEVICE_SAMPLE_RATE);
            }
            if (parameters.isRfFrequencyChanged()) {
                this.completed(tunerSelect, UpdateReason.TUNER_FREQUENCY_RF);
            }
            if (parameters.isGainReductionChanged()) {
                this.completed(tunerSelect, UpdateReason.TUNER_GAIN_REDUCTION);
            }
        }
    }
}

