/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.callback;

import io.github.dsheirer.source.tuner.sdrplay.api.callback.IDeviceEventListener;
import io.github.dsheirer.source.tuner.sdrplay.api.device.TunerSelect;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.event.EventParametersFactory;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.event.EventType;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_EventCallback_t;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_EventParamsT;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceEventAdapter
implements sdrplay_api_EventCallback_t {
    private static final Logger mLog = LoggerFactory.getLogger(DeviceEventAdapter.class);
    private IDeviceEventListener mDeviceEventListener;

    public DeviceEventAdapter(IDeviceEventListener listener) {
        this.setListener(listener);
    }

    public void setListener(IDeviceEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Device event listener must be non-null");
        }
        this.mDeviceEventListener = listener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void apply(int eventTypeId, int tunerSelectId, MemorySegment eventParametersPointer, MemorySegment callbackContext) {
        try (Arena arena = Arena.openConfined();){
            MemorySegment memorySegment = sdrplay_api_EventParamsT.ofAddress(eventParametersPointer, arena.scope());
            EventType eventType = EventType.fromValue(eventTypeId);
            TunerSelect tunerSelect = TunerSelect.fromValue(tunerSelectId);
            switch (eventType) {
                case GAIN_CHANGE: {
                    this.mDeviceEventListener.processGainChange(tunerSelect, EventParametersFactory.createGainCallbackParameters(memorySegment));
                    return;
                }
                case POWER_OVERLOAD_CHANGE: {
                    this.mDeviceEventListener.processPowerOverload(tunerSelect, EventParametersFactory.createPowerOverloadCallbackParameters(memorySegment));
                    return;
                }
                case DEVICE_REMOVED: {
                    this.mDeviceEventListener.processDeviceRemoval(tunerSelect);
                    return;
                }
                case RSP_DUO_MODE_CHANGE: {
                    this.mDeviceEventListener.processRspDuoModeChange(tunerSelect, EventParametersFactory.createRspDuoModeCallbackParameters(memorySegment));
                    return;
                }
                case UNKNOWN: {
                    mLog.warn("Unknown device event callback ignored.  Please contact the library developer as this may indicate a change to the SDRPlay API change. Tuner:" + String.valueOf((Object)tunerSelect) + " Event Type ID:" + eventTypeId);
                    this.mDeviceEventListener.processEvent(eventType, tunerSelect);
                    return;
                }
                default: {
                    throw new IllegalStateException("DeviceEventAdapter must be updated handle EventType." + String.valueOf((Object)eventType));
                }
            }
        }
    }
}

