/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.AgcMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.GainReduction;
import io.github.dsheirer.source.tuner.sdrplay.rsp1.Rsp1TunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.rsp1a.Rsp1aTunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.rsp2.Rsp2TunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.RspDuoTuner1Configuration;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.RspDuoTuner2Configuration;
import io.github.dsheirer.source.tuner.sdrplay.rspDx.RspDxTunerConfiguration;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Rsp1TunerConfiguration.class, name="rsp1TunerConfiguration"), @JsonSubTypes.Type(value=Rsp1aTunerConfiguration.class, name="rsp1aTunerConfiguration"), @JsonSubTypes.Type(value=Rsp2TunerConfiguration.class, name="rsp2TunerConfiguration"), @JsonSubTypes.Type(value=RspDuoTuner1Configuration.class, name="rspDuoTuner1Configuration"), @JsonSubTypes.Type(value=RspDuoTuner2Configuration.class, name="rspDuoTuner2Configuration"), @JsonSubTypes.Type(value=RspDxTunerConfiguration.class, name="rspDxTunerConfiguration")})
public abstract class RspTunerConfiguration
extends TunerConfiguration {
    public static final RspSampleRate DEFAULT_SINGLE_TUNER_SAMPLE_RATE = RspSampleRate.RATE_8_000;
    public static final RspSampleRate DEFAULT_DUAL_TUNER_SAMPLE_RATE = RspSampleRate.DUO_RATE_2_000;
    private RspSampleRate mRspSampleRate = DEFAULT_SINGLE_TUNER_SAMPLE_RATE;
    private int mGain = 24;
    private AgcMode mAgcMode = AgcMode.ENABLE;

    public RspTunerConfiguration() {
    }

    public RspTunerConfiguration(String uniqueId) {
        super(uniqueId);
    }

    @JacksonXmlProperty(isAttribute=true, localName="sampleRate")
    public RspSampleRate getSampleRate() {
        return this.mRspSampleRate;
    }

    public void setSampleRate(RspSampleRate rspSampleRate) {
        this.mRspSampleRate = rspSampleRate;
    }

    @JacksonXmlProperty(isAttribute=true, localName="gain")
    public int getGain() {
        return this.mGain;
    }

    public void setGain(int gain) {
        if (GainReduction.MIN_GAIN_INDEX <= gain && gain <= GainReduction.MAX_GAIN_INDEX) {
            this.mGain = gain;
        }
    }

    @JacksonXmlProperty(isAttribute=true, localName="agcMode")
    public AgcMode getAgcMode() {
        return this.mAgcMode;
    }

    public void setAgcMode(AgcMode mode) {
        this.mAgcMode = mode;
    }
}

