/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay;

import io.github.dsheirer.source.tuner.sdrplay.api.device.Decimate;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.Bandwidth;
import java.util.EnumSet;

public enum RspSampleRate {
    RATE_0_250(8000000L, 16000L, Bandwidth.BW_0_300, Decimate.X32, "0.250 MHz (0.234 usable)"),
    RATE_0_500(8000000L, 24000L, Bandwidth.BW_0_600, Decimate.X16, "0.500 MHz (0.476 usable)"),
    RATE_1_000(8000000L, 100000L, Bandwidth.BW_1_536, Decimate.X8, "1.000 MHz (0.900 usable)"),
    RATE_1_500(6000000L, 140000L, Bandwidth.BW_1_536, Decimate.X4, "1.500 MHz (1.360 usable)"),
    RATE_2_048(0x7D0000L, 248000L, Bandwidth.BW_1_536, Decimate.X4, "2.048 MHz (1.800 usable)"),
    RATE_3_000(6000000L, 300000L, Bandwidth.BW_5_000, Decimate.X2, "3.000 MHz (2.700 usable)"),
    RATE_4_000(8000000L, 340000L, Bandwidth.BW_5_000, Decimate.X2, "4.000 MHz (3.560 usable)"),
    RATE_5_000(5000000L, 880000L, Bandwidth.BW_5_000, Decimate.X1, "5.000 MHz (4.120 usable)"),
    RATE_6_000(6000000L, 800000L, Bandwidth.BW_6_000, Decimate.X1, "6.000 MHz (5.200 usable)"),
    RATE_7_000(7000000L, 1040000L, Bandwidth.BW_7_000, Decimate.X1, "7.000 MHz (5.960 usable)"),
    RATE_8_000(8000000L, 1060000L, Bandwidth.BW_8_000, Decimate.X1, "8.000 MHz (6.940 usable)"),
    RATE_9_000(9000000L, 1620000L, Bandwidth.BW_8_000, Decimate.X1, "9.000 MHz (7.380 usable)"),
    RATE_10_000(10000000L, 1500000L, Bandwidth.BW_8_000, Decimate.X1, "10.000 MHz (8.500 usable)"),
    DUO_RATE_0_500(8000000L, 50000L, Bandwidth.BW_8_000, Decimate.X4, "0.500 MHz (0.450 usable)"),
    DUO_RATE_1_000(8000000L, 50000L, Bandwidth.BW_8_000, Decimate.X2, "1.000 MHz (0.950 usable)"),
    DUO_RATE_1_500(6000000L, 0L, Bandwidth.BW_6_000, Decimate.X1, "1.500 MHz (1.500 usable)"),
    DUO_RATE_2_000(8000000L, 0L, Bandwidth.BW_8_000, Decimate.X1, "2.000 MHz (2.000 usable)"),
    UNDEFINED(0L, 0L, Bandwidth.UNDEFINED, Decimate.X1, "UNDEFINED");

    private final long mSampleRate;
    private final long mUnusable;
    private final Bandwidth mBandwidth;
    private final Decimate mDecimation;
    private final String mDescription;
    public static final EnumSet<RspSampleRate> SINGLE_TUNER_SAMPLE_RATES;
    public static final EnumSet<RspSampleRate> DUAL_TUNER_SAMPLE_RATES;

    private RspSampleRate(long sampleRate, long unusable, Bandwidth bandwidth, Decimate decimation, String description) {
        this.mSampleRate = sampleRate;
        this.mUnusable = unusable;
        this.mBandwidth = bandwidth;
        this.mDecimation = decimation;
        this.mDescription = description;
    }

    public long getSampleRate() {
        return this.mSampleRate;
    }

    public double getUsableBandwidth() {
        if (this.getSampleRate() != 0L) {
            return 1.0 - (double)this.mUnusable / (double)this.getEffectiveSampleRate();
        }
        return 0.0;
    }

    public boolean isDualTunerSampleRate() {
        return DUAL_TUNER_SAMPLE_RATES.contains((Object)this);
    }

    public int getSampleSize() {
        return this.mDecimation.getSampleSize();
    }

    public Decimate getDecimation() {
        return this.mDecimation;
    }

    public long getEffectiveSampleRate() {
        if (this.isDualTunerSampleRate()) {
            return this.getSampleRate() / (long)this.getDecimation().getValue() / 4L;
        }
        return this.getSampleRate() / (long)this.getDecimation().getValue();
    }

    public float getSamplesPerMillisecond() {
        return (float)this.getEffectiveSampleRate() / 1000.0f;
    }

    public Bandwidth getBandwidth() {
        return this.mBandwidth;
    }

    public String toString() {
        return this.mDescription;
    }

    static {
        SINGLE_TUNER_SAMPLE_RATES = EnumSet.range(RATE_0_250, RATE_10_000);
        DUAL_TUNER_SAMPLE_RATES = EnumSet.range(DUO_RATE_0_500, DUO_RATE_2_000);
    }
}

