/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay;

import io.github.dsheirer.source.tuner.sdrplay.RspNativeBuffer;
import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RspNativeBufferFactory {
    private RspSampleRate mRspSampleRate;
    private short[] mIResidual = new short[0];
    private short[] mQResidual = new short[0];
    private long mResidualTimestamp = System.currentTimeMillis();
    private int mIncomingBufferLength = 0;
    private int mOptimalBufferLength = 128;
    private float mSamplesPerMillisecond;

    public RspNativeBufferFactory(RspSampleRate sampleRate) {
        this.setSampleRate(sampleRate);
    }

    public void setSampleRate(RspSampleRate sampleRate) {
        this.mRspSampleRate = sampleRate;
        this.mSamplesPerMillisecond = sampleRate.getSamplesPerMillisecond();
    }

    public List<RspNativeBuffer> get(short[] i, short[] q, long timestamp) {
        this.updateBufferLength(i.length);
        short[] iCombined = new short[this.mIResidual.length + i.length];
        System.arraycopy(this.mIResidual, 0, iCombined, 0, this.mIResidual.length);
        System.arraycopy(i, 0, iCombined, this.mIResidual.length, i.length);
        short[] qCombined = new short[this.mQResidual.length + q.length];
        System.arraycopy(this.mQResidual, 0, qCombined, 0, this.mQResidual.length);
        System.arraycopy(q, 0, qCombined, this.mQResidual.length, q.length);
        if (iCombined.length < this.mOptimalBufferLength) {
            this.mIResidual = iCombined;
            this.mQResidual = qCombined;
            return Collections.emptyList();
        }
        ArrayList<RspNativeBuffer> buffers = new ArrayList<RspNativeBuffer>();
        while (iCombined.length >= this.mOptimalBufferLength) {
            short[] iOptimal = Arrays.copyOf(iCombined, this.mOptimalBufferLength);
            iCombined = Arrays.copyOfRange(iCombined, this.mOptimalBufferLength, iCombined.length);
            short[] qOptimal = Arrays.copyOf(qCombined, this.mOptimalBufferLength);
            qCombined = Arrays.copyOfRange(qCombined, this.mOptimalBufferLength, qCombined.length);
            RspNativeBuffer buffer = new RspNativeBuffer(iOptimal, qOptimal, this.mResidualTimestamp, this.mSamplesPerMillisecond);
            buffers.add(buffer);
            this.mResidualTimestamp += (long)((float)this.mOptimalBufferLength / this.mSamplesPerMillisecond);
        }
        this.mIResidual = iCombined;
        this.mQResidual = qCombined;
        this.mResidualTimestamp = timestamp;
        return buffers;
    }

    private void updateBufferLength(int length) {
        if (this.mIncomingBufferLength != length) {
            int optimal;
            for (optimal = 128; optimal < length; optimal *= 2) {
            }
            this.mOptimalBufferLength = optimal;
            this.mIncomingBufferLength = length;
        }
    }
}

