/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.rtl.r8x.r820t;

import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.rtl.RTL2832TunerController;
import io.github.dsheirer.source.tuner.rtl.r8x.R8xEmbeddedTuner;
import javax.usb.UsbException;

public class R820TEmbeddedTuner
extends R8xEmbeddedTuner {
    private static final byte I2C_WRITE_ADDRESS = 52;
    private static final byte I2C_READ_ADDRESS = 53;
    private static final int VCO_POWER_REF = 2;

    public R820TEmbeddedTuner(RTL2832TunerController.ControllerAdapter adapter) {
        super(adapter, 2);
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.RAFAELMICRO_R820T;
    }

    @Override
    public byte getI2CWriteAddress() {
        return 52;
    }

    @Override
    public byte getI2CReadAddress() {
        return 53;
    }

    @Override
    public synchronized void setTunedFrequency(long frequency) throws SourceException {
        this.getAdapter().getLock().lock();
        try {
            this.getAdapter().enableI2CRepeater();
            boolean controlI2C = false;
            long offsetFrequency = frequency + 3570000L;
            this.setMux(offsetFrequency, controlI2C);
            this.setPLL(offsetFrequency, controlI2C);
            this.getAdapter().disableI2CRepeater();
        }
        catch (UsbException e) {
            throw new SourceException("R820TTunerController - exception while setting frequency [" + frequency + "] - " + e.getLocalizedMessage());
        }
        finally {
            this.getAdapter().getLock().unlock();
        }
    }
}

