/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.rtl.r8x;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.rtl.RTL2832Tuner;
import io.github.dsheirer.source.tuner.rtl.RTL2832TunerController;
import io.github.dsheirer.source.tuner.rtl.r8x.R8xEmbeddedTuner;
import io.github.dsheirer.source.tuner.rtl.r8x.R8xTunerConfiguration;
import io.github.dsheirer.source.tuner.ui.TunerEditor;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.usb.UsbException;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.usb4java.LibUsbException;

public class R8xTunerEditor
extends TunerEditor<RTL2832Tuner, R8xTunerConfiguration> {
    private static final Logger mLog = LoggerFactory.getLogger(R8xTunerEditor.class);
    private static final long serialVersionUID = 1L;
    private static final R8xEmbeddedTuner.MasterGain DEFAULT_GAIN = R8xEmbeddedTuner.MasterGain.GAIN_279;
    private JButton mTunerInfoButton;
    private JToggleButton mBiasTButton;
    private JComboBox<RTL2832TunerController.SampleRate> mSampleRateCombo;
    private JComboBox<R8xEmbeddedTuner.MasterGain> mMasterGainCombo;
    private JComboBox<R8xEmbeddedTuner.MixerGain> mMixerGainCombo;
    private JComboBox<R8xEmbeddedTuner.LNAGain> mLNAGainCombo;
    private JComboBox<R8xEmbeddedTuner.VGAGain> mVGAGainCombo;

    public R8xTunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
        this.init();
        this.tunerStatusUpdated();
    }

    private R8xEmbeddedTuner getEmbeddedTuner() {
        if (this.hasTuner()) {
            return (R8xEmbeddedTuner)((RTL2832Tuner)this.getTuner()).getController().getEmbeddedTuner();
        }
        return null;
    }

    private String getLogPrefix() {
        return this.getEmbeddedTuner().getTunerType().getLabel() + " Tuner Controller - ";
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[right][grow,fill][fill]", "[][][][][][][][][][][][][][][][grow]"));
        this.add(new JLabel("Tuner:"));
        this.add(this.getTunerIdLabel());
        this.add(this.getTunerInfoButton());
        this.add(new JLabel("Status:"));
        this.add(this.getTunerStatusLabel());
        this.add((Component)this.getBiasTButton(), "wrap");
        this.add((Component)this.getButtonPanel(), "span,align left");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("Frequency (MHz):"));
        this.add((Component)this.getFrequencyPanel(), "wrap");
        this.add(new JLabel("Sample Rate:"));
        this.add((Component)this.getSampleRateCombo(), "wrap");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add((Component)new JLabel("Gain Control"), "wrap");
        this.add(new JLabel("Master:"));
        this.add((Component)this.getMasterGainCombo(), "wrap");
        this.add(new JLabel("Mixer:"));
        this.add((Component)this.getMixerGainCombo(), "wrap");
        this.add(new JLabel("LNA:"));
        this.add((Component)this.getLNAGainCombo(), "wrap");
        this.add(new JLabel("VGA:"));
        this.add((Component)this.getVGAGainCombo(), "wrap");
    }

    @Override
    protected void tunerStatusUpdated() {
        this.setLoading(true);
        if (this.hasTuner()) {
            this.getTunerIdLabel().setText(((RTL2832Tuner)this.getTuner()).getPreferredName());
        } else {
            this.getTunerIdLabel().setText(this.getDiscoveredTuner().getId());
        }
        Object status = this.getDiscoveredTuner().getTunerStatus().toString();
        if (this.getDiscoveredTuner().hasErrorMessage()) {
            status = (String)status + " - " + this.getDiscoveredTuner().getErrorMessage();
        }
        this.getTunerStatusLabel().setText((String)status);
        this.getButtonPanel().updateControls();
        this.getFrequencyPanel().updateControls();
        if (this.hasTuner()) {
            this.getBiasTButton().setEnabled(true);
            this.getBiasTButton().setSelected(((R8xTunerConfiguration)this.getConfiguration()).isBiasT());
            this.getTunerInfoButton().setEnabled(true);
            this.getSampleRateCombo().setEnabled(true);
            this.getSampleRateCombo().setSelectedItem((Object)((R8xTunerConfiguration)this.getConfiguration()).getSampleRate());
            this.getMasterGainCombo().setEnabled(true);
            R8xEmbeddedTuner.MasterGain gain = ((R8xTunerConfiguration)this.getConfiguration()).getMasterGain();
            this.getMasterGainCombo().setEnabled(true);
            this.getMasterGainCombo().setSelectedItem((Object)gain);
            if (gain == R8xEmbeddedTuner.MasterGain.MANUAL) {
                this.getMixerGainCombo().setSelectedItem((Object)((R8xTunerConfiguration)this.getConfiguration()).getMixerGain());
                this.getMixerGainCombo().setEnabled(true);
                this.getLNAGainCombo().setSelectedItem((Object)((R8xTunerConfiguration)this.getConfiguration()).getLNAGain());
                this.getLNAGainCombo().setEnabled(true);
                this.getVGAGainCombo().setSelectedItem((Object)((R8xTunerConfiguration)this.getConfiguration()).getVGAGain());
                this.getVGAGainCombo().setEnabled(true);
            } else {
                this.getMixerGainCombo().setEnabled(false);
                this.getMixerGainCombo().setSelectedItem((Object)gain.getMixerGain());
                this.getLNAGainCombo().setEnabled(false);
                this.getLNAGainCombo().setSelectedItem((Object)gain.getLNAGain());
                this.getVGAGainCombo().setEnabled(false);
                this.getVGAGainCombo().setSelectedItem((Object)gain.getVGAGain());
            }
        } else {
            this.getBiasTButton().setEnabled(false);
            this.getBiasTButton().setSelected(false);
            this.getTunerInfoButton().setEnabled(false);
            this.getSampleRateCombo().setEnabled(false);
            this.getMasterGainCombo().setEnabled(false);
            this.getMixerGainCombo().setEnabled(false);
            this.getLNAGainCombo().setEnabled(false);
            this.getVGAGainCombo().setEnabled(false);
        }
        this.updateSampleRateToolTip();
        this.setLoading(false);
    }

    private JToggleButton getBiasTButton() {
        if (this.mBiasTButton == null) {
            this.mBiasTButton = new JToggleButton("Bias-T");
            this.mBiasTButton.setEnabled(false);
            this.mBiasTButton.addActionListener(e -> {
                if (!this.isLoading()) {
                    ((RTL2832Tuner)this.getTuner()).getController().setBiasT(this.mBiasTButton.isSelected());
                    this.save();
                }
            });
        }
        return this.mBiasTButton;
    }

    private JButton getTunerInfoButton() {
        if (this.mTunerInfoButton == null) {
            this.mTunerInfoButton = new JButton("Info");
            this.mTunerInfoButton.setEnabled(false);
            this.mTunerInfoButton.addActionListener(e -> JOptionPane.showMessageDialog(this, this.getTunerInfo(), "Tuner Info", 1));
        }
        return this.mTunerInfoButton;
    }

    private JComboBox getVGAGainCombo() {
        if (this.mVGAGainCombo == null) {
            this.mVGAGainCombo = new JComboBox<R8xEmbeddedTuner.VGAGain>(R8xEmbeddedTuner.VGAGain.values());
            this.mVGAGainCombo.setEnabled(false);
            this.mVGAGainCombo.addActionListener(arg0 -> {
                try {
                    R8xEmbeddedTuner.VGAGain vgaGain = (R8xEmbeddedTuner.VGAGain)((Object)((Object)this.mVGAGainCombo.getSelectedItem()));
                    if (vgaGain == null) {
                        vgaGain = DEFAULT_GAIN.getVGAGain();
                    }
                    if (this.mVGAGainCombo.isEnabled()) {
                        this.getEmbeddedTuner().setVGAGain(vgaGain, true);
                    }
                    this.save();
                }
                catch (UsbException e) {
                    JOptionPane.showMessageDialog(this, this.getLogPrefix() + "couldn't apply the VGA gain setting - " + e.getLocalizedMessage());
                    mLog.error(this.getLogPrefix() + "couldn't apply VGA gain setting", (Throwable)e);
                }
            });
            this.mVGAGainCombo.setToolTipText("<html>VGA Gain.  Set master gain to <b>MANUAL</b> to enable adjustment</html>");
        }
        return this.mVGAGainCombo;
    }

    private JComboBox getLNAGainCombo() {
        if (this.mLNAGainCombo == null) {
            this.mLNAGainCombo = new JComboBox<R8xEmbeddedTuner.LNAGain>(R8xEmbeddedTuner.LNAGain.values());
            this.mLNAGainCombo.setEnabled(false);
            this.mLNAGainCombo.addActionListener(arg0 -> {
                try {
                    R8xEmbeddedTuner.LNAGain lnaGain = (R8xEmbeddedTuner.LNAGain)((Object)((Object)this.mLNAGainCombo.getSelectedItem()));
                    if (lnaGain == null) {
                        lnaGain = DEFAULT_GAIN.getLNAGain();
                    }
                    if (this.mLNAGainCombo.isEnabled()) {
                        this.getEmbeddedTuner().setLNAGain(lnaGain, true);
                    }
                    this.save();
                }
                catch (UsbException e) {
                    JOptionPane.showMessageDialog(this, this.getLogPrefix() + "couldn't apply the LNA gain setting - " + e.getLocalizedMessage());
                    mLog.error(this.getLogPrefix() + "couldn't apply LNA gain setting - ", (Throwable)e);
                }
            });
            this.mLNAGainCombo.setToolTipText("<html>LNA Gain.  Set master gain to <b>MANUAL</b> to enable adjustment</html>");
        }
        return this.mLNAGainCombo;
    }

    private JComboBox getSampleRateCombo() {
        if (this.mSampleRateCombo == null) {
            this.mSampleRateCombo = new JComboBox<RTL2832TunerController.SampleRate>(RTL2832TunerController.SampleRate.values());
            this.mSampleRateCombo.setEnabled(false);
            this.mSampleRateCombo.addActionListener(e -> {
                if (!this.isLoading()) {
                    RTL2832TunerController.SampleRate sampleRate = (RTL2832TunerController.SampleRate)((Object)((Object)this.mSampleRateCombo.getSelectedItem()));
                    try {
                        ((RTL2832Tuner)this.getTuner()).getController().setSampleRate(sampleRate);
                        this.save();
                    }
                    catch (SourceException | LibUsbException eSampleRate) {
                        JOptionPane.showMessageDialog(this, this.getLogPrefix() + "couldn't apply the sample rate setting [" + sampleRate.getLabel() + "] " + eSampleRate.getLocalizedMessage());
                        mLog.error(this.getLogPrefix() + "couldn't apply sample rate setting [" + sampleRate.getLabel() + "]", eSampleRate);
                    }
                }
            });
        }
        return this.mSampleRateCombo;
    }

    private JComboBox getMixerGainCombo() {
        if (this.mMixerGainCombo == null) {
            this.mMixerGainCombo = new JComboBox<R8xEmbeddedTuner.MixerGain>(R8xEmbeddedTuner.MixerGain.values());
            this.mMixerGainCombo.setEnabled(false);
            this.mMixerGainCombo.addActionListener(arg0 -> {
                if (!this.isLoading()) {
                    try {
                        R8xEmbeddedTuner.MixerGain mixerGain = (R8xEmbeddedTuner.MixerGain)((Object)((Object)this.mMixerGainCombo.getSelectedItem()));
                        if (mixerGain == null) {
                            mixerGain = DEFAULT_GAIN.getMixerGain();
                        }
                        if (this.mMixerGainCombo.isEnabled()) {
                            this.getEmbeddedTuner().setMixerGain(mixerGain, true);
                        }
                        this.save();
                    }
                    catch (UsbException e) {
                        JOptionPane.showMessageDialog(this, this.getLogPrefix() + "couldn't apply the mixer gain setting - " + e.getLocalizedMessage());
                        mLog.error(this.getLogPrefix() + "couldn't apply mixer gain setting - ", (Throwable)e);
                    }
                }
            });
            this.mMixerGainCombo.setToolTipText("<html>Mixer Gain.  Set master gain to <b>MANUAL</b> to enable adjustment</html>");
        }
        return this.mMixerGainCombo;
    }

    private JComboBox getMasterGainCombo() {
        if (this.mMasterGainCombo == null) {
            this.mMasterGainCombo = new JComboBox<R8xEmbeddedTuner.MasterGain>(R8xEmbeddedTuner.MasterGain.values());
            this.mMasterGainCombo.setEnabled(false);
            this.mMasterGainCombo.addActionListener(arg0 -> {
                if (!this.isLoading()) {
                    try {
                        R8xEmbeddedTuner.MasterGain gain = (R8xEmbeddedTuner.MasterGain)((Object)((Object)this.getMasterGainCombo().getSelectedItem()));
                        this.getEmbeddedTuner().setGain((R8xEmbeddedTuner.MasterGain)((Object)((Object)this.getMasterGainCombo().getSelectedItem())), true);
                        if (gain == R8xEmbeddedTuner.MasterGain.MANUAL) {
                            this.getMixerGainCombo().setSelectedItem((Object)gain.getMixerGain());
                            this.getMixerGainCombo().setEnabled(true);
                            this.getLNAGainCombo().setSelectedItem((Object)gain.getLNAGain());
                            this.getLNAGainCombo().setEnabled(true);
                            this.getVGAGainCombo().setSelectedItem((Object)gain.getVGAGain());
                            this.getVGAGainCombo().setEnabled(true);
                        } else {
                            this.getMixerGainCombo().setEnabled(false);
                            this.getMixerGainCombo().setSelectedItem((Object)gain.getMixerGain());
                            this.getLNAGainCombo().setEnabled(false);
                            this.getLNAGainCombo().setSelectedItem((Object)gain.getLNAGain());
                            this.getVGAGainCombo().setEnabled(false);
                            this.getVGAGainCombo().setSelectedItem((Object)gain.getVGAGain());
                        }
                        this.save();
                    }
                    catch (UsbException e) {
                        JOptionPane.showMessageDialog(this, this.getLogPrefix() + "couldn't apply the gain setting - " + e.getLocalizedMessage());
                        mLog.error(this.getLogPrefix() + "couldn't apply gain setting - ", (Throwable)e);
                    }
                }
            });
            this.mMasterGainCombo.setToolTipText("<html>Select <b>AUTOMATIC</b> for auto gain, <b>MANUAL</b> to enable<br> independent control of <i>Mixer</i>, <i>LNA</i> and <i>Enhance</i> gain<br>settings, or one of the individual gain settings for<br>semi-manual gain control</html>");
        }
        return this.mMasterGainCombo;
    }

    private void updateSampleRateToolTip() {
        if (this.hasTuner() && ((RTL2832Tuner)this.getTuner()).getTunerController().isLockedSampleRate()) {
            this.getSampleRateCombo().setToolTipText("Sample Rate is locked.  Disable decoding channels to unlock.");
        } else if (this.hasTuner()) {
            this.getSampleRateCombo().setToolTipText("Select a sample rate for the tuner");
        } else {
            this.getSampleRateCombo().setToolTipText("No tuner available");
        }
    }

    @Override
    public void setTunerLockState(boolean locked) {
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(!locked);
        this.updateSampleRateToolTip();
    }

    private String getTunerInfo() {
        StringBuilder sb = new StringBuilder();
        RTL2832TunerController.Descriptor descriptor = ((RTL2832Tuner)this.getTuner()).getController().getDescriptor();
        sb.append("<html><h3>RTL-2832 with " + this.getEmbeddedTuner().getTunerType().getLabel() + " Tuner</h3>");
        if (descriptor == null) {
            sb.append("No EEPROM Descriptor Available");
        } else {
            sb.append("<b>USB ID: </b>");
            sb.append(descriptor.getVendorID());
            sb.append(":");
            sb.append(descriptor.getProductID());
            sb.append("<br>");
            sb.append("<b>Vendor: </b>");
            sb.append(descriptor.getVendorLabel());
            sb.append("<br>");
            sb.append("<b>Product: </b>");
            sb.append(descriptor.getProductLabel());
            sb.append("<br>");
            sb.append("<b>Serial: </b>");
            sb.append(descriptor.getSerial());
            sb.append("<br>");
            sb.append("<b>IR Enabled: </b>");
            sb.append(descriptor.irEnabled());
            sb.append("<br>");
            sb.append("<b>Remote Wake: </b>");
            sb.append(descriptor.remoteWakeupEnabled());
            sb.append("<br>");
        }
        return sb.toString();
    }

    @Override
    public void save() {
        if (this.hasConfiguration() && !this.isLoading()) {
            R8xTunerConfiguration config = (R8xTunerConfiguration)this.getConfiguration();
            config.setBiasT(((RTL2832Tuner)this.getTuner()).getController().isBiasT());
            config.setFrequency(this.getFrequencyControl().getFrequency());
            double value = ((SpinnerNumberModel)this.getFrequencyCorrectionSpinner().getModel()).getNumber().doubleValue();
            config.setFrequencyCorrection(value);
            config.setAutoPPMCorrectionEnabled(this.getAutoPPMCheckBox().isSelected());
            config.setSampleRate((RTL2832TunerController.SampleRate)((Object)this.getSampleRateCombo().getSelectedItem()));
            R8xEmbeddedTuner.MasterGain gain = (R8xEmbeddedTuner.MasterGain)((Object)this.getMasterGainCombo().getSelectedItem());
            config.setMasterGain(gain);
            R8xEmbeddedTuner.MixerGain mixerGain = (R8xEmbeddedTuner.MixerGain)((Object)this.getMixerGainCombo().getSelectedItem());
            config.setMixerGain(mixerGain);
            R8xEmbeddedTuner.LNAGain lnaGain = (R8xEmbeddedTuner.LNAGain)((Object)this.getLNAGainCombo().getSelectedItem());
            config.setLNAGain(lnaGain);
            R8xEmbeddedTuner.VGAGain vgaGain = (R8xEmbeddedTuner.VGAGain)((Object)this.getVGAGainCombo().getSelectedItem());
            config.setVGAGain(vgaGain);
            this.saveConfiguration();
        }
    }
}

