/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.rtl.fc0013;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.rtl.RTL2832Tuner;
import io.github.dsheirer.source.tuner.rtl.RTL2832TunerController;
import io.github.dsheirer.source.tuner.rtl.fc0013.FC0013EmbeddedTuner;
import io.github.dsheirer.source.tuner.rtl.fc0013.FC0013TunerConfiguration;
import io.github.dsheirer.source.tuner.ui.TunerEditor;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.usb4java.LibUsbException;

public class FC0013TunerEditor
extends TunerEditor<RTL2832Tuner, FC0013TunerConfiguration> {
    private static final Logger mLog = LoggerFactory.getLogger(FC0013TunerEditor.class);
    private static final long serialVersionUID = 1L;
    private static final FC0013EmbeddedTuner.LNAGain DEFAULT_LNA_GAIN = FC0013EmbeddedTuner.LNAGain.G14;
    private JButton mTunerInfoButton;
    private JToggleButton mBiasTButton;
    private JComboBox<RTL2832TunerController.SampleRate> mSampleRateCombo;
    private JToggleButton mAgcToggleButton;
    private JComboBox<FC0013EmbeddedTuner.LNAGain> mLNAGainCombo;

    public FC0013TunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
        this.init();
        this.tunerStatusUpdated();
    }

    private FC0013EmbeddedTuner getEmbeddedTuner() {
        if (this.hasTuner()) {
            return (FC0013EmbeddedTuner)((RTL2832Tuner)this.getTuner()).getController().getEmbeddedTuner();
        }
        return null;
    }

    private String getLogPrefix() {
        return this.getEmbeddedTuner().getTunerType().getLabel() + " Tuner Controller - ";
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[right][grow,fill][fill]", "[][][][][][][][][][][][][][][][grow]"));
        this.add(new JLabel("Tuner:"));
        this.add(this.getTunerIdLabel());
        this.add(this.getTunerInfoButton());
        this.add(new JLabel("Status:"));
        this.add(this.getTunerStatusLabel());
        this.add((Component)this.getBiasTButton(), "wrap");
        this.add((Component)this.getButtonPanel(), "span,align left");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("Frequency (MHz):"));
        this.add((Component)this.getFrequencyPanel(), "wrap");
        this.add(new JLabel("Sample Rate:"));
        this.add((Component)this.getSampleRateCombo(), "wrap");
        this.add((Component)new JSeparator(), "span,growx,push");
        JPanel gainPanel = new JPanel();
        gainPanel.add(new JLabel("Gain"));
        gainPanel.add(this.getAgcToggleButton());
        gainPanel.add(new JLabel("LNA:"));
        this.add(gainPanel);
        this.add((Component)this.getLNAGainCombo(), "wrap");
    }

    @Override
    protected void tunerStatusUpdated() {
        this.setLoading(true);
        if (this.hasTuner()) {
            this.getTunerIdLabel().setText(((RTL2832Tuner)this.getTuner()).getPreferredName());
        } else {
            this.getTunerIdLabel().setText(this.getDiscoveredTuner().getId());
        }
        Object status = this.getDiscoveredTuner().getTunerStatus().toString();
        if (this.getDiscoveredTuner().hasErrorMessage()) {
            status = (String)status + " - " + this.getDiscoveredTuner().getErrorMessage();
        }
        this.getTunerStatusLabel().setText((String)status);
        this.getButtonPanel().updateControls();
        this.getFrequencyPanel().updateControls();
        if (this.hasTuner()) {
            this.getBiasTButton().setEnabled(true);
            this.getBiasTButton().setSelected(((FC0013TunerConfiguration)this.getConfiguration()).isBiasT());
            this.getTunerInfoButton().setEnabled(true);
            this.getSampleRateCombo().setEnabled(true);
            this.getSampleRateCombo().setSelectedItem((Object)((FC0013TunerConfiguration)this.getConfiguration()).getSampleRate());
            this.getAgcToggleButton().setEnabled(true);
            this.getAgcToggleButton().setSelected(((FC0013TunerConfiguration)this.getConfiguration()).getAGC());
            this.getLNAGainCombo().setEnabled(!((FC0013TunerConfiguration)this.getConfiguration()).getAGC());
            this.getLNAGainCombo().setSelectedItem((Object)((FC0013TunerConfiguration)this.getConfiguration()).getLnaGain());
        } else {
            this.getBiasTButton().setEnabled(false);
            this.getBiasTButton().setSelected(false);
            this.getTunerInfoButton().setEnabled(false);
            this.getSampleRateCombo().setEnabled(false);
            this.getAgcToggleButton().setEnabled(false);
            this.getLNAGainCombo().setEnabled(false);
        }
        this.updateSampleRateToolTip();
        this.setLoading(false);
    }

    private JToggleButton getBiasTButton() {
        if (this.mBiasTButton == null) {
            this.mBiasTButton = new JToggleButton("Bias-T");
            this.mBiasTButton.setEnabled(false);
            this.mBiasTButton.addActionListener(e -> {
                if (!this.isLoading()) {
                    ((RTL2832Tuner)this.getTuner()).getController().setBiasT(this.mBiasTButton.isSelected());
                    this.save();
                }
            });
        }
        return this.mBiasTButton;
    }

    private JButton getTunerInfoButton() {
        if (this.mTunerInfoButton == null) {
            this.mTunerInfoButton = new JButton("Info");
            this.mTunerInfoButton.setEnabled(false);
            this.mTunerInfoButton.addActionListener(e -> JOptionPane.showMessageDialog(this, this.getTunerInfo(), "Tuner Info", 1));
        }
        return this.mTunerInfoButton;
    }

    private JComboBox getLNAGainCombo() {
        if (this.mLNAGainCombo == null) {
            this.mLNAGainCombo = new JComboBox<FC0013EmbeddedTuner.LNAGain>(FC0013EmbeddedTuner.LNAGain.values());
            this.mLNAGainCombo.setEnabled(false);
            this.mLNAGainCombo.addActionListener(arg0 -> {
                if (!this.isLoading()) {
                    try {
                        FC0013EmbeddedTuner.LNAGain lnaGain = (FC0013EmbeddedTuner.LNAGain)((Object)((Object)this.mLNAGainCombo.getSelectedItem()));
                        if (lnaGain == null) {
                            lnaGain = DEFAULT_LNA_GAIN;
                        }
                        if (this.mLNAGainCombo.isEnabled()) {
                            this.getEmbeddedTuner().setGain(this.getAgcToggleButton().isSelected(), lnaGain);
                        }
                        this.save();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, this.getLogPrefix() + "couldn't apply the LNA gain setting - " + e.getLocalizedMessage());
                        mLog.error(this.getLogPrefix() + "couldn't apply LNA gain setting - ", (Throwable)e);
                    }
                }
            });
            this.mLNAGainCombo.setToolTipText("<html>LNA Gain.  Set master gain to <b>MANUAL</b> to enable adjustment</html>");
        }
        return this.mLNAGainCombo;
    }

    private JComboBox getSampleRateCombo() {
        if (this.mSampleRateCombo == null) {
            this.mSampleRateCombo = new JComboBox<RTL2832TunerController.SampleRate>(RTL2832TunerController.SampleRate.values());
            this.mSampleRateCombo.setEnabled(false);
            this.mSampleRateCombo.addActionListener(e -> {
                if (!this.isLoading()) {
                    RTL2832TunerController.SampleRate sampleRate = (RTL2832TunerController.SampleRate)((Object)((Object)this.mSampleRateCombo.getSelectedItem()));
                    try {
                        ((RTL2832Tuner)this.getTuner()).getController().setSampleRate(sampleRate);
                        this.save();
                    }
                    catch (SourceException | LibUsbException eSampleRate) {
                        JOptionPane.showMessageDialog(this, this.getLogPrefix() + "couldn't apply the sample rate setting [" + sampleRate.getLabel() + "] " + eSampleRate.getLocalizedMessage());
                        mLog.error(this.getLogPrefix() + "couldn't apply sample rate setting [" + sampleRate.getLabel() + "]", eSampleRate);
                    }
                }
            });
        }
        return this.mSampleRateCombo;
    }

    private JToggleButton getAgcToggleButton() {
        if (this.mAgcToggleButton == null) {
            this.mAgcToggleButton = new JToggleButton("AGC");
            this.mAgcToggleButton.setEnabled(false);
            this.mAgcToggleButton.addActionListener(arg0 -> {
                if (!this.isLoading()) {
                    try {
                        boolean agc = this.getAgcToggleButton().isSelected();
                        FC0013EmbeddedTuner.LNAGain lnaGain = (FC0013EmbeddedTuner.LNAGain)((Object)((Object)this.getLNAGainCombo().getSelectedItem()));
                        this.getEmbeddedTuner().setGain(agc, lnaGain);
                        this.getLNAGainCombo().setEnabled(!agc);
                        this.save();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, this.getLogPrefix() + "couldn't set AGC" + e.getLocalizedMessage());
                        mLog.error(this.getLogPrefix() + "couldn't set AGC", (Throwable)e);
                    }
                }
            });
            this.mAgcToggleButton.setToolTipText("<html>Automatic Gain Control (AGC). </html>");
        }
        return this.mAgcToggleButton;
    }

    private void updateSampleRateToolTip() {
        if (this.hasTuner() && ((RTL2832Tuner)this.getTuner()).getTunerController().isLockedSampleRate()) {
            this.getSampleRateCombo().setToolTipText("Sample Rate is locked.  Disable decoding channels to unlock.");
        } else if (this.hasTuner()) {
            this.getSampleRateCombo().setToolTipText("Select a sample rate for the tuner");
        } else {
            this.getSampleRateCombo().setToolTipText("No tuner available");
        }
    }

    @Override
    public void setTunerLockState(boolean locked) {
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(!locked);
        this.updateSampleRateToolTip();
    }

    private String getTunerInfo() {
        StringBuilder sb = new StringBuilder();
        RTL2832TunerController.Descriptor descriptor = ((RTL2832Tuner)this.getTuner()).getController().getDescriptor();
        sb.append("<html><h3>RTL-2832 with " + this.getEmbeddedTuner().getTunerType().getLabel() + " Tuner</h3>");
        if (descriptor == null) {
            sb.append("No EEPROM Descriptor Available");
        } else {
            sb.append("<b>USB ID: </b>");
            sb.append(descriptor.getVendorID());
            sb.append(":");
            sb.append(descriptor.getProductID());
            sb.append("<br>");
            sb.append("<b>Vendor: </b>");
            sb.append(descriptor.getVendorLabel());
            sb.append("<br>");
            sb.append("<b>Product: </b>");
            sb.append(descriptor.getProductLabel());
            sb.append("<br>");
            sb.append("<b>Serial: </b>");
            sb.append(descriptor.getSerial());
            sb.append("<br>");
            sb.append("<b>IR Enabled: </b>");
            sb.append(descriptor.irEnabled());
            sb.append("<br>");
            sb.append("<b>Remote Wake: </b>");
            sb.append(descriptor.remoteWakeupEnabled());
            sb.append("<br>");
        }
        return sb.toString();
    }

    @Override
    public void save() {
        if (this.hasConfiguration() && !this.isLoading()) {
            FC0013TunerConfiguration config = (FC0013TunerConfiguration)this.getConfiguration();
            config.setBiasT(((RTL2832Tuner)this.getTuner()).getController().isBiasT());
            config.setFrequency(this.getFrequencyControl().getFrequency());
            double value = ((SpinnerNumberModel)this.getFrequencyCorrectionSpinner().getModel()).getNumber().doubleValue();
            config.setFrequencyCorrection(value);
            config.setAutoPPMCorrectionEnabled(this.getAutoPPMCheckBox().isSelected());
            config.setSampleRate((RTL2832TunerController.SampleRate)((Object)this.getSampleRateCombo().getSelectedItem()));
            config.setAGC(this.getAgcToggleButton().isSelected());
            FC0013EmbeddedTuner.LNAGain lnaGain = (FC0013EmbeddedTuner.LNAGain)((Object)this.getLNAGainCombo().getSelectedItem());
            config.setLnaGain(lnaGain);
            this.saveConfiguration();
        }
    }
}

