/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.rtl.fc0013;

import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.rtl.EmbeddedTuner;
import io.github.dsheirer.source.tuner.rtl.RTL2832TunerController;
import io.github.dsheirer.source.tuner.rtl.fc0013.FC0013TunerConfiguration;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.usb4java.LibUsbException;

public class FC0013EmbeddedTuner
extends EmbeddedTuner {
    private static final Logger mLog = LoggerFactory.getLogger(FC0013EmbeddedTuner.class);
    private DecimalFormat FREQUENCY_FORMAT = new DecimalFormat("0.000000");
    private static final long MINIMUM_SUPPORTED_FREQUENCY = 13500000L;
    private static final long MAXIMUM_SUPPORTED_FREQUENCY = 1907999890L;
    private static final double USABLE_BANDWIDTH_PERCENT = 0.95;
    private static final int DC_SPIKE_AVOID_BUFFER = 15000;
    private static final byte I2C_ADDRESS = -58;
    private static final int XTAL_FREQUENCY = 28800000;
    private static final int XTAL_FREQUENCY_DIVIDED_BY_2 = 14400000;
    private static byte[] REGISTERS = new byte[]{0, 9, 22, 0, 0, 23, 2, 42, -1, 110, -72, -126, -2, 1, 0, 0, 0, 0, 0, 0, 80, 1};
    private long mTunedFrequency = 13500000L;

    public FC0013EmbeddedTuner(RTL2832TunerController.ControllerAdapter adapter) {
        super(adapter);
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.FITIPOWER_FC0013;
    }

    @Override
    public long getMinimumFrequencySupported() {
        return 13500000L;
    }

    @Override
    public long getMaximumFrequencySupported() {
        return 1907999890L;
    }

    @Override
    public int getDcSpikeHalfBandwidth() {
        return 15000;
    }

    @Override
    public double getUsableBandwidthPercent() {
        return 0.95;
    }

    @Override
    public void apply(TunerConfiguration tunerConfig) throws SourceException {
        if (tunerConfig instanceof FC0013TunerConfiguration) {
            FC0013TunerConfiguration config = (FC0013TunerConfiguration)tunerConfig;
            try {
                this.setGain(config.getAGC(), config.getLnaGain());
            }
            catch (Exception e) {
                throw new SourceException("Error while applying tuner config", e);
            }
        } else {
            throw new IllegalArgumentException("Unrecognized tuner config [" + String.valueOf(tunerConfig.getClass()) + "]");
        }
    }

    private void write(Register register, byte value, boolean controlI2CRepeater) {
        this.getAdapter().writeI2CRegister((byte)-58, register.byteValue(), value, controlI2CRepeater);
    }

    public void writeMaskedRegister(Register register, byte value, byte mask, boolean controlI2CRepeater) {
        byte content = (byte)(this.readRegister(register, controlI2CRepeater) & 0xFF);
        content = (byte)(content & mask);
        content = (byte)(content | value);
        this.write(register, content, controlI2CRepeater);
    }

    private void write(Field field, byte value, boolean controlI2CRepeater) {
        this.writeMaskedRegister(field.getRegister(), value, field.getMask(), controlI2CRepeater);
    }

    private int readRegister(Register register, boolean controlI2CRepeater) {
        return this.getAdapter().readI2CRegister((byte)-58, register.byteValue(), controlI2CRepeater);
    }

    @Override
    public void setSamplingMode(RTL2832TunerController.SampleMode mode) throws LibUsbException {
    }

    @Override
    public void setSampleRateFilters(int sampleRate) throws SourceException {
    }

    public long getTunedFrequency() throws SourceException {
        return this.mTunedFrequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setTunedFrequency(long frequency) throws SourceException {
        this.getAdapter().getLock().lock();
        try {
            boolean i2CEnabledState = this.getAdapter().isI2CRepeaterEnabled();
            if (!i2CEnabledState) {
                this.getAdapter().enableI2CRepeater();
            }
            this.setVhfTracking(frequency);
            this.setFilters(frequency);
            FrequencyDivider divider = FrequencyDivider.fromFrequency(frequency);
            boolean vcoSelect = (double)frequency / (double)divider.getIntegralFrequencyMultiplier() >= 212.5;
            int integral = (int)(frequency / (long)divider.getIntegralFrequencyMultiplier());
            int pm = integral / 8;
            pm = Math.max(pm, 11);
            pm = Math.min(pm, 31);
            int am = integral - pm * 8;
            if (am < 2) {
                am += 8;
                --pm;
            }
            am = Math.min(am, 15);
            integral = pm * 8 + am;
            int residual = (int)(frequency - (long)(integral * divider.getIntegralFrequencyMultiplier()));
            int fractional = (int)Math.round((double)residual / divider.getFractionalFrequencyMultiplier());
            if (pm < 11 || pm > 31 || am < 2 || am > 15 || fractional < 0 || fractional > 65535) {
                String message = "FC0013 - no valid PLL combination for frequency [" + frequency + "] using divider [" + String.valueOf((Object)divider) + "] pm [" + pm + "] am [" + am + "] fractional [" + fractional + "]";
                mLog.error(message);
                throw new SourceException(message);
            }
            this.setFrequencyValues(divider, pm, am, fractional, vcoSelect);
            if (!i2CEnabledState) {
                this.getAdapter().disableI2CRepeater();
            }
        }
        catch (LibUsbException e) {
            mLog.error("FC0013 tuner error while setting tuned frequency [" + frequency + "]", (Throwable)e);
        }
        finally {
            this.getAdapter().getLock().unlock();
        }
        this.mTunedFrequency = frequency;
    }

    @Override
    protected void initTuner() {
        this.getAdapter().enableI2CRepeater();
        boolean i2CRepeaterControl = false;
        for (int x = 1; x < REGISTERS.length; ++x) {
            this.write(Register.values()[x], REGISTERS[x], i2CRepeaterControl);
        }
        this.write(Field.R0D_AGC, (byte)8, false);
        this.write(Register.R13, (byte)10, false);
        this.getAdapter().disableI2CRepeater();
    }

    private boolean setFrequencyValues(FrequencyDivider divider, int pm, int am, int fractional, boolean vcoSelect) throws SourceException {
        if (pm < 11 || pm > 31) {
            throw new IllegalArgumentException("PM value [" + pm + "] must be in range 11-31");
        }
        if (am < 2 || am > 15) {
            throw new IllegalArgumentException("AM value [" + am + "] must be in range 2-15");
        }
        if (fractional < 0 || fractional > 65535) {
            throw new IllegalArgumentException("Fractional value [" + fractional + "] must be in range 0-65,535");
        }
        double exactFrequency = divider.calculate(pm, am, fractional);
        long frequency = (long)exactFrequency;
        byte register5 = divider.getRegister5();
        register5 = (byte)(register5 | 7);
        byte register6 = divider.getRegister6();
        if (vcoSelect) {
            register6 = (byte)(register6 | 8);
        }
        this.write(Register.R01, (byte)(am & 0xFF), false);
        this.write(Register.R02, (byte)(pm & 0xFF), false);
        this.write(Register.R03, (byte)(fractional >> 8 & 0xFF), false);
        this.write(Register.R04, (byte)(fractional & 0xFF), false);
        this.write(Register.R05, register5, false);
        this.write(Register.R06, register6, false);
        int tmp = this.readRegister(Register.R11, false);
        if (divider == FrequencyDivider.D64) {
            this.write(Register.R11, (byte)(tmp | 4), false);
        } else {
            this.write(Register.R11, (byte)(tmp & 0xFB), false);
        }
        this.write(Register.R0E, (byte)-128, false);
        this.write(Register.R0E, (byte)0, false);
        this.write(Register.R0E, (byte)0, false);
        int calibration = this.readRegister(Register.R0E, false) & 0x3F;
        boolean recalibrateRequired = false;
        if (vcoSelect && calibration > 60) {
            register6 = (byte)(register6 & 0xFFFFFFF7);
            recalibrateRequired = true;
        } else if (!vcoSelect && calibration < 2) {
            register6 = (byte)(register6 | 8);
            recalibrateRequired = true;
        }
        if (recalibrateRequired) {
            this.write(Register.R06, register6, false);
            this.write(Register.R0E, (byte)-128, false);
            this.write(Register.R0E, (byte)0, false);
            this.write(Register.R0E, (byte)0, false);
            calibration = this.readRegister(Register.R0E, false) & 0x3F;
            if (!vcoSelect & calibration < 2 || vcoSelect & calibration > 60) {
                String msg = "Unable to tune frequency [" + fractional + "] PLL calibration [" + Integer.toHexString(calibration).toUpperCase() + "] out of limits [02-3C]";
                mLog.error(msg);
                throw new SourceException(msg);
            }
        }
        return true;
    }

    private void setFilters(long frequency) {
        byte vhf = 0;
        byte uhf = 0;
        if (frequency < 300000000L) {
            vhf = 16;
        } else {
            uhf = frequency < 862000000L ? (byte)64 : 64;
        }
        this.write(Field.R07_VHF_FILTER, vhf, false);
        this.write(Field.R14_UHF_FILTER, uhf, false);
    }

    private void setVhfTracking(long frequency) {
        int tmp = this.readRegister(Register.R1D, false);
        tmp &= 0xE3;
        tmp = frequency <= 177500000L ? (tmp |= 0x1C) : (frequency <= 184500000L ? (tmp |= 0x18) : (frequency <= 191500000L ? (tmp |= 0x14) : (frequency <= 198500000L ? (tmp |= 0x10) : (frequency <= 205500000L ? (tmp |= 0xC) : (frequency <= 219500000L ? (tmp |= 8) : (frequency <= 300000000L ? (tmp |= 4) : (tmp |= 0x1C)))))));
        this.write(Register.R1D, (byte)tmp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGain(boolean agc, LNAGain manualGain) {
        this.getAdapter().getLock().lock();
        try {
            boolean repeaterState = this.getAdapter().isI2CRepeaterEnabled();
            if (!repeaterState) {
                this.getAdapter().enableI2CRepeater();
            }
            if (agc) {
                this.write(Field.R0D_AGC, (byte)0, false);
                this.write(Register.R13, (byte)10, false);
            } else {
                this.write(Field.R14_LNA_GAIN, manualGain.byteValue(), false);
                this.write(Field.R0D_AGC, (byte)8, false);
                this.write(Register.R13, (byte)10, false);
            }
            if (!repeaterState) {
                this.getAdapter().disableI2CRepeater();
            }
        }
        finally {
            this.getAdapter().getLock().unlock();
        }
    }

    public static enum LNAGain {
        G00("0 LOW", 2),
        G01("1", 3),
        G02("2", 5),
        G03("3", 4),
        G04("4", 0),
        G05("5", 7),
        G06("6", 1),
        G07("7", 6),
        G08("8", 15),
        G09("9", 14),
        G10("10", 13),
        G11("11", 12),
        G12("12", 11),
        G13("13", 10),
        G14("14", 9),
        G15("15", 8),
        G16("16", 23),
        G17("17", 22),
        G18("18", 21),
        G19("19", 20),
        G20("20", 19),
        G21("21", 18),
        G22("22", 17),
        G23("23 HIGH", 16);

        private String mLabel;
        private byte mValue;

        private LNAGain(String label, int value) {
            this.mLabel = label;
            this.mValue = (byte)value;
        }

        public byte byteValue() {
            return this.mValue;
        }

        public String toString() {
            return this.mLabel;
        }
    }

    private static enum Register {
        R00,
        R01,
        R02,
        R03,
        R04,
        R05,
        R06,
        R07,
        R08,
        R09,
        R0A,
        R0B,
        R0C,
        R0D,
        R0E,
        R0F,
        R10,
        R11,
        R12,
        R13,
        R14,
        R15,
        R16,
        R17,
        R18,
        R19,
        R1A,
        R1B,
        R1C,
        R1D;


        public byte byteValue() {
            return (byte)this.ordinal();
        }
    }

    private static enum Field {
        R06_BANDWIDTH(Register.R06, 192),
        R07_VHF_FILTER(Register.R07, 239),
        R0D_AGC(Register.R0D, 247),
        R14_LNA_GAIN(Register.R14, 224),
        R14_UHF_FILTER(Register.R14, 31);

        private Register mRegister;
        private byte mMask;

        private Field(Register register, int mask) {
            this.mRegister = register;
            this.mMask = (byte)mask;
        }

        public Register getRegister() {
            return this.mRegister;
        }

        public byte getMask() {
            return this.mMask;
        }
    }

    public static enum FrequencyDivider {
        D96(96, true, 130, 13500000L, 39749997L),
        D64(64, false, 2, 20250000L, 59624996L),
        D48(48, true, 66, 27000000L, 79499995L),
        D32(32, false, 130, 40500000L, 119249993L),
        D24(24, true, 34, 54000000L, 158999990L),
        D16(16, false, 66, 81000000L, 238499986L),
        D12(12, true, 18, 108000000L, 317999981L),
        D08(8, false, 34, 162000000L, 476999972L),
        D06(6, true, 10, 235200000L, 635999963L),
        D04(4, false, 18, 514900000L, 953999945L),
        D02(2, false, 10, 648000000L, 1907999890L);

        private int mDivider;
        private boolean mIs3xMode;
        private int mRegister5;
        private long mMinimumFrequency;
        private long mMaximumFrequency;

        private FrequencyDivider(int divider, boolean is3xMode, int register5, long minimumFrequency, long maximumFrequency) {
            this.mDivider = divider;
            this.mIs3xMode = is3xMode;
            this.mRegister5 = register5;
            this.mMinimumFrequency = minimumFrequency;
            this.mMaximumFrequency = maximumFrequency;
        }

        public byte getRegister5() {
            return (byte)(this.mRegister5 & 0xFF);
        }

        public byte getRegister6() {
            return this.is3xMode() ? (byte)-96 : -94;
        }

        public double getFrequency(int pm, int am, int fractional, boolean vcoSelect) {
            if (vcoSelect) {
                return this.calculate(pm, am, fractional);
            }
            return this.calculate(pm, am - 2, fractional);
        }

        public boolean isVcoSelect(double frequency) {
            return frequency * (double)this.getDivider() > 3.06E9;
        }

        private double calculate(int pm, int am, int fractional) {
            return (double)((8L * (long)pm + (long)am) * (long)this.getIntegralFrequencyMultiplier()) + this.getFractionalFrequencyMultiplier() * (double)fractional;
        }

        public int getIntegralFrequencyMultiplier() {
            return 14400000 / this.mDivider;
        }

        public double getFractionalFrequencyMultiplier() {
            return (double)(28800000 / this.mDivider) / 65536.0;
        }

        public boolean is3xMode() {
            return this.mIs3xMode;
        }

        public int getDivider() {
            return this.mDivider;
        }

        public long getMinimumFrequency() {
            return this.mMinimumFrequency;
        }

        public long getMaximumFrequency() {
            return this.mMaximumFrequency;
        }

        public boolean contains(long frequency) {
            return this.mMinimumFrequency <= frequency && frequency <= this.mMaximumFrequency;
        }

        public static FrequencyDivider fromFrequency(long frequency) {
            for (FrequencyDivider divider : FrequencyDivider.values()) {
                if (!divider.contains(frequency)) continue;
                return divider;
            }
            return D16;
        }
    }
}

