/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.rtl.e4k;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.rtl.RTL2832Tuner;
import io.github.dsheirer.source.tuner.rtl.RTL2832TunerController;
import io.github.dsheirer.source.tuner.rtl.e4k.E4KEmbeddedTuner;
import io.github.dsheirer.source.tuner.rtl.e4k.E4KTunerConfiguration;
import io.github.dsheirer.source.tuner.ui.TunerEditor;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.usb.UsbException;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.usb4java.LibUsbException;

public class E4KTunerEditor
extends TunerEditor<RTL2832Tuner, E4KTunerConfiguration> {
    private static final Logger mLog = LoggerFactory.getLogger(E4KTunerEditor.class);
    private static final long serialVersionUID = 1L;
    private JButton mTunerInfoButton;
    private JToggleButton mBiasTButton;
    private JComboBox<RTL2832TunerController.SampleRate> mSampleRateCombo;
    private JComboBox<E4KEmbeddedTuner.E4KGain> mMasterGainCombo;
    private JComboBox<E4KEmbeddedTuner.E4KMixerGain> mMixerGainCombo;
    private JComboBox<E4KEmbeddedTuner.E4KLNAGain> mLNAGainCombo;
    private JComboBox<E4KEmbeddedTuner.IFGain> mIfGainCombo;

    public E4KTunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
        this.init();
        this.tunerStatusUpdated();
    }

    public E4KEmbeddedTuner getEmbeddedTuner() {
        if (this.hasTuner()) {
            return (E4KEmbeddedTuner)((RTL2832Tuner)this.getTuner()).getController().getEmbeddedTuner();
        }
        return null;
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[right][grow,fill][fill]", "[][][][][][][][][][][][][][][][grow]"));
        this.add(new JLabel("Tuner:"));
        this.add(this.getTunerIdLabel());
        this.add(this.getTunerInfoButton());
        this.add(new JLabel("Status:"));
        this.add(this.getTunerStatusLabel());
        this.add((Component)this.getBiasTButton(), "wrap");
        this.add((Component)this.getButtonPanel(), "span,align left");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("Frequency (MHz):"));
        this.add((Component)this.getFrequencyPanel(), "span 2");
        this.add(new JLabel("Sample Rate:"));
        this.add((Component)this.getSampleRateCombo(), "wrap");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add((Component)new JLabel("Mixer/LNA Gain Control"), "wrap");
        this.add(new JLabel("Master:"));
        this.add((Component)this.getMasterGainCombo(), "wrap");
        this.add(new JLabel("Mixer:"));
        this.add((Component)this.getMixerGainCombo(), "wrap");
        this.add(new JLabel("LNA:"));
        this.add((Component)this.getLNAGainCombo(), "wrap");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("IF Gain:"));
        this.add((Component)this.getIfGainCombo(), "wrap");
    }

    @Override
    protected void tunerStatusUpdated() {
        this.setLoading(true);
        if (this.hasTuner()) {
            this.getTunerIdLabel().setText(((RTL2832Tuner)this.getTuner()).getPreferredName());
        } else {
            this.getTunerIdLabel().setText(this.getDiscoveredTuner().getId());
        }
        this.getTunerStatusLabel().setText(this.getDiscoveredTuner().getTunerStatus().toString());
        this.getButtonPanel().updateControls();
        this.getFrequencyPanel().updateControls();
        if (this.hasTuner()) {
            this.getBiasTButton().setEnabled(true);
            this.getBiasTButton().setSelected(((E4KTunerConfiguration)this.getConfiguration()).isBiasT());
            this.getTunerInfoButton().setEnabled(true);
            this.getSampleRateCombo().setEnabled(true);
            this.getSampleRateCombo().setSelectedItem((Object)((E4KTunerConfiguration)this.getConfiguration()).getSampleRate());
            this.getMasterGainCombo().setEnabled(true);
            this.getIfGainCombo().setEnabled(true);
            this.getIfGainCombo().setSelectedItem((Object)((E4KTunerConfiguration)this.getConfiguration()).getIFGain());
            E4KEmbeddedTuner.E4KGain gain = ((E4KTunerConfiguration)this.getConfiguration()).getMasterGain();
            this.getMasterGainCombo().setEnabled(true);
            this.getMasterGainCombo().setSelectedItem((Object)gain);
            if (gain == E4KEmbeddedTuner.E4KGain.MANUAL) {
                this.getMixerGainCombo().setSelectedItem((Object)((E4KTunerConfiguration)this.getConfiguration()).getMixerGain());
                this.getMixerGainCombo().setEnabled(true);
                this.getLNAGainCombo().setSelectedItem((Object)((E4KTunerConfiguration)this.getConfiguration()).getLNAGain());
                this.getLNAGainCombo().setEnabled(true);
            } else {
                this.getMixerGainCombo().setEnabled(false);
                this.getMixerGainCombo().setSelectedItem((Object)gain.getMixerGain());
                this.getLNAGainCombo().setEnabled(false);
                this.getLNAGainCombo().setSelectedItem((Object)gain.getLNAGain());
            }
        } else {
            this.getBiasTButton().setEnabled(false);
            this.getBiasTButton().setSelected(false);
            this.getTunerInfoButton().setEnabled(false);
            this.getSampleRateCombo().setEnabled(false);
            this.getMasterGainCombo().setEnabled(false);
            this.getMixerGainCombo().setEnabled(false);
            this.getLNAGainCombo().setEnabled(false);
            this.getIfGainCombo().setEnabled(false);
        }
        this.updateSampleRateToolTip();
        this.setLoading(false);
    }

    private JToggleButton getBiasTButton() {
        if (this.mBiasTButton == null) {
            this.mBiasTButton = new JToggleButton("Bias-T");
            this.mBiasTButton.setEnabled(false);
            this.mBiasTButton.addActionListener(e -> {
                if (!this.isLoading()) {
                    ((RTL2832Tuner)this.getTuner()).getController().setBiasT(this.mBiasTButton.isSelected());
                    this.save();
                }
            });
        }
        return this.mBiasTButton;
    }

    private JComboBox getIfGainCombo() {
        if (this.mIfGainCombo == null) {
            this.mIfGainCombo = new JComboBox<E4KEmbeddedTuner.IFGain>(E4KEmbeddedTuner.IFGain.values());
            this.mIfGainCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!E4KTunerEditor.this.isLoading()) {
                        try {
                            E4KEmbeddedTuner.IFGain selected = (E4KEmbeddedTuner.IFGain)((Object)E4KTunerEditor.this.getIfGainCombo().getSelectedItem());
                            E4KTunerEditor.this.getEmbeddedTuner().setIFGain(selected, true);
                            E4KTunerEditor.this.save();
                        }
                        catch (LibUsbException lue) {
                            JOptionPane.showMessageDialog(E4KTunerEditor.this, "E4000 Tuner Controller - couldn't apply the IF setting - " + lue.getLocalizedMessage());
                            mLog.error("E4000 Tuner Controller - couldn't apply IF gain setting", (Object)e);
                        }
                    }
                }
            });
            this.mIfGainCombo.setToolTipText("Linear IF Gain");
            this.mIfGainCombo.setEnabled(true);
        }
        return this.mIfGainCombo;
    }

    private JComboBox getLNAGainCombo() {
        if (this.mLNAGainCombo == null) {
            this.mLNAGainCombo = new JComboBox<E4KEmbeddedTuner.E4KLNAGain>(E4KEmbeddedTuner.E4KLNAGain.values());
            this.mLNAGainCombo.addActionListener(arg0 -> {
                if (!this.isLoading()) {
                    try {
                        E4KEmbeddedTuner.E4KLNAGain lnaGain = (E4KEmbeddedTuner.E4KLNAGain)((Object)((Object)this.mLNAGainCombo.getSelectedItem()));
                        this.getEmbeddedTuner().setLNAGain(lnaGain, true);
                        this.save();
                    }
                    catch (UsbException e) {
                        JOptionPane.showMessageDialog(this, "E4000 Tuner Controller - couldn't apply the LNA gain setting - " + e.getLocalizedMessage());
                        mLog.error("E4000 Tuner Controller - couldn't apply LNA gain setting - ", (Throwable)e);
                    }
                }
            });
            this.mLNAGainCombo.setToolTipText("<html>LNA Gain.  Set master gain to <b>MANUAL</b> to enable adjustment</html>");
            this.mLNAGainCombo.setEnabled(false);
        }
        return this.mLNAGainCombo;
    }

    private JComboBox getMixerGainCombo() {
        if (this.mMixerGainCombo == null) {
            this.mMixerGainCombo = new JComboBox<E4KEmbeddedTuner.E4KMixerGain>(E4KEmbeddedTuner.E4KMixerGain.values());
            this.mMixerGainCombo.addActionListener(arg0 -> {
                if (!this.isLoading()) {
                    try {
                        E4KEmbeddedTuner.E4KMixerGain mixerGain = (E4KEmbeddedTuner.E4KMixerGain)((Object)((Object)this.mMixerGainCombo.getSelectedItem()));
                        this.getEmbeddedTuner().setMixerGain(mixerGain, true);
                        this.save();
                    }
                    catch (UsbException e) {
                        JOptionPane.showMessageDialog(this, "E4000 Tuner Controller - couldn't apply the mixer gain setting - " + e.getLocalizedMessage());
                        mLog.error("E4000 Tuner Controller - couldn't apply mixer gain setting", (Throwable)e);
                    }
                }
            });
            this.mMixerGainCombo.setToolTipText("<html>Mixer Gain.  Set master gain to <b>MASTER</b> to enable adjustment</html>");
            this.mMixerGainCombo.setEnabled(false);
        }
        return this.mMixerGainCombo;
    }

    private JComboBox getMasterGainCombo() {
        if (this.mMasterGainCombo == null) {
            this.mMasterGainCombo = new JComboBox<E4KEmbeddedTuner.E4KGain>(E4KEmbeddedTuner.E4KGain.values());
            this.mMasterGainCombo.setEnabled(false);
            this.mMasterGainCombo.addActionListener(arg0 -> {
                if (!this.isLoading()) {
                    try {
                        E4KEmbeddedTuner.E4KGain gain = (E4KEmbeddedTuner.E4KGain)((Object)((Object)this.mMasterGainCombo.getSelectedItem()));
                        this.getEmbeddedTuner().setGain((E4KEmbeddedTuner.E4KGain)((Object)((Object)this.mMasterGainCombo.getSelectedItem())), true);
                        if (gain == E4KEmbeddedTuner.E4KGain.MANUAL) {
                            this.getMixerGainCombo().setSelectedItem((Object)this.getEmbeddedTuner().getMixerGain(true));
                            this.getMixerGainCombo().setEnabled(true);
                            this.getLNAGainCombo().setSelectedItem((Object)this.getEmbeddedTuner().getLNAGain(true));
                            this.getLNAGainCombo().setEnabled(true);
                        } else {
                            this.getMixerGainCombo().setEnabled(false);
                            this.getMixerGainCombo().setSelectedItem((Object)gain.getMixerGain());
                            this.getLNAGainCombo().setEnabled(false);
                            this.getLNAGainCombo().setSelectedItem((Object)gain.getLNAGain());
                        }
                        this.save();
                    }
                    catch (UsbException e) {
                        JOptionPane.showMessageDialog(this, "E4000 Tuner Controller - couldn't apply the gain setting - " + e.getLocalizedMessage());
                        mLog.error("E4000 Tuner Controller - couldn't apply gain setting", (Throwable)e);
                    }
                }
            });
            this.mMasterGainCombo.setToolTipText("<html>Select <b>AUTOMATIC</b> for auto gain, <b>MANUAL</b> to enable<br> independent control of <i>Mixer</i>, <i>LNA</i> and <i>Enhance</i> gain<br>settings, or one of the individual gain settings for<br>semi-manual gain control</html>");
        }
        return this.mMasterGainCombo;
    }

    private JComboBox getSampleRateCombo() {
        if (this.mSampleRateCombo == null) {
            this.mSampleRateCombo = new JComboBox<RTL2832TunerController.SampleRate>(RTL2832TunerController.SampleRate.values());
            this.mSampleRateCombo.setEnabled(false);
            this.mSampleRateCombo.addActionListener(e -> {
                if (!this.isLoading()) {
                    RTL2832TunerController.SampleRate sampleRate = (RTL2832TunerController.SampleRate)((Object)((Object)this.mSampleRateCombo.getSelectedItem()));
                    try {
                        ((RTL2832Tuner)this.getTuner()).getController().setSampleRate(sampleRate);
                        this.save();
                    }
                    catch (SourceException | LibUsbException eSampleRate) {
                        JOptionPane.showMessageDialog(this, "E4000 Tuner Controller - couldn't apply the sample rate setting [" + sampleRate.getLabel() + "] " + eSampleRate.getLocalizedMessage());
                        mLog.error("E4000 Tuner Controller - couldn't apply sample rate setting [" + sampleRate.getLabel() + "]", eSampleRate);
                    }
                }
            });
        }
        return this.mSampleRateCombo;
    }

    private JButton getTunerInfoButton() {
        if (this.mTunerInfoButton == null) {
            this.mTunerInfoButton = new JButton("Tuner Info");
            this.mTunerInfoButton.setEnabled(false);
            this.mTunerInfoButton.addActionListener(e -> JOptionPane.showMessageDialog(this, this.getTunerInfo(), "Tuner Info", 1));
        }
        return this.mTunerInfoButton;
    }

    private void updateSampleRateToolTip() {
        if (this.hasTuner() && ((RTL2832Tuner)this.getTuner()).getTunerController().isLockedSampleRate()) {
            this.getSampleRateCombo().setToolTipText("Sample Rate is locked.  Disable decoding channels to unlock.");
        } else if (this.hasTuner()) {
            this.getSampleRateCombo().setToolTipText("Select a sample rate for the tuner");
        } else {
            this.getSampleRateCombo().setToolTipText("No tuner available");
        }
    }

    @Override
    public void setTunerLockState(boolean locked) {
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(!locked);
        this.updateSampleRateToolTip();
    }

    private String getTunerInfo() {
        StringBuilder sb = new StringBuilder();
        RTL2832TunerController.Descriptor descriptor = ((RTL2832Tuner)this.getTuner()).getController().getDescriptor();
        sb.append("<html><h3>RTL-2832 with E4000 Tuner</h3>");
        if (descriptor == null) {
            sb.append("No EEPROM Descriptor Available");
        } else {
            sb.append("<b>USB ID: </b>");
            sb.append(descriptor.getVendorID());
            sb.append(":");
            sb.append(descriptor.getProductID());
            sb.append("<br>");
            sb.append("<b>Vendor: </b>");
            sb.append(descriptor.getVendorLabel());
            sb.append("<br>");
            sb.append("<b>Product: </b>");
            sb.append(descriptor.getProductLabel());
            sb.append("<br>");
            sb.append("<b>Serial: </b>");
            sb.append(descriptor.getSerial());
            sb.append("<br>");
            sb.append("<b>IR Enabled: </b>");
            sb.append(descriptor.irEnabled());
            sb.append("<br>");
            sb.append("<b>Remote Wake: </b>");
            sb.append(descriptor.remoteWakeupEnabled());
            sb.append("<br>");
        }
        return sb.toString();
    }

    @Override
    public void save() {
        if (this.hasConfiguration() && !this.isLoading()) {
            E4KTunerConfiguration config = (E4KTunerConfiguration)this.getConfiguration();
            config.setFrequency(this.getFrequencyControl().getFrequency());
            double value = ((SpinnerNumberModel)this.getFrequencyCorrectionSpinner().getModel()).getNumber().doubleValue();
            config.setFrequencyCorrection(value);
            config.setAutoPPMCorrectionEnabled(this.getAutoPPMCheckBox().isSelected());
            config.setBiasT(((RTL2832Tuner)this.getTuner()).getController().isBiasT());
            config.setSampleRate((RTL2832TunerController.SampleRate)((Object)this.getSampleRateCombo().getSelectedItem()));
            config.setMasterGain((E4KEmbeddedTuner.E4KGain)((Object)this.getMasterGainCombo().getSelectedItem()));
            config.setMixerGain((E4KEmbeddedTuner.E4KMixerGain)((Object)this.getMixerGainCombo().getSelectedItem()));
            config.setLNAGain((E4KEmbeddedTuner.E4KLNAGain)((Object)this.getLNAGainCombo().getSelectedItem()));
            config.setIFGain((E4KEmbeddedTuner.IFGain)((Object)this.getIfGainCombo().getSelectedItem()));
            this.saveConfiguration();
        }
    }
}

