/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.rtl.e4k;

import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.rtl.EmbeddedTuner;
import io.github.dsheirer.source.tuner.rtl.RTL2832TunerController;
import io.github.dsheirer.source.tuner.rtl.e4k.E4KTunerConfiguration;
import java.util.EnumSet;
import javax.usb.UsbException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.usb4java.LibUsbException;

public class E4KEmbeddedTuner
extends EmbeddedTuner {
    private static final Logger mLog = LoggerFactory.getLogger(E4KEmbeddedTuner.class);
    public static final long MINIMUM_SUPPORTED_FREQUENCY = 52000000L;
    public static final long MAXIMUM_SUPPORTED_FREQUENCY = 2200000000L;
    public static final double USABLE_BANDWIDTH_PERCENT = 0.95;
    public static final int DC_SPIKE_AVOID_BUFFER = 15000;
    public static final long E4K_PLL_Y = 65536L;
    public static final byte MASTER1_RESET = 1;
    public static final byte MASTER1_NORM_STBY = 2;
    public static final byte MASTER1_POR_DET = 4;
    public static final byte SYNTH1_PLL_LOCK = 1;
    public static final byte SYNTH1_BAND_SHIF = 1;
    public static final byte SYNTH7_3PHASE_EN = 8;
    public static final byte SYNTH8_VCOCAL_UPD = 4;
    public static final byte FILT3_MASK = 32;
    public static final byte FILT3_ENABLE = 0;
    public static final byte FILT3_DISABLE = 32;
    public static final byte MIXER_FILTER_MASK = -16;
    public static final byte IF_CHANNEL_FILTER_MASK = 31;
    public static final byte IF_RC_FILTER_MASK = 15;
    public static final byte AGC1_LIN_MODE = 16;
    public static final byte AGC1_LNA_UPDATE = 32;
    public static final byte AGC1_LNA_G_LOW = 64;
    public static final byte AGC1_LNA_G_HIGH = -128;
    public static final byte AGC1_MOD_MASK = 15;
    public static final byte GAIN1_MOD_MASK = 15;
    public static final byte IF_GAIN_MODE_SWITCHING_MASK = 1;
    public static final byte AGC6_LNA_CAL_REQ = 16;
    public static final byte AGC7_MIXER_GAIN_MASK = 1;
    public static final byte AGC7_MIX_GAIN_MANUAL = 0;
    public static final byte AGC7_MIX_GAIN_AUTO = 1;
    public static final byte ENH_GAIN_MOD_MASK = 7;
    public static final byte MIXER_GAIN_MASK = 1;
    public static final byte DC5_RANGE_DETECTOR_ENABLED_MASK = 4;
    public static final byte DC5_RANGE_DETECTOR_ENABLED = 4;

    public E4KEmbeddedTuner(RTL2832TunerController.ControllerAdapter adapter) {
        super(adapter);
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.ELONICS_E4000;
    }

    @Override
    public long getMinimumFrequencySupported() {
        return 52000000L;
    }

    @Override
    public long getMaximumFrequencySupported() {
        return 2200000000L;
    }

    @Override
    public int getDcSpikeHalfBandwidth() {
        return 15000;
    }

    @Override
    public double getUsableBandwidthPercent() {
        return 0.95;
    }

    @Override
    public void setSamplingMode(RTL2832TunerController.SampleMode mode) throws LibUsbException {
        switch (mode) {
            case QUADRATURE: {
                this.getAdapter().setIFFrequency(0);
                this.getAdapter().writeDemodRegister(RTL2832TunerController.Page.ZERO, (short)8, 205, 1);
                this.getAdapter().writeDemodRegister(RTL2832TunerController.Page.ONE, (short)177, 27, 1);
                this.getAdapter().writeDemodRegister(RTL2832TunerController.Page.ZERO, (short)6, 128, 1);
                break;
            }
            default: {
                throw new LibUsbException("QUADRATURE mode is the only mode currently supported", -12);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void apply(TunerConfiguration config) throws SourceException {
        if (!(config instanceof E4KTunerConfiguration)) throw new IllegalArgumentException("Unrecognized tuner config [" + String.valueOf(config.getClass()) + "]");
        E4KTunerConfiguration e4kConfig = (E4KTunerConfiguration)config;
        try {
            E4KGain masterGain = e4kConfig.getMasterGain();
            this.setGain(masterGain, true);
            if (masterGain != E4KGain.MANUAL) return;
            E4KMixerGain mixerGain = e4kConfig.getMixerGain();
            this.setMixerGain(mixerGain, true);
            E4KLNAGain lnaGain = e4kConfig.getLNAGain();
            this.setLNAGain(lnaGain, true);
            IFGain ifGain = e4kConfig.getIFGain();
            this.setIFGain(ifGain, true);
            return;
        }
        catch (UsbException e) {
            throw new SourceException("Usb error while applying tuner config", e);
        }
    }

    @Override
    public void setSampleRateFilters(int bandwidth) throws SourceException {
        boolean i2CRepeaterEnabled = this.getAdapter().isI2CRepeaterEnabled();
        if (!i2CRepeaterEnabled) {
            this.getAdapter().enableI2CRepeater();
        }
        boolean controlI2CRepeater = false;
        MixerFilter mixer = MixerFilter.getFilter(bandwidth);
        this.setMixerFilter(mixer, controlI2CRepeater);
        ChannelFilter channel = ChannelFilter.getFilter(bandwidth);
        this.setChannelFilter(channel, controlI2CRepeater);
        RCFilter rc = RCFilter.getFilter(bandwidth);
        this.setRCFilter(rc, controlI2CRepeater);
        if (!i2CRepeaterEnabled) {
            this.getAdapter().disableI2CRepeater();
        }
    }

    public long getTunedFrequency() throws SourceException {
        try {
            boolean i2CRepeaterEnabled = this.getAdapter().isI2CRepeaterEnabled();
            if (!i2CRepeaterEnabled) {
                this.getAdapter().enableI2CRepeater();
            }
            boolean controlI2CRepeater = false;
            byte z = (byte)this.readE4KRegister(Register.SYNTH3, controlI2CRepeater);
            int xHigh = this.readE4KRegister(Register.SYNTH4, controlI2CRepeater);
            int xLow = this.readE4KRegister(Register.SYNTH5, controlI2CRepeater);
            int x = Integer.rotateLeft(xHigh, 8) | xLow;
            int pllSetting = this.readE4KRegister(Register.SYNTH7, controlI2CRepeater);
            PLL pll = PLL.fromSetting(pllSetting);
            if (!i2CRepeaterEnabled) {
                this.getAdapter().disableI2CRepeater();
            }
            return this.calculateActualFrequency(pll, z, x);
        }
        catch (LibUsbException e) {
            throw new SourceException("E4K tuner controller - couldn't get tuned frequency", e);
        }
    }

    @Override
    public synchronized void setTunedFrequency(long frequency) throws SourceException {
        int remainder;
        int x;
        byte z;
        PLL pll = PLL.fromFrequency(frequency);
        long actualFrequency = this.calculateActualFrequency(pll, z = (byte)(frequency / (long)pll.getScaledOscillator()), x = (int)((double)(remainder = (int)(frequency - (long)((z & 0xFF) * pll.getScaledOscillator()))) / (double)pll.getScaledOscillator() * 65536.0));
        if (actualFrequency < this.getMinimumFrequencySupported()) {
            actualFrequency = this.calculateActualFrequency(pll, z, ++x);
        }
        this.getAdapter().getLock().lock();
        try {
            this.getAdapter().enableI2CRepeater();
            boolean controlI2CRepeater = false;
            this.writeE4KRegister(Register.SYNTH7, pll.getIndex(), controlI2CRepeater);
            this.writeE4KRegister(Register.SYNTH3, z, controlI2CRepeater);
            this.writeE4KRegister(Register.SYNTH4, (byte)(x & 0xFF), controlI2CRepeater);
            this.writeE4KRegister(Register.SYNTH5, (byte)(Integer.rotateRight(x, 8) & 0xFF), controlI2CRepeater);
            this.setBand(actualFrequency, controlI2CRepeater);
            this.setRFFilter(actualFrequency, controlI2CRepeater);
            int lock = this.readE4KRegister(Register.SYNTH1, controlI2CRepeater);
            if ((lock & 1) != 1) {
                throw new SourceException("E4K tuner - couldn't achieve PLL lock for frequency [" + actualFrequency + "] lock value [" + lock + "]");
            }
            this.getAdapter().disableI2CRepeater();
        }
        catch (UsbException e) {
            throw new SourceException("E4K tuner controller - error tuning frequency [" + frequency + "]", e);
        }
        finally {
            this.getAdapter().getLock().unlock();
        }
    }

    private long calculateActualFrequency(PLL pll, byte z, int x) {
        long whole = pll.getScaledOscillator() * (z & 0xFF);
        int fractional = (int)((double)pll.getScaledOscillator() * ((double)x / 65536.0));
        return whole + (long)fractional;
    }

    @Override
    protected void initTuner() throws UsbException {
        this.getAdapter().enableI2CRepeater();
        boolean i2CRepeaterControl = false;
        this.readE4KRegister(Register.DUMMY, i2CRepeaterControl);
        this.writeE4KRegister(Register.MASTER1, (byte)7, i2CRepeaterControl);
        this.writeE4KRegister(Register.CLK_INP, (byte)0, i2CRepeaterControl);
        this.writeE4KRegister(Register.REF_CLK, (byte)0, i2CRepeaterControl);
        this.writeE4KRegister(Register.CLKOUT_PWDN, (byte)-106, i2CRepeaterControl);
        this.magicInit(i2CRepeaterControl);
        this.generateDCOffsetTables(i2CRepeaterControl);
        this.writeE4KRegister(Register.DCTIME1, (byte)1, i2CRepeaterControl);
        this.writeE4KRegister(Register.DCTIME2, (byte)1, i2CRepeaterControl);
        this.writeE4KRegister(Register.AGC4, (byte)16, i2CRepeaterControl);
        this.writeE4KRegister(Register.AGC5, (byte)4, i2CRepeaterControl);
        this.writeE4KRegister(Register.AGC6, (byte)26, i2CRepeaterControl);
        this.writeMaskedE4KRegister(Register.AGC1, (byte)15, AGCMode.SERIAL.getValue(), false);
        this.writeMaskedE4KRegister(Register.AGC7, (byte)1, (byte)0, false);
        this.setLNAGain(E4KLNAGain.AUTOMATIC, i2CRepeaterControl);
        this.setMixerGain(E4KMixerGain.AUTOMATIC, i2CRepeaterControl);
        this.setEnhanceGain(E4KEnhanceGain.GAIN_5, i2CRepeaterControl);
        this.setIFGain(IFGain.LINEARITY_8, i2CRepeaterControl);
        this.setMixerFilter(MixerFilter.BW_1M9, i2CRepeaterControl);
        this.setRCFilter(RCFilter.BW_1M0, i2CRepeaterControl);
        this.setChannelFilter(ChannelFilter.BW_2M15, i2CRepeaterControl);
        this.setChannelFilterEnabled(true, i2CRepeaterControl);
        this.setDCRangeDetectorEnabled(false, i2CRepeaterControl);
        this.setDCOffsetLookupTablesEnabled(false, i2CRepeaterControl);
        this.writeMaskedE4KRegister(Register.DC5, (byte)3, (byte)0, i2CRepeaterControl);
        this.writeMaskedE4KRegister(Register.DCTIME1, (byte)3, (byte)0, i2CRepeaterControl);
        this.writeMaskedE4KRegister(Register.DCTIME2, (byte)3, (byte)0, i2CRepeaterControl);
        this.getAdapter().disableI2CRepeater();
    }

    private void requestDcOffsetCalibration(boolean controlI2CRepeater) throws LibUsbException {
        if (controlI2CRepeater) {
            this.getAdapter().enableI2CRepeater();
        }
        this.writeMaskedE4KRegister(Register.DC1, (byte)1, (byte)1, false);
        if (controlI2CRepeater) {
            this.getAdapter().disableI2CRepeater();
        }
    }

    private void generateDCOffsetTables(boolean controlI2CRepeater) throws UsbException {
        if (controlI2CRepeater) {
            this.getAdapter().enableI2CRepeater();
        }
        boolean i2CRepeaterControl = false;
        this.setIFGain(IFGain.LINEARITY_60, i2CRepeaterControl);
        this.setDCRangeDetectorEnabled(true, i2CRepeaterControl);
        this.setDCOffsetLookupTablesEnabled(true, i2CRepeaterControl);
        this.setIFStage1Gain(IFStage1Gain.GAIN_MINUS3, i2CRepeaterControl);
        this.setMixerGain(E4KMixerGain.GAIN_4, i2CRepeaterControl);
        this.requestDcOffsetCalibration(i2CRepeaterControl);
        byte i = this.getDcOffsetI(i2CRepeaterControl);
        byte q = this.getDcOffsetQ(i2CRepeaterControl);
        this.writeE4KRegister(Register.ILUT0, i, i2CRepeaterControl);
        this.writeE4KRegister(Register.QLUT0, q, i2CRepeaterControl);
        this.setMixerGain(E4KMixerGain.GAIN_12, i2CRepeaterControl);
        this.requestDcOffsetCalibration(i2CRepeaterControl);
        i = this.getDcOffsetI(i2CRepeaterControl);
        q = this.getDcOffsetQ(i2CRepeaterControl);
        this.writeE4KRegister(Register.ILUT1, i, i2CRepeaterControl);
        this.writeE4KRegister(Register.QLUT1, q, i2CRepeaterControl);
        this.setIFStage1Gain(IFStage1Gain.GAIN_PLUS6, i2CRepeaterControl);
        this.setMixerGain(E4KMixerGain.GAIN_4, i2CRepeaterControl);
        this.requestDcOffsetCalibration(i2CRepeaterControl);
        i = this.getDcOffsetI(i2CRepeaterControl);
        q = this.getDcOffsetQ(i2CRepeaterControl);
        this.writeE4KRegister(Register.ILUT2, i, i2CRepeaterControl);
        this.writeE4KRegister(Register.QLUT2, q, i2CRepeaterControl);
        this.setMixerGain(E4KMixerGain.GAIN_12, i2CRepeaterControl);
        this.requestDcOffsetCalibration(i2CRepeaterControl);
        i = this.getDcOffsetI(i2CRepeaterControl);
        q = this.getDcOffsetQ(i2CRepeaterControl);
        this.writeE4KRegister(Register.ILUT3, i, i2CRepeaterControl);
        this.writeE4KRegister(Register.QLUT3, q, i2CRepeaterControl);
        if (controlI2CRepeater) {
            this.getAdapter().disableI2CRepeater();
        }
    }

    private byte getDcOffsetI(boolean i2CRepeaterControl) {
        byte offset = (byte)(this.readE4KRegister(Register.DC2, i2CRepeaterControl) & 0x3F);
        byte range = (byte)((this.readE4KRegister(Register.DC4, i2CRepeaterControl) & 3) << 6);
        return (byte)(range | offset);
    }

    private byte getDcOffsetQ(boolean i2CRepeaterControl) {
        byte offset = (byte)(this.readE4KRegister(Register.DC3, i2CRepeaterControl) & 0x3F);
        byte range = (byte)(this.readE4KRegister(Register.DC4, i2CRepeaterControl) << 2);
        return (byte)(range | offset);
    }

    public void setDCOffsetLookupTablesEnabled(boolean enabled, boolean controlI2CRepeater) throws LibUsbException {
        byte value = enabled ? (byte)3 : 0;
        this.writeMaskedE4KRegister(Register.DC5, value, (byte)3, controlI2CRepeater);
    }

    public void setDCRangeDetectorEnabled(boolean enabled, boolean controlI2CRepeater) throws LibUsbException {
        byte value = enabled ? (byte)4 : 0;
        this.writeMaskedE4KRegister(Register.DC5, (byte)4, value, controlI2CRepeater);
    }

    public void setLNAGain(E4KLNAGain gain, boolean controlI2CRepeater) throws UsbException {
        this.getAdapter().getLock().lock();
        try {
            if (controlI2CRepeater) {
                this.getAdapter().enableI2CRepeater();
            }
            if (gain == E4KLNAGain.AUTOMATIC) {
                this.writeMaskedE4KRegister(Register.AGC1, (byte)15, AGCMode.IF_SERIAL_LNA_AUTON.getValue(), false);
            } else {
                this.writeMaskedE4KRegister(Register.AGC1, (byte)15, AGCMode.SERIAL.getValue(), false);
                this.writeMaskedE4KRegister(E4KLNAGain.getRegister(), E4KLNAGain.getMask(), gain.getValue(), false);
            }
            if (controlI2CRepeater) {
                this.getAdapter().disableI2CRepeater();
            }
        }
        finally {
            this.getAdapter().getLock().unlock();
        }
    }

    public E4KLNAGain getLNAGain(boolean controlI2CRepeater) throws UsbException {
        return E4KLNAGain.fromRegisterValue(this.readE4KRegister(E4KLNAGain.getRegister(), controlI2CRepeater));
    }

    public void setEnhanceGain(E4KEnhanceGain gain, boolean controlI2CRepeater) throws UsbException {
        this.writeMaskedE4KRegister(E4KEnhanceGain.getRegister(), E4KEnhanceGain.getMask(), gain.getValue(), controlI2CRepeater);
    }

    public E4KEnhanceGain getEnhanceGain(boolean controlI2CRepeater) throws UsbException {
        return E4KEnhanceGain.fromRegisterValue(this.readE4KRegister(E4KEnhanceGain.getRegister(), controlI2CRepeater));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMixerGain(E4KMixerGain gain, boolean controlI2CRepeater) throws UsbException {
        this.getAdapter().getLock().lock();
        try {
            if (controlI2CRepeater) {
                this.getAdapter().enableI2CRepeater();
            }
            boolean repeaterControl = false;
            if (gain == E4KMixerGain.AUTOMATIC) {
                this.writeMaskedE4KRegister(Register.AGC7, (byte)1, (byte)1, repeaterControl);
            } else {
                this.writeMaskedE4KRegister(Register.AGC7, (byte)1, (byte)0, repeaterControl);
                this.writeMaskedE4KRegister(E4KMixerGain.getRegister(), E4KMixerGain.getMask(), gain.getValue(), repeaterControl);
            }
            if (controlI2CRepeater) {
                this.getAdapter().disableI2CRepeater();
            }
        }
        finally {
            this.getAdapter().getLock().unlock();
        }
    }

    public E4KMixerGain getMixerGain(boolean controlI2CRepeater) throws UsbException {
        byte autoOrManual = this.readMaskedE4KRegister(Register.AGC7, (byte)1, controlI2CRepeater);
        if (autoOrManual == 1) {
            return E4KMixerGain.AUTOMATIC;
        }
        int register = this.readE4KRegister(E4KMixerGain.getRegister(), controlI2CRepeater);
        return E4KMixerGain.fromRegisterValue(register);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIFGain(IFGain gain, boolean controlI2CRepeater) throws LibUsbException {
        this.getAdapter().getLock().lock();
        try {
            byte linearityMode = gain.isLinearity() ? (byte)0 : 16;
            this.writeMaskedE4KRegister(Register.AGC1, gain.getLinearityModeMask(), linearityMode, controlI2CRepeater);
            this.writeMaskedE4KRegister(Register.GAIN3, gain.getGain3Mask(), gain.getGain3(), controlI2CRepeater);
            this.writeMaskedE4KRegister(Register.GAIN4, gain.getGain4Mask(), gain.getGain4(), controlI2CRepeater);
        }
        finally {
            this.getAdapter().getLock().unlock();
        }
    }

    public void setIFStage1Gain(IFStage1Gain gain, boolean controlI2CRepeater) {
        if (controlI2CRepeater) {
            this.getAdapter().enableI2CRepeater();
        }
        this.writeMaskedE4KRegister(Register.GAIN3, gain.getValue(), gain.getMask(), false);
        if (controlI2CRepeater) {
            this.getAdapter().disableI2CRepeater();
        }
    }

    public void setMixerFilter(MixerFilter filter, boolean controlI2CRepeater) throws LibUsbException {
        this.writeMaskedE4KRegister(MixerFilter.getRegister(), MixerFilter.getMask(), filter.getValue(), controlI2CRepeater);
    }

    public MixerFilter getMixerFilter(boolean controlI2CRepeater) throws UsbException {
        int value = this.readE4KRegister(MixerFilter.getRegister(), controlI2CRepeater);
        return MixerFilter.fromRegisterValue(value);
    }

    public void setRCFilter(RCFilter filter, boolean controlI2CRepeater) throws LibUsbException {
        this.writeMaskedE4KRegister(RCFilter.getRegister(), RCFilter.getMask(), filter.getValue(), controlI2CRepeater);
    }

    public RCFilter getRCFilter(boolean controlI2CRepeater) throws UsbException {
        int value = this.readE4KRegister(RCFilter.getRegister(), controlI2CRepeater);
        return RCFilter.fromRegisterValue(value);
    }

    public void setChannelFilter(ChannelFilter filter, boolean controlI2CRepeater) throws LibUsbException {
        this.writeMaskedE4KRegister(ChannelFilter.getRegister(), ChannelFilter.getMask(), filter.getValue(), controlI2CRepeater);
    }

    public ChannelFilter getChannelFilter(boolean controlI2CRepeater) throws UsbException {
        int value = this.readE4KRegister(ChannelFilter.getRegister(), controlI2CRepeater);
        return ChannelFilter.fromRegisterValue(value);
    }

    public void setChannelFilterEnabled(boolean enabled, boolean controlI2CRepeater) throws UsbException {
        if (enabled) {
            this.writeMaskedE4KRegister(Register.FILT3, (byte)32, (byte)0, controlI2CRepeater);
        } else {
            this.writeMaskedE4KRegister(Register.FILT3, (byte)32, (byte)32, controlI2CRepeater);
        }
    }

    public void setVcoAutoCalibration(boolean enabled, boolean controlI2CRepeater) {
        byte value = enabled ? (byte)1 : 0;
        byte mask = 3;
        this.writeMaskedE4KRegister(Register.SYNTH8, mask, value, controlI2CRepeater);
    }

    public void setBand(long frequency, boolean controlI2CRepeater) throws UsbException {
        if (controlI2CRepeater) {
            this.getAdapter().enableI2CRepeater();
        }
        FrequencyBand frequencyBand = FrequencyBand.fromFrequency(frequency);
        switch (frequencyBand) {
            case UHF: 
            case VHF2: 
            case VHF3: {
                this.writeE4KRegister(Register.BIAS, (byte)3, false);
                break;
            }
            default: {
                this.writeE4KRegister(Register.BIAS, (byte)0, false);
            }
        }
        this.writeMaskedE4KRegister(Register.SYNTH1, FrequencyBand.getMask(), (byte)0, false);
        this.writeMaskedE4KRegister(Register.SYNTH1, FrequencyBand.getMask(), frequencyBand.getValue(), false);
        if (controlI2CRepeater) {
            this.getAdapter().disableI2CRepeater();
        }
    }

    private void setRFFilter(long frequency, boolean controlI2CRepeater) throws UsbException {
        RFFilter filter = RFFilter.fromFrequency(frequency);
        this.writeMaskedE4KRegister(Register.FILT1, RFFilter.getMask(), filter.getValue(), controlI2CRepeater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGain(E4KGain gain, boolean controlI2CRepeater) throws UsbException {
        this.getAdapter().getLock().lock();
        try {
            if (gain != E4KGain.MANUAL) {
                if (controlI2CRepeater) {
                    this.getAdapter().enableI2CRepeater();
                }
                boolean i2CRepeaterControl = false;
                this.setLNAGain(gain.getLNAGain(), i2CRepeaterControl);
                this.setMixerGain(gain.getMixerGain(), i2CRepeaterControl);
                if (controlI2CRepeater) {
                    this.getAdapter().disableI2CRepeater();
                }
            }
        }
        finally {
            this.getAdapter().getLock().unlock();
        }
    }

    private void magicInit(boolean controlI2CRepeater) throws UsbException {
        if (controlI2CRepeater) {
            this.getAdapter().enableI2CRepeater();
        }
        this.writeE4KRegister(Register.MAGIC_1, (byte)1, false);
        this.writeE4KRegister(Register.MAGIC_2, (byte)-2, false);
        this.writeE4KRegister(Register.MAGIC_3, (byte)0, false);
        this.writeE4KRegister(Register.MAGIC_4, (byte)80, false);
        this.writeE4KRegister(Register.MAGIC_5, (byte)32, false);
        this.writeE4KRegister(Register.MAGIC_6, (byte)1, false);
        this.writeE4KRegister(Register.MAGIC_7, (byte)127, false);
        this.writeE4KRegister(Register.MAGIC_8, (byte)7, false);
        if (controlI2CRepeater) {
            this.getAdapter().disableI2CRepeater();
        }
    }

    private byte readMaskedE4KRegister(Register register, byte mask, boolean controlI2CRepeater) throws UsbException {
        int temp = this.readE4KRegister(register, controlI2CRepeater);
        return (byte)(temp & mask);
    }

    private void writeMaskedE4KRegister(Register register, byte mask, byte value, boolean controlI2CRepeater) throws LibUsbException {
        int temp = this.readE4KRegister(register, controlI2CRepeater);
        if ((byte)(temp & mask) != value) {
            this.writeE4KRegister(register, (byte)(temp & ~mask | value & mask), controlI2CRepeater);
            this.readE4KRegister(register, controlI2CRepeater);
        }
    }

    private int readE4KRegister(Register register, boolean controlI2CRepeater) throws LibUsbException {
        return this.getAdapter().readI2CRegister(Register.I2C_REGISTER.getValue(), register.getValue(), controlI2CRepeater);
    }

    private void writeE4KRegister(Register register, byte value, boolean controlI2CRepeater) throws LibUsbException {
        this.getAdapter().writeI2CRegister(Register.I2C_REGISTER.getValue(), register.getValue(), value, controlI2CRepeater);
    }

    public static enum E4KGain {
        AUTOMATIC("Auto", E4KMixerGain.AUTOMATIC, E4KLNAGain.AUTOMATIC),
        MANUAL("Manual", null, null),
        MINUS_10("-1.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_MINUS_50),
        PLUS_15("1.5 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_MINUS_25),
        PLUS_40("4.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_0),
        PLUS_65("6.5 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_25),
        PLUS_90("9.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_50),
        PLUS_115("11.5 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_75),
        PLUS_140("14.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_100),
        PLUS_165("16.5 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_125),
        PLUS_190("19.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_150),
        PLUS_215("21.5 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_175),
        PLUS_240("24.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_200),
        PLUS_290("29.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_250),
        PLUS_340("34.0 db", E4KMixerGain.GAIN_4, E4KLNAGain.GAIN_PLUS_300),
        PLUS_420("42.0 db", E4KMixerGain.GAIN_12, E4KLNAGain.GAIN_PLUS_300);

        private String mLabel;
        private E4KMixerGain mMixerGain;
        private E4KLNAGain mLNAGain;

        private E4KGain(String label, E4KMixerGain mixerGain, E4KLNAGain lnaGain) {
            this.mLabel = label;
            this.mMixerGain = mixerGain;
            this.mLNAGain = lnaGain;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public E4KMixerGain getMixerGain() {
            return this.mMixerGain;
        }

        public E4KLNAGain getLNAGain() {
            return this.mLNAGain;
        }
    }

    public static enum E4KMixerGain {
        AUTOMATIC(-1, "Auto"),
        GAIN_4(0, "4 db"),
        GAIN_12(1, "12 db");

        private int mValue;
        private String mLabel;

        private E4KMixerGain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN2;
        }

        public static byte getMask() {
            return 1;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static E4KMixerGain fromRegisterValue(int registerValue) {
            int value = registerValue & E4KMixerGain.getMask();
            for (E4KMixerGain setting : E4KMixerGain.values()) {
                if (value != setting.getValue()) continue;
                return setting;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized Mixer Gain value [" + value + "]");
        }
    }

    public static enum E4KLNAGain {
        AUTOMATIC(-1, "Auto"),
        GAIN_MINUS_50(0, "-5.0 db"),
        GAIN_MINUS_25(1, "-2.5 db"),
        GAIN_PLUS_0(4, "0.0 db"),
        GAIN_PLUS_25(5, "2.5 db"),
        GAIN_PLUS_50(6, "5.0 db"),
        GAIN_PLUS_75(7, "7.5 db"),
        GAIN_PLUS_100(8, "10.0 db"),
        GAIN_PLUS_125(9, "12.5 db"),
        GAIN_PLUS_150(10, "15.0 db"),
        GAIN_PLUS_175(11, "17.5 db"),
        GAIN_PLUS_200(12, "20.0 db"),
        GAIN_PLUS_250(13, "25.0 db"),
        GAIN_PLUS_300(14, "30.0 db");

        private int mValue;
        private String mLabel;

        private E4KLNAGain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN1;
        }

        public static byte getMask() {
            return 15;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static E4KLNAGain fromRegisterValue(int registerValue) {
            int value = registerValue & E4KLNAGain.getMask();
            for (E4KLNAGain setting : E4KLNAGain.values()) {
                if (value != setting.getValue()) continue;
                return setting;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized LNA Gain value [" + value + "]");
        }
    }

    public static enum IFGain {
        LINEARITY_6(0, 0, "6"),
        LINEARITY_7(32, 0, "7"),
        LINEARITY_8(64, 0, "8"),
        LINEARITY_9(0, 8, "9"),
        LINEARITY_10(32, 8, "10"),
        LINEARITY_11(64, 8, "11"),
        LINEARITY_12(0, 16, "12"),
        LINEARITY_13(32, 16, "13"),
        LINEARITY_14(64, 16, "14"),
        LINEARITY_15(0, 24, "15"),
        LINEARITY_16(32, 24, "16"),
        LINEARITY_17(64, 24, "17"),
        LINEARITY_18(0, 32, "18"),
        LINEARITY_19(32, 32, "19"),
        LINEARITY_20(64, 32, "20"),
        LINEARITY_21(0, 33, "21"),
        LINEARITY_22(32, 33, "22"),
        LINEARITY_23(64, 33, "23"),
        LINEARITY_24(0, 34, "24"),
        LINEARITY_25(32, 34, "25"),
        LINEARITY_26(64, 34, "26"),
        LINEARITY_27(0, 35, "27"),
        LINEARITY_28(32, 35, "28"),
        LINEARITY_29(64, 35, "29"),
        LINEARITY_30(0, 36, "30"),
        LINEARITY_31(32, 36, "31"),
        LINEARITY_32(64, 36, "32"),
        LINEARITY_33(8, 36, "33"),
        LINEARITY_34(40, 36, "34"),
        LINEARITY_35(72, 36, "35"),
        LINEARITY_36(16, 36, "36"),
        LINEARITY_37(48, 36, "37"),
        LINEARITY_38(80, 36, "38"),
        LINEARITY_39(24, 36, "39"),
        LINEARITY_40(56, 36, "40"),
        LINEARITY_41(88, 36, "41"),
        LINEARITY_42(26, 36, "42"),
        LINEARITY_43(58, 36, "43"),
        LINEARITY_44(90, 36, "44"),
        LINEARITY_45(28, 36, "45"),
        LINEARITY_46(60, 36, "46"),
        LINEARITY_47(92, 36, "47"),
        LINEARITY_48(25, 36, "48"),
        LINEARITY_49(57, 36, "49"),
        LINEARITY_50(89, 36, "50"),
        LINEARITY_51(27, 36, "51"),
        LINEARITY_52(59, 36, "52"),
        LINEARITY_53(91, 36, "53"),
        LINEARITY_54(29, 36, "54"),
        LINEARITY_55(61, 36, "55"),
        LINEARITY_56(93, 36, "56"),
        LINEARITY_57(31, 36, "57"),
        LINEARITY_58(63, 36, "58"),
        LINEARITY_59(95, 36, "59"),
        LINEARITY_60(127, 36, "60"),
        SENSITIVITY_6(0, 0, "6"),
        SENSITIVITY_7(32, 0, "7"),
        SENSITIVITY_8(64, 0, "8"),
        SENSITIVITY_9(2, 0, "9"),
        SENSITIVITY_10(34, 0, "10"),
        SENSITIVITY_11(68, 0, "11"),
        SENSITIVITY_12(4, 0, "12"),
        SENSITIVITY_13(36, 0, "13"),
        SENSITIVITY_14(68, 0, "14"),
        SENSITIVITY_15(1, 0, "15"),
        SENSITIVITY_16(33, 0, "16"),
        SENSITIVITY_17(65, 0, "17"),
        SENSITIVITY_18(3, 0, "18"),
        SENSITIVITY_19(35, 0, "19"),
        SENSITIVITY_20(67, 0, "20"),
        SENSITIVITY_21(5, 0, "21"),
        SENSITIVITY_22(37, 0, "22"),
        SENSITIVITY_23(69, 0, "23"),
        SENSITIVITY_24(7, 0, "24"),
        SENSITIVITY_25(39, 0, "25"),
        SENSITIVITY_26(71, 0, "26"),
        SENSITIVITY_27(15, 0, "27"),
        SENSITIVITY_28(47, 0, "28"),
        SENSITIVITY_29(79, 0, "29"),
        SENSITIVITY_30(23, 0, "30"),
        SENSITIVITY_31(55, 0, "31"),
        SENSITIVITY_32(87, 0, "32"),
        SENSITIVITY_33(31, 0, "33"),
        SENSITIVITY_34(63, 0, "34"),
        SENSITIVITY_35(95, 0, "35"),
        SENSITIVITY_36(31, 1, "36"),
        SENSITIVITY_37(63, 1, "37"),
        SENSITIVITY_38(95, 1, "38"),
        SENSITIVITY_39(31, 2, "39"),
        SENSITIVITY_40(63, 2, "40"),
        SENSITIVITY_41(95, 2, "41"),
        SENSITIVITY_42(31, 3, "42"),
        SENSITIVITY_43(63, 3, "43"),
        SENSITIVITY_44(95, 3, "44"),
        SENSITIVITY_45(31, 4, "45"),
        SENSITIVITY_46(63, 4, "46"),
        SENSITIVITY_47(95, 4, "47"),
        SENSITIVITY_48(31, 12, "48"),
        SENSITIVITY_49(63, 12, "49"),
        SENSITIVITY_50(95, 12, "50"),
        SENSITIVITY_51(31, 20, "51"),
        SENSITIVITY_52(63, 20, "52"),
        SENSITIVITY_53(95, 20, "53"),
        SENSITIVITY_54(31, 28, "54"),
        SENSITIVITY_55(63, 28, "55"),
        SENSITIVITY_56(95, 28, "56"),
        SENSITIVITY_57(31, 36, "57"),
        SENSITIVITY_58(63, 36, "58"),
        SENSITIVITY_59(95, 36, "59"),
        SENSITIVITY_60(127, 36, "60");

        private byte mGain3;
        private byte mGain4;
        private String mLabel;
        public static EnumSet<IFGain> LINEARITY_GAINS;

        private IFGain(byte gain3, byte gain4, String label) {
            this.mGain3 = gain3;
            this.mGain4 = gain4;
            this.mLabel = label;
        }

        public byte getGain3() {
            return this.mGain3;
        }

        public byte getGain4() {
            return this.mGain4;
        }

        public byte getGain3Mask() {
            return 127;
        }

        public byte getGain4Mask() {
            return 63;
        }

        public byte getLinearityModeMask() {
            return 16;
        }

        public boolean isLinearity() {
            return LINEARITY_GAINS.contains((Object)this);
        }

        public String toString() {
            if (this.isLinearity()) {
                return "Linearity " + this.mLabel + " dB";
            }
            return "Sensitivity " + this.mLabel + " dB";
        }

        static {
            LINEARITY_GAINS = EnumSet.range(LINEARITY_6, LINEARITY_60);
        }
    }

    public static enum MixerFilter {
        BW_27M0(0, 27000000, 4800000, 28800000, "27.0 MHz"),
        BW_4M6(128, 4600000, 4400000, 4800000, "4.6 MHz"),
        BW_4M2(144, 4200000, 4000000, 4400000, "4.2 MHz"),
        BW_3M8(160, 3800000, 3600000, 4000000, "3.8 MHz"),
        BW_3M4(176, 3400000, 3200000, 3600000, "3.4 MHz"),
        BW_3M0(192, 3000000, 2850000, 3200000, "3.0 MHz"),
        BW_2M7(208, 2700000, 2500000, 2850000, "2.7 MHz"),
        BW_2M3(224, 2300000, 0x200B20, 2500000, "2.3 MHz"),
        BW_1M9(240, 1900000, 0, 0x200B20, "1.9 MHz");

        private int mValue;
        private int mBandwidth;
        private int mMinBandwidth;
        private int mMaxBandwidth;
        private String mLabel;

        private MixerFilter(int value, int bandwidth, int minimumBandwidth, int maximumBandwidth, String label) {
            this.mValue = value;
            this.mBandwidth = bandwidth;
            this.mMinBandwidth = minimumBandwidth;
            this.mMaxBandwidth = maximumBandwidth;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.FILT2;
        }

        public static byte getMask() {
            return -16;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public int getBandwidth() {
            return this.mBandwidth;
        }

        public int getMinimumBandwidth() {
            return this.mMinBandwidth;
        }

        public int getMaximumBandwidth() {
            return this.mMaxBandwidth;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public static MixerFilter getFilter(int bandwidth) {
            for (MixerFilter filter : MixerFilter.values()) {
                if (filter.getMinimumBandwidth() > bandwidth || bandwidth >= filter.getMaximumBandwidth()) continue;
                return filter;
            }
            return BW_27M0;
        }

        public static MixerFilter fromRegisterValue(int registerValue) {
            int value = registerValue & MixerFilter.getMask();
            for (MixerFilter filter : MixerFilter.values()) {
                if (value != filter.getValue()) continue;
                return filter;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized mixer filter value [" + value + "]");
        }
    }

    public static enum ChannelFilter {
        BW_5M50(0, 5500000, 5500000, 28800000, "5.50 MHz"),
        BW_5M30(1, 5300000, 5300000, 5500000, "5.30 MHz"),
        BW_5M00(2, 5000000, 5000000, 5300000, "5.00 MHz"),
        BW_4M80(3, 4800000, 4800000, 5000000, "4.80 MHz"),
        BW_4M60(4, 4600000, 4600000, 4800000, "4.60 MHz"),
        BW_4M40(5, 4400000, 4400000, 4600000, "4.40 MHz"),
        BW_4M30(6, 4300000, 4300000, 4400000, "4.30 MHz"),
        BW_4M10(7, 4100000, 4100000, 4300000, "4.10 MHz"),
        BW_3M90(8, 3900000, 3900000, 4100000, "3.90 MHz"),
        BW_3M80(9, 3800000, 3800000, 3900000, "3.80 MHz"),
        BW_3M70(10, 3700000, 3700000, 3800000, "3.70 MHz"),
        BW_3M60(11, 3600000, 3600000, 3700000, "3.60 MHz"),
        BW_3M40(12, 3400000, 3400000, 3600000, "3.40 MHz"),
        BW_3M30(13, 3300000, 3300000, 3400000, "3.30 MHz"),
        BW_3M20(14, 3200000, 3200000, 3300000, "3.20 MHz"),
        BW_3M10(15, 3100000, 3100000, 3200000, "3.10 MHz"),
        BW_3M00(16, 3000000, 3000000, 3100000, "3.00 MHz"),
        BW_2M95(17, 2950000, 2950000, 3000000, "2.95 MHz"),
        BW_2M90(18, 2900000, 2900000, 2950000, "2.90 MHz"),
        BW_2M80(19, 2800000, 2800000, 2900000, "2.80 MHz"),
        BW_2M75(20, 2750000, 2750000, 2800000, "2.75 MHz"),
        BW_2M70(21, 2700000, 2700000, 2750000, "2.70 MHz"),
        BW_2M60(22, 2600000, 2600000, 2700000, "2.60 MHz"),
        BW_2M55(23, 2550000, 2550000, 2600000, "2.55 MHz"),
        BW_2M50(24, 2500000, 2500000, 2550000, "2.50 MHz"),
        BW_2M45(25, 2450000, 2450000, 2500000, "2.45 MHz"),
        BW_2M40(26, 2400000, 2400000, 2450000, "2.40 MHz"),
        BW_2M30(27, 2300000, 2300000, 2400000, "2.30 MHz"),
        BW_2M28(28, 2280000, 2280000, 2300000, "2.28 MHz"),
        BW_2M24(29, 0x222E00, 0x222E00, 2280000, "2.24 MHz"),
        BW_2M20(30, 2200000, 2200000, 0x222E00, "2.20 MHz"),
        BW_2M15(31, 2150000, 0, 2150000, "2.15 MHz");

        private int mValue;
        private int mBandwidth;
        private int mMinBandwidth;
        private int mMaxBandwidth;
        private String mLabel;

        private ChannelFilter(int value, int bandwidth, int minimumBandwidth, int maximumBandwidth, String label) {
            this.mValue = value;
            this.mBandwidth = bandwidth;
            this.mMinBandwidth = minimumBandwidth;
            this.mMaxBandwidth = maximumBandwidth;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.FILT3;
        }

        public static byte getMask() {
            return 31;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public int getBandwidth() {
            return this.mBandwidth;
        }

        public int getMinimumBandwidth() {
            return this.mMinBandwidth;
        }

        public int getMaximumBandwidth() {
            return this.mMaxBandwidth;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public static ChannelFilter getFilter(int bandwidth) {
            for (ChannelFilter filter : ChannelFilter.values()) {
                if (filter.getMinimumBandwidth() > bandwidth || bandwidth >= filter.getMaximumBandwidth()) continue;
                return filter;
            }
            return BW_5M50;
        }

        public static ChannelFilter fromRegisterValue(int registerValue) {
            int value = registerValue & ChannelFilter.getMask();
            for (ChannelFilter filter : ChannelFilter.values()) {
                if (value != filter.getValue()) continue;
                return filter;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized channel filter value [" + value + "]");
        }
    }

    public static enum RCFilter {
        BW_21M4(0, 21400000, 21200000, 28800000, "21.4 MHz"),
        BW_21M0(1, 21000000, 19300000, 21200000, "21.0 MHz"),
        BW_17M6(2, 17600000, 16150000, 19300000, "17.6 MHz"),
        BW_14M7(3, 14700000, 13550000, 16150000, "14.7 MHz"),
        BW_12M4(4, 12400000, 11500000, 13550000, "12.4 MHz"),
        BW_10M6(5, 10600000, 9800000, 11500000, "10.6 MHz"),
        BW_9M0(6, 9000000, 8350000, 9800000, "9.0 MHz"),
        BW_7M7(7, 7700000, 7050000, 8350000, "7.7 MHz"),
        BW_6M4(8, 6400000, 5805000, 7050000, "6.4 MHz"),
        BW_5M3(9, 5300000, 4850000, 5805000, "5.3 MHz"),
        BW_4M4(10, 4400000, 3900000, 4850000, "4.4 MHz"),
        BW_3M4(11, 3400000, 3000000, 3900000, "3.4 MHz"),
        BW_2M6(12, 2600000, 2200000, 3000000, "2.6 MHz"),
        BW_1M8(13, 1800000, 1500000, 2200000, "1.8 MHz"),
        BW_1M2(14, 1200000, 1100000, 1500000, "1.2 MHz"),
        BW_1M0(15, 1000000, 0, 1100000, "1.0 MHz");

        private int mValue;
        private int mBandwidth;
        private int mMinBandwidth;
        private int mMaxBandwidth;
        private String mLabel;

        private RCFilter(int value, int bandwidth, int minimumBandwidth, int maximumBandwidth, String label) {
            this.mValue = value;
            this.mBandwidth = bandwidth;
            this.mMinBandwidth = minimumBandwidth;
            this.mMaxBandwidth = maximumBandwidth;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.FILT2;
        }

        public static byte getMask() {
            return 15;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public int getBandwidth() {
            return this.mBandwidth;
        }

        public int getMinimumBandwidth() {
            return this.mMinBandwidth;
        }

        public int getMaximumBandwidth() {
            return this.mMaxBandwidth;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public static RCFilter getFilter(int bandwidth) {
            for (RCFilter filter : RCFilter.values()) {
                if (filter.getMinimumBandwidth() > bandwidth || bandwidth >= filter.getMaximumBandwidth()) continue;
                return filter;
            }
            return BW_21M4;
        }

        public static RCFilter fromRegisterValue(int registerValue) {
            int value = registerValue & RCFilter.getMask();
            for (RCFilter filter : RCFilter.values()) {
                if (value != filter.getValue()) continue;
                return filter;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized rc filter value [" + value + "]");
        }
    }

    public static enum Register {
        DUMMY(0),
        MASTER1(0),
        MASTER2(1),
        MASTER3(2),
        MASTER4(3),
        MASTER5(4),
        CLK_INP(5),
        REF_CLK(6),
        SYNTH1(7),
        SYNTH2(8),
        SYNTH3(9),
        SYNTH4(10),
        SYNTH5(11),
        SYNTH6(12),
        SYNTH7(13),
        SYNTH8(14),
        SYNTH9(15),
        FILT1(16),
        FILT2(17),
        FILT3(18),
        GAIN1(20),
        GAIN2(21),
        GAIN3(22),
        GAIN4(23),
        AGC1(26),
        AGC2(27),
        AGC3(28),
        AGC4(29),
        AGC5(30),
        AGC6(31),
        AGC7(32),
        AGC8(33),
        AGC11(36),
        AGC12(37),
        DC1(41),
        DC2(42),
        DC3(43),
        DC4(44),
        DC5(45),
        DC6(46),
        DC7(47),
        DC8(48),
        QLUT0(80),
        QLUT1(81),
        QLUT2(82),
        QLUT3(83),
        ILUT0(96),
        ILUT1(97),
        ILUT2(98),
        ILUT3(99),
        DCTIME1(112),
        DCTIME2(113),
        DCTIME3(114),
        DCTIME4(115),
        PWM1(116),
        PWM2(117),
        PWM3(118),
        PWM4(119),
        BIAS(120),
        CLKOUT_PWDN(122),
        CHFILT_CALIB(123),
        I2C_REG_ADDR(125),
        MAGIC_1(126),
        MAGIC_2(127),
        MAGIC_3(130),
        MAGIC_4(134),
        MAGIC_5(135),
        MAGIC_6(136),
        MAGIC_7(159),
        MAGIC_8(160),
        I2C_REGISTER(200);

        private int mValue;

        private Register(int value) {
            this.mValue = value;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }
    }

    public static enum PLL {
        PLL_72M4(15, 72400000L, 48, 600000, true, "72.4 MHz"),
        PLL_81M2(14, 81200000L, 40, 720000, true, "81.2 MHz"),
        PLL_108M3(13, 108300000L, 32, 900000, true, "108.3 MHz"),
        PLL_162M5(12, 162500000L, 24, 1200000, true, "162.5 MHz"),
        PLL_216M6(11, 216600000L, 16, 1800000, true, "216.6 MHz"),
        PLL_325M0(10, 325000000L, 12, 2400000, true, "325.0 MHz"),
        PLL_350M0(9, 350000000L, 8, 3600000, true, "350.0 MHz"),
        PLL_432M0(3, 432000000L, 8, 3600000, false, "432.0 MHz"),
        PLL_667M0(2, 667000000L, 6, 4800000, false, "667.0 MHz"),
        PLL_1200M0(1, 1200000000L, 4, 0x6DDD00, false, "1200.0 MHz");

        private int mIndex;
        private long mFrequency;
        private int mMultiplier;
        private int mScaledOscillator;
        private boolean mRequires3PhaseMixing;
        private String mLabel;

        private PLL(int index, long frequency, int multiplier, int scaledOscillator, boolean requires3Phase, String label) {
            this.mIndex = index;
            this.mFrequency = frequency;
            this.mMultiplier = multiplier;
            this.mScaledOscillator = scaledOscillator;
            this.mRequires3PhaseMixing = requires3Phase;
            this.mLabel = label;
        }

        public byte getIndex() {
            return (byte)this.mIndex;
        }

        public long getFrequency() {
            return this.mFrequency;
        }

        public byte getMultiplier() {
            return (byte)this.mMultiplier;
        }

        public int getScaledOscillator() {
            return this.mScaledOscillator;
        }

        public boolean requires3PhaseMixing() {
            return this.mRequires3PhaseMixing;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static PLL fromFrequency(long frequency) {
            for (PLL pll : PLL.values()) {
                if (frequency >= pll.getFrequency()) continue;
                return pll;
            }
            return PLL_72M4;
        }

        public static PLL fromSetting(int setting) {
            int value = setting & 0xF;
            for (PLL pll : PLL.values()) {
                if (value != pll.getIndex()) continue;
                return pll;
            }
            return PLL_72M4;
        }
    }

    public static enum AGCMode {
        SERIAL(0),
        IF_PWM_LNA_SERIAL(1),
        IF_PWM_LNA_AUTONL(2),
        IF_PWM_LNA_SUPERV(3),
        IF_SERIAL_LNA_PWM(4),
        IF_PWM_LNA_PWM(5),
        IF_DIG_LNA_SERIAL(6),
        IF_DIG_LNA_AUTON(7),
        IF_DIG_LNA_SUPERV(8),
        IF_SERIAL_LNA_AUTON(9),
        IF_SERIAL_LNA_SUPERV(10);

        private byte mValue;

        private AGCMode(byte value) {
            this.mValue = value;
        }

        public byte getValue() {
            return this.mValue;
        }
    }

    public static enum E4KEnhanceGain {
        AUTOMATIC(0, "Auto"),
        GAIN_1(1, "10 db"),
        GAIN_3(3, "30 db"),
        GAIN_5(5, "50 db"),
        GAIN_7(7, "70 db");

        private int mValue;
        private String mLabel;

        private E4KEnhanceGain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.AGC11;
        }

        public static byte getMask() {
            return 7;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static E4KEnhanceGain fromRegisterValue(int registerValue) {
            int value = registerValue & E4KEnhanceGain.getMask();
            for (E4KEnhanceGain setting : E4KEnhanceGain.values()) {
                if (value != setting.getValue()) continue;
                return setting;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized Enhance Gain value [" + value + "]");
        }
    }

    public static enum IFStage1Gain {
        GAIN_MINUS3(0, "-3 db"),
        GAIN_PLUS6(1, "6 db");

        private int mValue;
        private String mLabel;

        private IFStage1Gain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN3;
        }

        public byte getMask() {
            return 1;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }
    }

    public static enum FrequencyBand {
        VHF2(0),
        VHF3(2),
        UHF(4),
        L_BAND(6);

        private int mValue;

        private FrequencyBand(int value) {
            this.mValue = value;
        }

        public static byte getMask() {
            return 6;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.toString();
        }

        public static FrequencyBand fromFrequency(long frequency) {
            if (frequency < 140000000L) {
                return VHF2;
            }
            if (frequency < 350000000L) {
                return VHF3;
            }
            if (frequency < 1135000000L) {
                return UHF;
            }
            return L_BAND;
        }
    }

    public static enum RFFilter {
        NO_FILTER(0, 0L, 0L),
        LP268(0, 52000000L, 86000000L),
        LP299(8, 86000000L, 140000000L),
        LP509(0, 140000000L, 245000000L),
        LP656(8, 245000000L, 350000000L),
        BP360(0, 350000000L, 370000000L),
        BP380(1, 370000000L, 392500000L),
        BP405(2, 392500000L, 417500000L),
        BP425(3, 417500000L, 437500000L),
        BP450(4, 437500000L, 462500000L),
        BP475(5, 462500000L, 490000000L),
        BP505(6, 490000000L, 522500000L),
        BP540(7, 522500000L, 557500000L),
        BP575(8, 557500000L, 595000000L),
        BP615(9, 595000000L, 642500000L),
        BP670(10, 642500000L, 695000000L),
        BP720(11, 695000000L, 740000000L),
        BP760(12, 740000000L, 800000000L),
        BP840(13, 800000000L, 865000000L),
        BP890(14, 865000000L, 930000000L),
        BP970(15, 930000000L, 1135000000L),
        BP1300(0, 1135000000L, 1310000000L),
        BP1320(1, 1310000000L, 1340000000L),
        BP1360(2, 1340000000L, 1385000000L),
        BP1410(3, 1385000000L, 1427500000L),
        BP1445(4, 1427500000L, 1452500000L),
        BP1460(5, 1452500000L, 1475000000L),
        BP1490(6, 1475000000L, 1510000000L),
        BP1530(7, 1510000000L, 1545000000L),
        BP1560(8, 1545000000L, 1575000000L),
        BP1590(9, 1575000000L, 1615000000L),
        BP1640(10, 1615000000L, 1650000000L),
        BP1660(11, 1650000000L, 1670000000L),
        BP1680(12, 1670000000L, 1690000000L),
        BP1700(13, 1690000000L, 1710000000L),
        BP1720(14, 1710000000L, 1735000000L),
        BP1750(15, 1735000000L, 2200000000L);

        private int mValue;
        private long mMinFrequency;
        private long mMaxFrequency;
        public static EnumSet<RFFilter> VHFII_FILTERS;
        public static EnumSet<RFFilter> VHFIII_FILTERS;
        public static EnumSet<RFFilter> UHF_FILTERS;
        public static EnumSet<RFFilter> LBAND_FILTERS;

        private RFFilter(int value, long minFrequency, long maxFrequency) {
            this.mValue = value;
            this.mMinFrequency = minFrequency;
            this.mMaxFrequency = maxFrequency;
        }

        public static Register getRegister() {
            return Register.FILT1;
        }

        public static byte getMask() {
            return 15;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public long getMinimumFrequency() {
            return this.mMinFrequency;
        }

        public long getMaximumFrequency() {
            return this.mMaxFrequency;
        }

        public static RFFilter fromFrequency(long frequency) {
            switch (FrequencyBand.fromFrequency(frequency)) {
                case VHF2: {
                    for (RFFilter filter : VHFII_FILTERS) {
                        if (filter.getMinimumFrequency() > frequency || frequency >= filter.getMaximumFrequency()) continue;
                        return filter;
                    }
                    break;
                }
                case VHF3: {
                    for (RFFilter filter : VHFIII_FILTERS) {
                        if (filter.getMinimumFrequency() > frequency || frequency >= filter.getMaximumFrequency()) continue;
                        return filter;
                    }
                    break;
                }
                case UHF: {
                    for (RFFilter filter : UHF_FILTERS) {
                        if (filter.getMinimumFrequency() > frequency || frequency >= filter.getMaximumFrequency()) continue;
                        return filter;
                    }
                    break;
                }
                default: {
                    for (RFFilter filter : LBAND_FILTERS) {
                        if (filter.getMinimumFrequency() > frequency || frequency >= filter.getMaximumFrequency()) continue;
                        return filter;
                    }
                }
            }
            return NO_FILTER;
        }

        static {
            VHFII_FILTERS = EnumSet.of(LP268, LP299);
            VHFIII_FILTERS = EnumSet.of(LP509, LP656);
            UHF_FILTERS = EnumSet.range(BP360, BP970);
            LBAND_FILTERS = EnumSet.of(BP1300, BP1750);
        }
    }

    public static enum IFFilter {
        MIX("Mix"),
        CHAN("Channel"),
        RC("RC");

        private String mLabel;

        private IFFilter(String label) {
            this.mLabel = label;
        }

        public String getLabel() {
            return this.mLabel;
        }
    }

    public static enum IFStage6Gain {
        GAIN_PLUS3(0, "3 db"),
        GAIN_PLUS6(8, "6 db"),
        GAIN_PLUS9(16, "9 db"),
        GAIN_PLUS12(24, "12 db"),
        GAIN_PLUS15A(32, "15 db"),
        GAIN_PLUS15B(40, "15 db"),
        GAIN_PLUS15C(48, "15 db"),
        GAIN_PLUS15D(56, "15 db");

        private int mValue;
        private String mLabel;

        private IFStage6Gain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN4;
        }

        public static byte getMask() {
            return 56;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static IFStage6Gain fromRegisterValue(int registerValue) {
            int value = registerValue & IFStage6Gain.getMask();
            for (IFStage6Gain setting : IFStage6Gain.values()) {
                if (value != setting.getValue()) continue;
                return setting;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized IF Gain Stage 6 value [" + value + "]");
        }
    }

    public static enum IFStage5Gain {
        GAIN_PLUS3(0, "3 db"),
        GAIN_PLUS6(1, "6 db"),
        GAIN_PLUS9(2, "9 db"),
        GAIN_PLUS12(3, "12 db"),
        GAIN_PLUS15A(4, "15 db"),
        GAIN_PLUS15B(5, "15 db"),
        GAIN_PLUS15C(6, "15 db"),
        GAIN_PLUS15D(7, "15 db");

        private int mValue;
        private String mLabel;

        private IFStage5Gain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN4;
        }

        public static byte getMask() {
            return 7;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static IFStage5Gain fromRegisterValue(int registerValue) {
            int value = registerValue & IFStage5Gain.getMask();
            for (IFStage5Gain setting : IFStage5Gain.values()) {
                if (value != setting.getValue()) continue;
                return setting;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized IF Gain Stage 5 value [" + value + "]");
        }
    }

    public static enum IFStage4Gain {
        GAIN_PLUS0(0, "0 db"),
        GAIN_PLUS1(32, "1 db"),
        GAIN_PLUS2A(64, "2 db"),
        GAIN_PLUS2B(96, "2 db");

        private int mValue;
        private String mLabel;

        private IFStage4Gain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN3;
        }

        public static byte getMask() {
            return 96;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static IFStage4Gain fromRegisterValue(int registerValue) {
            int value = registerValue & IFStage4Gain.getMask();
            for (IFStage4Gain setting : IFStage4Gain.values()) {
                if (value != setting.getValue()) continue;
                return setting;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized IF Gain Stage 4 value [" + value + "]");
        }
    }

    public static enum IFStage3Gain {
        GAIN_PLUS0(0, "0 db"),
        GAIN_PLUS3(8, "3 db"),
        GAIN_PLUS6(16, "6 db"),
        GAIN_PLUS9(48, "9 db");

        private int mValue;
        private String mLabel;

        private IFStage3Gain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN3;
        }

        public static byte getMask() {
            return 24;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static IFStage3Gain fromRegisterValue(int registerValue) {
            int value = registerValue & IFStage3Gain.getMask();
            for (IFStage3Gain setting : IFStage3Gain.values()) {
                if (value != setting.getValue()) continue;
                return setting;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized IF Gain Stage 3 value [" + value + "]");
        }
    }

    public static enum IFStage2Gain {
        GAIN_PLUS0(0, "0 db"),
        GAIN_PLUS3(2, "3 db"),
        GAIN_PLUS6(4, "6 db"),
        GAIN_PLUS9(6, "9 db");

        private int mValue;
        private String mLabel;

        private IFStage2Gain(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public static Register getRegister() {
            return Register.GAIN3;
        }

        public static byte getMask() {
            return 6;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static IFStage2Gain fromRegisterValue(int registerValue) {
            int value = registerValue & IFStage2Gain.getMask();
            for (IFStage2Gain setting : IFStage2Gain.values()) {
                if (value != setting.getValue()) continue;
                return setting;
            }
            throw new IllegalArgumentException("E4KTunerController - unrecognized IF Gain Stage 2 value [" + value + "]");
        }
    }

    public static enum DCGainCombination {
        LOOKUP_TABLE_0(Register.QLUT0, Register.ILUT0, E4KMixerGain.GAIN_4, IFStage1Gain.GAIN_MINUS3),
        LOOKUP_TABLE_1(Register.QLUT1, Register.ILUT1, E4KMixerGain.GAIN_4, IFStage1Gain.GAIN_PLUS6),
        LOOKUP_TABLE_2(Register.QLUT2, Register.ILUT2, E4KMixerGain.GAIN_12, IFStage1Gain.GAIN_MINUS3),
        LOOKUP_TABLE_3(Register.QLUT3, Register.ILUT3, E4KMixerGain.GAIN_12, IFStage1Gain.GAIN_PLUS6);

        private Register mQRegister;
        private Register mIRegister;
        private E4KMixerGain mMixerGain;
        private IFStage1Gain mIFStage1Gain;

        private DCGainCombination(Register qRegister, Register iRegister, E4KMixerGain mixer, IFStage1Gain stage1) {
            this.mQRegister = qRegister;
            this.mIRegister = iRegister;
            this.mMixerGain = mixer;
            this.mIFStage1Gain = stage1;
        }

        public Register getQRegister() {
            return this.mQRegister;
        }

        public Register getIRegister() {
            return this.mIRegister;
        }

        public E4KMixerGain getMixerGain() {
            return this.mMixerGain;
        }

        public IFStage1Gain getIFStage1Gain() {
            return this.mIFStage1Gain;
        }
    }
}

