/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.rtl;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.rtl.RTL2832Tuner;
import io.github.dsheirer.source.tuner.rtl.RTL2832TunerConfiguration;
import io.github.dsheirer.source.tuner.ui.TunerEditor;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class RTL2832UnknownTunerEditor
extends TunerEditor<RTL2832Tuner, RTL2832TunerConfiguration> {
    public RTL2832UnknownTunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
        this.init();
        this.tunerStatusUpdated();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[right][grow,fill][fill]", "[][][][][][][][][][][][][][][][grow]"));
        this.add(new JLabel("Tuner:"));
        this.add((Component)this.getTunerIdLabel(), "wrap");
        this.add(new JLabel("Status:"));
        this.add((Component)this.getTunerStatusLabel(), "wrap");
        this.add((Component)this.getButtonPanel(), "span,align left");
        this.add((Component)new JSeparator(), "span,growx,push");
    }

    @Override
    protected void save() {
    }

    @Override
    protected void tunerStatusUpdated() {
        this.setLoading(true);
        this.getTunerIdLabel().setText(this.getDiscoveredTuner().getId() + (String)(this.hasTuner() ? " ID:" + ((RTL2832Tuner)this.getTuner()).getUniqueID() : ""));
        Object status = this.getDiscoveredTuner().getTunerStatus().toString();
        if (this.getDiscoveredTuner().hasErrorMessage()) {
            status = (String)status + " - " + this.getDiscoveredTuner().getErrorMessage();
        }
        this.getTunerStatusLabel().setText((String)status);
        this.getButtonPanel().updateControls();
        this.setLoading(false);
    }

    @Override
    public void setTunerLockState(boolean locked) {
        this.getFrequencyPanel().updateControls();
    }
}

