/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.recording;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.TunerController;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.wave.ComplexWaveSource;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordingTunerController
extends TunerController {
    private static final Logger mLog = LoggerFactory.getLogger(RecordingTunerController.class);
    public static final int DC_NOISE_BANDWIDTH = 0;
    public static final double USABLE_BANDWIDTH_PERCENTAGE = 1.0;
    private ComplexWaveSource mComplexWaveSource;
    private String mPath;
    private long mCenterFrequency;
    private boolean mRunning;

    public RecordingTunerController(ITunerErrorListener tunerErrorListener, String path, long centerFrequency) {
        super(tunerErrorListener);
        this.mPath = path;
        this.mCenterFrequency = centerFrequency;
        if (this.mCenterFrequency == 0L) {
            this.mCenterFrequency = 100000000L;
        }
        this.setMinimumFrequency(1000000L);
        this.setMaximumFrequency(3000000000L);
        this.setMiddleUnusableHalfBandwidth(0);
        this.setUsableBandwidthPercentage(1.0);
    }

    @Override
    public void start() throws SourceException {
        if (this.mComplexWaveSource == null) {
            try {
                this.mComplexWaveSource = new ComplexWaveSource(new File(this.mPath), true);
            }
            catch (IOException ioe) {
                mLog.error("Error", (Throwable)ioe);
                this.setErrorMessage(ioe.getMessage() + " File:" + this.mPath);
                return;
            }
            this.mComplexWaveSource.setListener(complexSamples -> this.broadcast((INativeBuffer)complexSamples));
            try {
                this.mComplexWaveSource.open();
                this.mComplexWaveSource.start();
                mLog.info("Tuner Recording Loaded: " + this.mPath);
            }
            catch (IOException | UnsupportedAudioFileException e) {
                mLog.error("Error", (Throwable)e);
                this.setErrorMessage(e.getMessage() + " File:" + this.mPath);
                return;
            }
            try {
                this.mFrequencyController.setFrequency(this.mCenterFrequency);
                this.mFrequencyController.setSampleRate((int)this.mComplexWaveSource.getSampleRate());
                this.mFrequencyController.broadcast(SourceEvent.recordingFileLoaded());
            }
            catch (SourceException e) {
                mLog.error("Error", (Throwable)e);
                this.setErrorMessage(e.getMessage());
            }
        }
    }

    @Override
    public void stop() {
        if (this.mComplexWaveSource != null) {
            try {
                this.mComplexWaveSource.stop();
                this.mComplexWaveSource.close();
            }
            catch (IOException ioe) {
                mLog.error("Ignoring - error stopping baseband recording playback - " + ioe.getLocalizedMessage());
            }
            this.mComplexWaveSource = null;
        }
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.RECORDING;
    }

    @Override
    public int getBufferSampleCount() {
        if (this.mComplexWaveSource != null) {
            return this.mComplexWaveSource.getBufferSampleCount();
        }
        return 0;
    }

    @Override
    public void setFrequency(long frequency) throws SourceException {
    }

    @Override
    public long getTunedFrequency() throws SourceException {
        return this.mCenterFrequency;
    }

    @Override
    public void setTunedFrequency(long frequency) throws SourceException {
        this.mCenterFrequency = frequency;
    }

    @Override
    public double getCurrentSampleRate() {
        if (this.mComplexWaveSource != null) {
            return this.mComplexWaveSource.getSampleRate();
        }
        return 0.0;
    }
}

