/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.recording;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.properties.SystemProperties;
import io.github.dsheirer.source.tuner.configuration.TunerConfigurationManager;
import io.github.dsheirer.source.tuner.manager.DiscoveredRecordingTuner;
import io.github.dsheirer.source.tuner.recording.RecordingTunerConfiguration;
import io.github.dsheirer.source.tuner.ui.DiscoveredTunerModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRecordingTunerDialog
extends JFrame {
    private static final Logger mLog = LoggerFactory.getLogger(AddRecordingTunerDialog.class);
    private static final String SELECT_A_FILE = "Please select a recording file";
    private static final String LAST_FILE_BROWSE_LOCATION_KEY = "AddRecordingTunerDialog.lastBrowseLocation";
    private UserPreferences mUserPreferences;
    private DiscoveredTunerModel mDiscoveredTunerModel;
    private TunerConfigurationManager mTunerConfigurationManager;
    private JButton mSelectFileButton;
    private File mSelectedRecording;
    private JLabel mRecordingFileLabel;
    private JLabel mFrequencyLabel;
    private JTextField mFrequencyTextField;
    private JButton mAddButton;
    private JButton mCancelButton;
    private static final Pattern TUNER_RECORDING_PATTERN = Pattern.compile(".*_(\\d*)_baseband_\\d{8}_\\d{6}\\.wav");

    public AddRecordingTunerDialog(UserPreferences userPreferences, DiscoveredTunerModel discoveredTunerModel, TunerConfigurationManager tunerConfigurationManager) {
        Validate.notNull((Object)userPreferences, (String)"UserPreferences cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)discoveredTunerModel, (String)"TunerModel cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)tunerConfigurationManager, (String)"TunerConfigurationManager cannot be null", (Object[])new Object[0]);
        this.mDiscoveredTunerModel = discoveredTunerModel;
        this.mUserPreferences = userPreferences;
        this.mTunerConfigurationManager = tunerConfigurationManager;
        this.setDefaultCloseOperation(2);
        this.setTitle("Select Recording File");
        this.setSize(new Dimension(500, 250));
        JPanel content = new JPanel();
        content.setLayout((LayoutManager)new MigLayout("", "[align right][][]", "[][][grow][]"));
        this.mSelectFileButton = new JButton("Select ...");
        this.mSelectFileButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            String lastBrowsedDirectory = SystemProperties.getInstance().get(LAST_FILE_BROWSE_LOCATION_KEY, "");
            File browseDirectory = lastBrowsedDirectory != null && !lastBrowsedDirectory.isEmpty() ? new File(lastBrowsedDirectory) : this.mUserPreferences.getDirectoryPreference().getDefaultRecordingDirectory().toFile();
            fileChooser.setCurrentDirectory(browseDirectory);
            fileChooser.setFileSelectionMode(0);
            fileChooser.setFileFilter(new FileFilter(this){

                @Override
                public boolean accept(File f) {
                    return f.getAbsolutePath().endsWith(".wav") || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "Recordings (*.wav)";
                }
            });
            int returnVal = fileChooser.showOpenDialog(this);
            File lastDirectory = fileChooser.getCurrentDirectory();
            if (lastDirectory != null) {
                SystemProperties.getInstance().set(LAST_FILE_BROWSE_LOCATION_KEY, lastDirectory.getAbsolutePath());
            }
            if (returnVal == 0) {
                Matcher m;
                this.mSelectedRecording = fileChooser.getSelectedFile();
                this.mAddButton.setEnabled(this.mSelectedRecording != null);
                if (this.mSelectedRecording != null && (this.mFrequencyTextField.getText() == null || this.mFrequencyTextField.getText().isEmpty()) && (m = TUNER_RECORDING_PATTERN.matcher(this.mSelectedRecording.getName())).matches()) {
                    this.mFrequencyTextField.setText(m.group(1));
                }
            } else {
                this.mSelectedRecording = null;
            }
            this.mRecordingFileLabel.setText(this.mSelectedRecording != null ? this.mSelectedRecording.getName() : SELECT_A_FILE);
        });
        content.add(this.mSelectFileButton);
        this.mRecordingFileLabel = new JLabel(SELECT_A_FILE);
        content.add((Component)this.mRecordingFileLabel, "span 2,wrap");
        this.mFrequencyLabel = new JLabel("Frequency (Hz):");
        content.add(this.mFrequencyLabel);
        this.mFrequencyTextField = new JTextField("");
        this.mFrequencyTextField.setToolTipText("Center frequency for the recording in Hertz (Hz)");
        content.add((Component)this.mFrequencyTextField, "span 2,grow,wrap");
        content.add((Component)new JLabel(""), "wrap");
        content.add(new JLabel(""));
        this.mAddButton = new JButton("Add");
        this.mAddButton.setEnabled(false);
        this.mAddButton.addActionListener(e -> {
            if (this.mSelectedRecording == null) {
                JOptionPane.showMessageDialog(this, SELECT_A_FILE, "Select a Recording File", 0);
                return;
            }
            long frequency = this.getFrequency();
            if (frequency <= 0L || frequency > Integer.MAX_VALUE) {
                JOptionPane.showMessageDialog(this, "Please provide a recording center frequency (1 Hz to 2.14 GHz)", "Center Frequency Required", 0);
                return;
            }
            mLog.info("Adding recording tuner = frequency [" + frequency + "] recording [" + this.mSelectedRecording.getAbsolutePath() + "]");
            try {
                RecordingTunerConfiguration config = RecordingTunerConfiguration.create();
                config.setFrequency(frequency);
                config.setPath(this.mSelectedRecording.getAbsolutePath());
                this.mTunerConfigurationManager.addTunerConfiguration(config);
                DiscoveredRecordingTuner discoveredRecordingTuner = new DiscoveredRecordingTuner(this.mUserPreferences, config);
                this.mDiscoveredTunerModel.addDiscoveredTuner(discoveredRecordingTuner);
            }
            catch (Exception ex) {
                mLog.error("Error adding recording tuner", (Throwable)ex);
            }
            this.setVisible(false);
        });
        content.add((Component)this.mAddButton, "grow,push");
        this.mCancelButton = new JButton("Cancel");
        this.mCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRecordingTunerDialog.this.setVisible(false);
            }
        });
        content.add((Component)this.mCancelButton, "grow,push");
        this.setContentPane(content);
    }

    private long getFrequency() {
        String text = this.mFrequencyTextField.getText();
        if (text != null && !text.isEmpty()) {
            try {
                return Long.parseLong(text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }
}

