/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.manager;

import io.github.dsheirer.dsp.filter.channelizer.PolyphaseChannelManager;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.TunerController;
import io.github.dsheirer.source.tuner.channel.ChannelSpecification;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import io.github.dsheirer.source.tuner.channel.TunerChannelSource;
import io.github.dsheirer.source.tuner.manager.ChannelSourceManager;
import java.util.SortedSet;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyphaseChannelSourceManager
extends ChannelSourceManager {
    private static final Logger mLog = LoggerFactory.getLogger(PolyphaseChannelSourceManager.class);
    private PolyphaseChannelManager mPolyphaseChannelManager;
    private TunerController mTunerController;

    public PolyphaseChannelSourceManager(TunerController tunerController) {
        this.mTunerController = tunerController;
        this.mPolyphaseChannelManager = new PolyphaseChannelManager(tunerController);
        this.mPolyphaseChannelManager.addSourceEventListener(this::process);
        this.mTunerController.addListener(this.mPolyphaseChannelManager);
    }

    @Override
    public String getStateDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Polyphase Channel Source Manager");
        sb.append("\n\tTuner Controller Frequency: ").append(this.mTunerController.getFrequency());
        sb.append("\n\t").append(this.mPolyphaseChannelManager.getStateDescription());
        return sb.toString();
    }

    @Override
    public void stopAllChannels() {
        this.mPolyphaseChannelManager.stopAllChannels();
    }

    private boolean isTunable(TunerChannel tunerChannel) {
        return this.mTunerController.canTune(tunerChannel.getMinFrequency()) && this.mTunerController.canTune(tunerChannel.getMaxFrequency());
    }

    private boolean canTune(SortedSet<TunerChannel> tunerChannels) {
        if (tunerChannels.size() == 1) {
            if (this.mTunerController.hasMiddleUnusableBandwidth()) {
                return tunerChannels.first().getBandwidth() < this.mTunerController.getUsableHalfBandwidth();
            }
            return tunerChannels.first().getBandwidth() < this.mTunerController.getUsableBandwidth();
        }
        int tunerUsableBandwidth = this.mTunerController.getUsableBandwidth();
        long channelSetBandwidth = tunerChannels.last().getMaxFrequency() - tunerChannels.first().getMinFrequency();
        if (channelSetBandwidth <= (long)tunerUsableBandwidth) {
            if (!this.mTunerController.hasMiddleUnusableBandwidth()) {
                return true;
            }
            int tunerUsableHalfBandwidth = this.mTunerController.getUsableHalfBandwidth();
            if (channelSetBandwidth < (long)tunerUsableHalfBandwidth) {
                return true;
            }
            TunerChannel firstRightChannel = null;
            for (TunerChannel tunerChannel : tunerChannels) {
                if (firstRightChannel == null) {
                    long leftSideBandwidth = tunerChannel.getMaxFrequency() - tunerChannels.first().getMinFrequency();
                    if (leftSideBandwidth <= (long)tunerUsableHalfBandwidth) continue;
                    if (tunerChannel.getBandwidth() > tunerUsableHalfBandwidth) {
                        return false;
                    }
                    firstRightChannel = tunerChannel;
                    continue;
                }
                long rightSideBandwidth = tunerChannel.getMaxFrequency() - firstRightChannel.getMinFrequency();
                if (rightSideBandwidth <= (long)tunerUsableHalfBandwidth) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected long getCenterFrequency(SortedSet<TunerChannel> channels, long currentCenterFrequency) throws IllegalArgumentException {
        long testFrequency;
        if (channels.isEmpty()) {
            return currentCenterFrequency;
        }
        long channelSetBandwidth = this.getChannelSetBandwidth(channels);
        if (channelSetBandwidth > (long)this.mTunerController.getUsableBandwidth()) {
            throw new IllegalArgumentException("Channel set bandwidth is greater than tuner's available bandwidth");
        }
        long bestIntegralFrequency = this.getIntegralFrequency(channels);
        if (this.isIntegralSpacing(currentCenterFrequency, bestIntegralFrequency) && this.isValidCenterFrequency(channels, currentCenterFrequency)) {
            return currentCenterFrequency;
        }
        double usableHalfBandwidth = this.mTunerController.getUsableHalfBandwidth();
        long start = channels.first().getFrequency() - (long)((int)this.mPolyphaseChannelManager.getChannelBandwidth());
        if (this.isValidCenterFrequency(channels, start)) {
            return start;
        }
        while ((double)(start - channels.first().getMinFrequency()) < usableHalfBandwidth) {
            if (!this.isValidCenterFrequency(channels, start += (long)((int)this.mPolyphaseChannelManager.getChannelBandwidth()))) continue;
            return start;
        }
        double startFrequency = (double)channels.first().getMinFrequency() + usableHalfBandwidth;
        double delta = FastMath.abs((double)(startFrequency - (double)bestIntegralFrequency));
        double adjustment = delta % this.mPolyphaseChannelManager.getChannelBandwidth();
        long availableTestBandwidth = (long)this.mTunerController.getUsableBandwidth() - channelSetBandwidth;
        int availableTestChannels = (int)((double)availableTestBandwidth / this.mPolyphaseChannelManager.getChannelBandwidth()) + 1;
        if (this.isValidCenterFrequency(channels, (long)(startFrequency += adjustment))) {
            return (long)startFrequency;
        }
        for (int currentChannel = 1; currentChannel <= availableTestChannels; ++currentChannel) {
            testFrequency = (long)(startFrequency - (double)currentChannel * this.mPolyphaseChannelManager.getChannelBandwidth());
            if (!this.isValidCenterFrequency(channels, testFrequency)) continue;
            return testFrequency;
        }
        testFrequency = channels.first().getMinFrequency() + (long)this.mTunerController.getUsableHalfBandwidth();
        long minimumFrequency = testFrequency - availableTestBandwidth;
        if (this.isValidCenterFrequency(channels, testFrequency)) {
            return testFrequency;
        }
        while (testFrequency >= minimumFrequency) {
            if (!this.isValidCenterFrequency(channels, --testFrequency)) continue;
            return testFrequency;
        }
        throw new IllegalArgumentException("Can't calculate valid center frequency for the channel set");
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        if (this.mPolyphaseChannelManager != null) {
            this.mPolyphaseChannelManager.setErrorMessage(errorMessage);
        }
    }

    private long getChannelSetBandwidth(SortedSet<TunerChannel> channels) {
        return channels.last().getMaxFrequency() - channels.first().getMinFrequency();
    }

    private boolean isValidCenterFrequency(SortedSet<TunerChannel> tunerChannels, long centerFrequency) {
        for (TunerChannel tunerChannel : tunerChannels) {
            if (this.isValidCenterFrequency(tunerChannel, centerFrequency)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidCenterFrequency(TunerChannel tunerChannel, long centerFrequency) {
        boolean fits;
        boolean bl = fits = tunerChannel.getMinFrequency() >= centerFrequency - (long)this.mTunerController.getUsableHalfBandwidth() && tunerChannel.getMaxFrequency() <= centerFrequency + (long)this.mTunerController.getUsableHalfBandwidth();
        if (fits && this.mTunerController.hasMiddleUnusableBandwidth()) {
            fits = !tunerChannel.overlaps(centerFrequency - (long)this.mTunerController.getMiddleUnusableHalfBandwidth(), centerFrequency + (long)this.mTunerController.getMiddleUnusableHalfBandwidth());
        }
        return fits;
    }

    private boolean isIntegralSpacing(long frequencyA, long frequencyB) {
        double delta = FastMath.abs((long)(frequencyA - frequencyB));
        return delta % this.mPolyphaseChannelManager.getChannelBandwidth() <= 1.0;
    }

    private long getIntegralFrequency(SortedSet<TunerChannel> channels) {
        if (channels.isEmpty()) {
            throw new IllegalArgumentException("Channels cannot be empty");
        }
        long bestIntegralFrequency = channels.first().getFrequency();
        if (channels.size() > 1) {
            double bestScore = Double.MAX_VALUE;
            for (TunerChannel firstChannel : channels) {
                double score = 0.0;
                for (TunerChannel secondChannel : channels) {
                    if (firstChannel == secondChannel) continue;
                    double delta = (double)FastMath.abs((long)(firstChannel.getFrequency() - secondChannel.getFrequency())) % this.mPolyphaseChannelManager.getChannelBandwidth();
                    score += delta;
                }
                if (!(score < bestScore)) continue;
                bestScore = score;
                bestIntegralFrequency = firstChannel.getFrequency();
            }
        }
        return bestIntegralFrequency;
    }

    @Override
    public SortedSet<TunerChannel> getTunerChannels() {
        return this.mPolyphaseChannelManager.getTunerChannels();
    }

    @Override
    public int getTunerChannelCount() {
        return this.mPolyphaseChannelManager.getTunerChannelCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TunerChannelSource getSource(TunerChannel tunerChannel, ChannelSpecification channelSpecification) {
        TunerChannelSource tunerChannelSource = null;
        try {
            this.mTunerController.getFrequencyControllerLock().lock();
            if (this.isTunable(tunerChannel)) {
                SortedSet<TunerChannel> tunerChannels = this.getTunerChannels();
                tunerChannels.add(tunerChannel);
                if (this.canTune(tunerChannels)) {
                    long currentCenterFrequency = this.mTunerController.getFrequency();
                    long updatedCenterFrequency = 0L;
                    try {
                        updatedCenterFrequency = this.getCenterFrequency(tunerChannels, currentCenterFrequency);
                        if (updatedCenterFrequency != currentCenterFrequency && updatedCenterFrequency != 0L) {
                            this.mTunerController.setFrequency(updatedCenterFrequency);
                        }
                        tunerChannelSource = this.mPolyphaseChannelManager.getChannel(tunerChannel);
                    }
                    catch (SourceException se) {
                        mLog.error("Error while updating tuner controller with new center frequency [" + updatedCenterFrequency + "] - unable to allocate new tuner channel", (Throwable)se);
                    }
                    catch (IllegalArgumentException iae) {
                        mLog.error("Center frequency calculation failed", (Throwable)iae);
                    }
                    catch (Exception e) {
                        mLog.error("Error getting source", (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.mTunerController.getFrequencyControllerLock().unlock();
        }
        return tunerChannelSource;
    }

    @Override
    public void process(SourceEvent sourceEvent) {
        switch (sourceEvent.getEvent()) {
            case NOTIFICATION_CHANNEL_COUNT_CHANGE: {
                this.broadcast(sourceEvent);
                this.mTunerController.setLockedSampleRate(this.getTunerChannelCount() > 0);
                break;
            }
            case NOTIFICATION_MEASURED_FREQUENCY_ERROR_SYNC_LOCKED: {
                this.broadcast(sourceEvent);
                break;
            }
            default: {
                mLog.info("Unrecognized source event: " + String.valueOf(sourceEvent));
            }
        }
    }
}

