/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.manager;

import io.github.dsheirer.controller.channel.event.ChannelStopProcessingRequest;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.TunerController;
import io.github.dsheirer.source.tuner.channel.ChannelSpecification;
import io.github.dsheirer.source.tuner.channel.PassThroughChannelSource;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import io.github.dsheirer.source.tuner.channel.TunerChannelSource;
import io.github.dsheirer.source.tuner.manager.ChannelSourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassThroughSourceManager
extends ChannelSourceManager {
    private static final Logger mLog = LoggerFactory.getLogger(PassThroughSourceManager.class);
    private TunerController mTunerController;
    private SortedSet<TunerChannel> mTunerChannels = new TreeSet<TunerChannel>();
    private List<TunerChannelSource> mTunerChannelSources = new CopyOnWriteArrayList<TunerChannelSource>();
    private boolean mRunning = true;

    public PassThroughSourceManager(TunerController tunerController) {
        this.mTunerController = tunerController;
    }

    @Override
    public String getStateDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Pass-Through Channel Source Manager Providing [").append(this.mTunerChannels.size()).append("] Channels");
        for (TunerChannel channel : this.mTunerChannels) {
            sb.append("\n\tChannel: ").append(channel);
        }
        return sb.toString();
    }

    @Override
    public void stopAllChannels() {
        this.mRunning = false;
        ArrayList<TunerChannelSource> toStop = new ArrayList<TunerChannelSource>(this.mTunerChannelSources);
        for (TunerChannelSource tunerChannelSource : toStop) {
            MyEventBus.getGlobalEventBus().post((Object)new ChannelStopProcessingRequest(tunerChannelSource));
        }
    }

    @Override
    public SortedSet<TunerChannel> getTunerChannels() {
        return this.mTunerChannels;
    }

    @Override
    public int getTunerChannelCount() {
        return this.mTunerChannels.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TunerChannelSource getSource(TunerChannel tunerChannel, ChannelSpecification channelSpecification) {
        if (!this.mRunning) {
            return null;
        }
        PassThroughChannelSource source = null;
        try {
            this.mTunerController.getFrequencyControllerLock().lock();
            PassThroughChannelSource channelSource = new PassThroughChannelSource(new SourceEventProxy(), this.mTunerController, tunerChannel);
            this.mTunerChannels.add(tunerChannel);
            this.mTunerChannelSources.add(channelSource);
            source = channelSource;
        }
        finally {
            this.mTunerController.getFrequencyControllerLock().unlock();
        }
        return source;
    }

    @Override
    public void process(SourceEvent event) throws SourceException {
        switch (event.getEvent()) {
            case REQUEST_START_SAMPLE_STREAM: {
                if (!event.hasSource() || !(event.getSource() instanceof PassThroughChannelSource)) break;
                this.mTunerController.addBufferListener((PassThroughChannelSource)event.getSource());
                this.broadcast(SourceEvent.channelCountChange(this.mTunerChannels.size()));
                break;
            }
            case REQUEST_STOP_SAMPLE_STREAM: {
                if (!event.hasSource() || !(event.getSource() instanceof PassThroughChannelSource)) break;
                PassThroughChannelSource source = (PassThroughChannelSource)event.getSource();
                this.mTunerController.removeBufferListener(source);
                this.mTunerChannels.remove(source.getTunerChannel());
                this.mTunerChannelSources.remove(source);
                this.broadcast(SourceEvent.channelCountChange(this.mTunerChannels.size()));
            }
        }
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        for (TunerChannelSource tunerChannelSource : this.mTunerChannelSources) {
            tunerChannelSource.setError(errorMessage);
        }
    }

    public class SourceEventProxy
    implements Listener<SourceEvent> {
        @Override
        public void receive(SourceEvent sourceEvent) {
            try {
                PassThroughSourceManager.this.process(sourceEvent);
            }
            catch (SourceException se) {
                mLog.error("Error", (Throwable)se);
            }
        }
    }
}

