/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.manager;

import io.github.dsheirer.buffer.NativeSampleDelayBuffer;
import io.github.dsheirer.controller.channel.event.ChannelStopProcessingRequest;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.Source;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.TunerController;
import io.github.dsheirer.source.tuner.channel.ChannelSpecification;
import io.github.dsheirer.source.tuner.channel.HalfBandTunerChannelSource;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import io.github.dsheirer.source.tuner.channel.TunerChannelSource;
import io.github.dsheirer.source.tuner.manager.CenterFrequencyCalculator;
import io.github.dsheirer.source.tuner.manager.ChannelSourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeterodyneChannelSourceManager
extends ChannelSourceManager {
    private static final Logger mLog = LoggerFactory.getLogger(HeterodyneChannelSourceManager.class);
    private static final int DELAY_BUFFER_DURATION_MILLISECONDS = 2000;
    private List<HalfBandTunerChannelSource> mChannelSources = new CopyOnWriteArrayList<HalfBandTunerChannelSource>();
    private SortedSet<TunerChannel> mTunerChannels = new TreeSet<TunerChannel>();
    private TunerController mTunerController;
    private ChannelSourceEventProcessor mChannelSourceEventProcessor = new ChannelSourceEventProcessor();
    private NativeSampleDelayBuffer mSampleDelayBuffer;
    private boolean mRunning = true;

    public HeterodyneChannelSourceManager(TunerController tunerController) {
        this.mTunerController = tunerController;
        this.mTunerController.addListener(this);
    }

    @Override
    public String getStateDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Heterodyne Channel Source Manager Providing [").append(this.mTunerChannels.size()).append("] Channels");
        sb.append("\n\tTuner Controller Frequency: ").append(this.mTunerController.getFrequency());
        for (HalfBandTunerChannelSource channelSource : this.mChannelSources) {
            sb.append("\n\tChannel [").append(channelSource.getTunerChannel()).append("] Frequency [").append(channelSource.getFrequency()).append("] Mixer [").append(channelSource.getMixerFrequency()).append("]");
        }
        return sb.toString();
    }

    @Override
    public void stopAllChannels() {
        this.mRunning = false;
        ArrayList<HalfBandTunerChannelSource> toStop = new ArrayList<HalfBandTunerChannelSource>(this.mChannelSources);
        for (TunerChannelSource tunerChannelSource : toStop) {
            MyEventBus.getGlobalEventBus().post((Object)new ChannelStopProcessingRequest(tunerChannelSource));
        }
    }

    @Override
    public SortedSet<TunerChannel> getTunerChannels() {
        return this.mTunerChannels;
    }

    @Override
    public int getTunerChannelCount() {
        return this.mTunerChannels.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TunerChannelSource getSource(TunerChannel tunerChannel, ChannelSpecification channelSpecification) {
        if (!this.mRunning) {
            return null;
        }
        HalfBandTunerChannelSource source = null;
        try {
            this.mTunerController.getFrequencyControllerLock().lock();
            if (CenterFrequencyCalculator.canTune(tunerChannel, this.mTunerController, this.mTunerChannels)) {
                try {
                    HalfBandTunerChannelSource tunerChannelSource = new HalfBandTunerChannelSource(this.mChannelSourceEventProcessor, tunerChannel, this.mTunerController.getSampleRate(), channelSpecification);
                    this.mChannelSources.add(tunerChannelSource);
                    tunerChannelSource.setFrequency(this.mTunerController.getFrequency());
                    this.mTunerChannels.add(tunerChannel);
                    this.updateTunerFrequency();
                    this.mTunerController.setLockedSampleRate(true);
                    this.broadcast(SourceEvent.channelCountChange(this.getTunerChannelCount()));
                    source = tunerChannelSource;
                }
                catch (FilterDesignException fde) {
                    mLog.error("Error creating CIC tuner channel source - couldn't design cleanup filter", (Throwable)fde);
                }
            }
        }
        finally {
            this.mTunerController.getFrequencyControllerLock().unlock();
        }
        return source;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        for (TunerChannelSource tunerChannelSource : this.mChannelSources) {
            tunerChannelSource.setError(errorMessage);
        }
    }

    private void updateTunerFrequency() {
        if (!this.mTunerController.isTunedFor(this.getTunerChannels())) {
            long centerFrequency = CenterFrequencyCalculator.getCenterFrequency(this.mTunerController, this.getTunerChannels());
            if (centerFrequency == -1L) {
                mLog.error("Couldn't calculate center frequency for tuner and tuner channels");
                return;
            }
            if (centerFrequency != this.mTunerController.getFrequency()) {
                try {
                    this.mTunerController.setFrequency(centerFrequency);
                }
                catch (SourceException se) {
                    mLog.error("Couldn't update tuner center frequency to " + centerFrequency, (Throwable)se);
                }
            }
        }
    }

    @Override
    public void process(SourceEvent tunerSourceEvent) throws SourceException {
        switch (tunerSourceEvent.getEvent()) {
            case NOTIFICATION_FREQUENCY_CHANGE: {
                this.updateTunerFrequency(tunerSourceEvent.getValue().longValue());
                if (this.mSampleDelayBuffer == null) break;
                this.mSampleDelayBuffer.clear();
                break;
            }
            case NOTIFICATION_FREQUENCY_CORRECTION_CHANGE: {
                this.broadcastToChannels(tunerSourceEvent);
                break;
            }
            case NOTIFICATION_SAMPLE_RATE_CHANGE: 
            case NOTIFICATION_FREQUENCY_AND_SAMPLE_RATE_LOCKED: 
            case NOTIFICATION_FREQUENCY_AND_SAMPLE_RATE_UNLOCKED: {
                break;
            }
            default: {
                mLog.info("Unrecognized Source Event received from tuner: " + String.valueOf(tunerSourceEvent));
            }
        }
    }

    private void broadcastToChannels(SourceEvent sourceEvent) {
        for (HalfBandTunerChannelSource channelSource : this.mChannelSources) {
            try {
                channelSource.process(sourceEvent);
            }
            catch (Exception e) {
                mLog.error("Error broadcasting source event to channel: " + String.valueOf(sourceEvent));
            }
        }
    }

    private void updateTunerFrequency(long tunerFrequency) {
        for (HalfBandTunerChannelSource channelSource : this.mChannelSources) {
            channelSource.setFrequency(tunerFrequency);
        }
    }

    private void startDelayBuffer() {
        if (this.mSampleDelayBuffer == null) {
            long bufferDuration = this.mTunerController.getBufferDuration();
            if (bufferDuration <= 0L) {
                bufferDuration = 1L;
            }
            int delayBufferSize = (int)(2000L / bufferDuration);
            this.mSampleDelayBuffer = new NativeSampleDelayBuffer(delayBufferSize, this.mTunerController.getBufferDuration());
            this.mTunerController.addBufferListener(this.mSampleDelayBuffer);
        }
    }

    private void stopDelayBuffer() {
        if (this.mSampleDelayBuffer != null && !this.mSampleDelayBuffer.hasListeners()) {
            this.mTunerController.removeBufferListener(this.mSampleDelayBuffer);
            this.mSampleDelayBuffer.dispose();
            this.mSampleDelayBuffer = null;
        }
    }

    public class ChannelSourceEventProcessor
    implements Listener<SourceEvent> {
        @Override
        public void receive(SourceEvent sourceEvent) {
            switch (sourceEvent.getEvent()) {
                case REQUEST_START_SAMPLE_STREAM: {
                    if (!(sourceEvent.getSource() instanceof HalfBandTunerChannelSource)) break;
                    HeterodyneChannelSourceManager.this.startDelayBuffer();
                    HeterodyneChannelSourceManager.this.mSampleDelayBuffer.addListener((HalfBandTunerChannelSource)sourceEvent.getSource(), sourceEvent.getValue().longValue());
                    break;
                }
                case REQUEST_STOP_SAMPLE_STREAM: {
                    Source source = sourceEvent.getSource();
                    if (!(source instanceof HalfBandTunerChannelSource)) break;
                    HalfBandTunerChannelSource halfBandSource = (HalfBandTunerChannelSource)source;
                    HeterodyneChannelSourceManager.this.mSampleDelayBuffer.removeListener(halfBandSource);
                    HeterodyneChannelSourceManager.this.stopDelayBuffer();
                    HeterodyneChannelSourceManager.this.mChannelSources.remove(halfBandSource);
                    HeterodyneChannelSourceManager.this.mTunerChannels.remove(halfBandSource.getTunerChannel());
                    halfBandSource.dispose();
                    if (HeterodyneChannelSourceManager.this.getTunerChannelCount() == 0) {
                        HeterodyneChannelSourceManager.this.mTunerController.setLockedSampleRate(false);
                    }
                    HeterodyneChannelSourceManager.this.broadcast(SourceEvent.channelCountChange(HeterodyneChannelSourceManager.this.getTunerChannelCount()));
                    break;
                }
                case NOTIFICATION_MEASURED_FREQUENCY_ERROR_SYNC_LOCKED: {
                    HeterodyneChannelSourceManager.this.broadcast(sourceEvent);
                    break;
                }
                case NOTIFICATION_CHANNEL_COUNT_CHANGE: {
                    break;
                }
                default: {
                    mLog.info("Unrecognized Source Event received from channel: " + String.valueOf(sourceEvent));
                }
            }
        }
    }
}

