/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.manager;

import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.TunerController;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrequencyErrorCorrectionManager {
    private static final Logger mLog = LoggerFactory.getLogger(FrequencyErrorCorrectionManager.class);
    private static final double FREQUENCY_CORRECTION_ERROR_THRESHOLD = 0.4;
    private static final long AUTO_CORRECTION_OBSERVATION_PERIOD_MILLISECONDS = 30000L;
    private long mObservationPeriodStart;
    private double mPPMRequired;
    private boolean mEnabled = true;
    private DecimalFormat mDecimalFormat = new DecimalFormat("0.0");
    private TunerController mTunerController;

    public FrequencyErrorCorrectionManager(TunerController tunerController) {
        this.mTunerController = tunerController;
    }

    public void dispose() {
        this.setEnabled(false);
        this.mTunerController = null;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void reset() {
        this.mObservationPeriodStart = 0L;
        this.mPPMRequired = 0.0;
    }

    private void applyCorrection() {
        if (this.mEnabled && this.mTunerController != null && this.mTunerController.hasMeasuredFrequencyError()) {
            double frequencyCorrection = this.mTunerController.getFrequencyCorrection();
            frequencyCorrection -= this.mTunerController.getPPMFrequencyError();
            try {
                mLog.info("Auto-Correcting Tuner PPM to [" + this.mDecimalFormat.format(frequencyCorrection) + "]");
                this.mTunerController.setFrequencyCorrection(frequencyCorrection);
                this.reset();
            }
            catch (SourceException se) {
                mLog.error("Error while applying automatic frequency error PPM correction value: " + frequencyCorrection);
            }
        }
    }

    public void updatePPM(double ppm) {
        if (ppm > 0.4) {
            if (this.mObservationPeriodStart == 0L) {
                this.mObservationPeriodStart = System.currentTimeMillis();
                this.mPPMRequired = ppm;
            } else if (this.mPPMRequired > 0.0) {
                this.mPPMRequired = ppm;
                if (this.mObservationPeriodStart + 30000L < System.currentTimeMillis()) {
                    this.applyCorrection();
                }
            } else {
                this.mObservationPeriodStart = System.currentTimeMillis();
                this.mPPMRequired = ppm;
            }
        } else if (ppm < -0.4) {
            if (this.mObservationPeriodStart == 0L) {
                this.mObservationPeriodStart = System.currentTimeMillis();
                this.mPPMRequired = ppm;
            } else if (this.mPPMRequired < 0.0) {
                this.mPPMRequired = ppm;
                if (this.mObservationPeriodStart + 30000L < System.currentTimeMillis()) {
                    this.applyCorrection();
                }
            } else {
                this.mObservationPeriodStart = System.currentTimeMillis();
                this.mPPMRequired = ppm;
            }
        } else {
            this.reset();
        }
    }
}

