/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.manager;

import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.manager.IDiscoveredTunerStatusListener;
import io.github.dsheirer.source.tuner.manager.TunerStatus;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiscoveredTuner
implements ITunerErrorListener {
    private Logger mLog = LoggerFactory.getLogger(DiscoveredTuner.class);
    private TunerStatus mTunerStatus = TunerStatus.ENABLED;
    private boolean mEnabled = true;
    private String mErrorMessage;
    private List<IDiscoveredTunerStatusListener> mListeners = new CopyOnWriteArrayList<IDiscoveredTunerStatusListener>();
    protected Tuner mTuner;
    protected TunerConfiguration mTunerConfiguration;

    public abstract TunerClass getTunerClass();

    public TunerStatus getTunerStatus() {
        return this.mTunerStatus;
    }

    public void logState() {
        StringBuilder sb = new StringBuilder();
        sb.append("Discovered Tuner: ").append(this.getId());
        if (this.hasTuner()) {
            sb.append("\n\tTuner - Frequency:").append(this.getTuner().getTunerController().getFrequency());
            sb.append("\n\tChannel Manager:").append(this.getTuner().getChannelSourceManager().getStateDescription());
        } else {
            sb.append("\n\tTuner - no tuner");
        }
        this.mLog.info(sb.toString());
    }

    private void setTunerStatus(TunerStatus tunerStatus) {
        this.setTunerStatus(tunerStatus, true);
    }

    private void setTunerStatus(TunerStatus tunerStatus, boolean notifyListeners) {
        if (this.mTunerStatus != tunerStatus) {
            TunerStatus previous = this.mTunerStatus;
            this.mTunerStatus = tunerStatus;
            if (notifyListeners) {
                this.broadcast(this, previous, this.mTunerStatus);
            }
        }
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.mEnabled ^ enabled) {
            this.mErrorMessage = null;
            this.mEnabled = enabled;
            if (this.mEnabled) {
                this.start();
                this.setTunerStatus(TunerStatus.ENABLED);
            } else {
                this.stop();
                this.setTunerStatus(TunerStatus.DISABLED);
            }
        }
    }

    public boolean isAvailable() {
        return this.getTunerStatus().isAvailable();
    }

    public abstract String getId();

    public Tuner getTuner() {
        return this.mTuner;
    }

    public boolean hasTuner() {
        return this.getTuner() != null;
    }

    public TunerConfiguration getTunerConfiguration() {
        return this.mTunerConfiguration;
    }

    public void setTunerConfiguration(TunerConfiguration tunerConfiguration) {
        this.mTunerConfiguration = tunerConfiguration;
        if (this.hasTuner()) {
            try {
                this.getTuner().getTunerController().apply(this.mTunerConfiguration);
            }
            catch (SourceException se) {
                this.mLog.error("Error applying tuner configuration [" + String.valueOf(this.mTunerConfiguration.getClass()) + "] to discovered tuner [" + this.getId() + "}");
            }
        }
    }

    public boolean hasTunerConfiguration() {
        return this.mTunerConfiguration != null;
    }

    public void addTunerStatusListener(IDiscoveredTunerStatusListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeTunerStatusListener(IDiscoveredTunerStatusListener listener) {
        this.mListeners.remove(listener);
    }

    private void broadcast(DiscoveredTuner tuner, TunerStatus previous, TunerStatus current) {
        for (IDiscoveredTunerStatusListener listener : this.mListeners) {
            listener.tunerStatusUpdated(tuner, previous, current);
        }
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage;
        this.mLog.info("Tuner Error - Stopping - " + this.getId() + " Error: " + errorMessage);
        this.stop();
        this.setTunerStatus(TunerStatus.ERROR);
    }

    @Override
    public void tunerRemoved() {
        this.setTunerStatus(TunerStatus.REMOVED);
    }

    public boolean hasErrorMessage() {
        return this.mErrorMessage != null;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public abstract void start();

    public void restart() {
        if (this.getTunerStatus() == TunerStatus.ERROR) {
            this.mErrorMessage = null;
            if (this.isEnabled()) {
                this.setTunerStatus(TunerStatus.ENABLED);
                this.start();
            } else {
                this.setTunerStatus(TunerStatus.DISABLED);
            }
        }
    }

    public void stop() {
        if (this.hasTuner()) {
            this.mLog.info("Stopping Tuner: " + this.getId());
            this.getTuner().stop();
            this.mTuner = null;
        }
    }
}

