/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.manager;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.recording.RecordingTuner;
import io.github.dsheirer.source.tuner.recording.RecordingTunerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveredRecordingTuner
extends DiscoveredTuner {
    private static final Logger mLog = LoggerFactory.getLogger(DiscoveredRecordingTuner.class);
    private UserPreferences mUserPreferences;

    public DiscoveredRecordingTuner(UserPreferences userPreferences, RecordingTunerConfiguration recordingTunerConfiguration) {
        this.mUserPreferences = userPreferences;
        this.setTunerConfiguration(recordingTunerConfiguration);
        this.setEnabled(false);
    }

    public RecordingTunerConfiguration getRecordingTunerConfiguration() {
        return (RecordingTunerConfiguration)this.getTunerConfiguration();
    }

    @Override
    public TunerClass getTunerClass() {
        return TunerClass.RECORDING_TUNER;
    }

    @Override
    public String getId() {
        return this.getRecordingTunerConfiguration().getPath();
    }

    @Override
    public void start() {
        if (!this.hasTuner()) {
            this.mTuner = new RecordingTuner(this.mUserPreferences, (ITunerErrorListener)this, this.getRecordingTunerConfiguration());
            try {
                this.mTuner.start();
            }
            catch (SourceException se) {
                this.setErrorMessage("Error - " + se.getMessage());
            }
        }
    }

    public String toString() {
        return "Recording [" + this.getRecordingTunerConfiguration().getPath() + "]";
    }
}

