/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.manager;

import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.ISourceEventProcessor;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.tuner.channel.ChannelSpecification;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import io.github.dsheirer.source.tuner.channel.TunerChannelSource;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelSourceManager
implements ISourceEventProcessor {
    private Logger mLogger = LoggerFactory.getLogger(ChannelSourceManager.class);
    private Broadcaster<SourceEvent> mSourceEventBroadcaster = new Broadcaster();

    public void dispose() {
        this.mSourceEventBroadcaster.clear();
    }

    public abstract SortedSet<TunerChannel> getTunerChannels();

    public abstract String getStateDescription();

    public abstract int getTunerChannelCount();

    public abstract void stopAllChannels();

    public abstract TunerChannelSource getSource(TunerChannel var1, ChannelSpecification var2);

    public abstract void setErrorMessage(String var1);

    public void addSourceEventListener(Listener<SourceEvent> listener) {
        this.mSourceEventBroadcaster.addListener(listener);
    }

    public void removeSourceEventListener(Listener<SourceEvent> listener) {
        this.mSourceEventBroadcaster.removeListener(listener);
    }

    protected void broadcast(SourceEvent sourceEvent) {
        this.mSourceEventBroadcaster.broadcast(sourceEvent);
    }
}

