/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.frequency;

public class FrequencyLimitException
extends Exception {
    private static final long serialVersionUID = 1L;
    private long mFrequencyLimit;
    private long mRequestedFrequency;

    public FrequencyLimitException(long requestedFrequency, long frequencyLimit) {
        super("Requested frequency [" + requestedFrequency + "] exceeds the limit [" + frequencyLimit + "].  Tuned frequency was set to the limit value");
        this.mRequestedFrequency = requestedFrequency;
        this.mFrequencyLimit = frequencyLimit;
    }

    public long getRequestedFrequency() {
        return this.mRequestedFrequency;
    }

    public long getFrequencyLimit() {
        return this.mFrequencyLimit;
    }
}

