/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.fcd.proplusV2;

import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.MixerTunerType;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.fcd.FCDCommand;
import io.github.dsheirer.source.tuner.fcd.FCDTunerController;
import io.github.dsheirer.source.tuner.fcd.proplusV2.FCD2TunerConfiguration;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.TargetDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FCD2TunerController
extends FCDTunerController {
    private static final Logger mLog = LoggerFactory.getLogger(FCD2TunerController.class);
    public static final int MINIMUM_TUNABLE_FREQUENCY = 150000;
    public static final int MAXIMUM_TUNABLE_FREQUENCY = 2050000000;
    public static final int SAMPLE_RATE = 192000;

    public FCD2TunerController(TargetDataLine mixerTDL, int bus, String portAddress, ITunerErrorListener tunerErrorListener) {
        super(MixerTunerType.FUNCUBE_DONGLE_PRO_PLUS, mixerTDL, bus, portAddress, 150000, 2050000000, tunerErrorListener);
    }

    @Override
    protected void deviceStart() throws SourceException {
        this.mFrequencyController.setSampleRate(192000);
        try {
            this.setFCDMode(FCDTunerController.Mode.APPLICATION);
        }
        catch (Exception e) {
            throw new SourceException("error setting Mode to APPLICATION", e);
        }
    }

    @Override
    public double getCurrentSampleRate() {
        return 192000.0;
    }

    @Override
    public TunerClass getTunerClass() {
        return TunerClass.FUNCUBE_DONGLE_PRO_PLUS;
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.FUNCUBE_DONGLE_PRO_PLUS;
    }

    public void setLNAGain(boolean enabled) throws SourceException {
        this.send(FCDCommand.APP_SET_LNA_GAIN, enabled ? 1L : 0L);
    }

    public void setMixerGain(boolean enabled) throws SourceException {
        this.send(FCDCommand.APP_SET_MIXER_GAIN, enabled ? 1L : 0L);
    }

    @Override
    public void apply(TunerConfiguration config) throws SourceException {
        super.apply(config);
        if (config instanceof FCD2TunerConfiguration) {
            FCD2TunerConfiguration fcd2 = (FCD2TunerConfiguration)config;
            this.setLNAGain(fcd2.getGainLNA());
            this.setMixerGain(fcd2.getGainMixer());
        }
    }

    public int getDCCorrection() {
        int dcCorrection = -999;
        try {
            ByteBuffer buffer = this.send(FCDCommand.APP_GET_DC_CORRECTION);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            return buffer.getInt(2);
        }
        catch (Exception e) {
            mLog.error("error getting dc correction value", (Throwable)e);
            return dcCorrection;
        }
    }

    public void setDCCorrection(int value) {
        this.send(FCDCommand.APP_SET_DC_CORRECTION, value);
    }

    public int getIQCorrection() {
        int iqCorrection = -999;
        try {
            ByteBuffer buffer = this.send(FCDCommand.APP_GET_IQ_CORRECTION);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            return buffer.getInt(2);
        }
        catch (Exception e) {
            mLog.error("error reading IQ correction value", (Throwable)e);
            return iqCorrection;
        }
    }

    public void setIQCorrection(int value) {
        this.send(FCDCommand.APP_SET_IQ_CORRECTION, value);
    }
}

